/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.input;

import java.util.Collections;
import org.apache.spark.SparkContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.talend.bigdata.common.TestData;
import org.talend.bigdata.common.input.Reader;

public class ReaderTest {
    @Test
    public void testRowClassAndEncoderDefaults() {
        final SparkSession spark = (SparkSession)Mockito.mock(SparkSession.class);
        Mockito.when((Object)spark.sparkContext()).thenReturn((Object)((SparkContext)Mockito.mock(SparkContext.class)));
        Reader<Row> reader = new Reader<Row>(){

            public SparkSession sparkSession() {
                return spark;
            }
        };
        Assert.assertEquals(Row.class, (Object)reader.rowClass());
        Assert.assertNotNull((Object)reader.encoder());
        Assert.assertTrue((boolean)(reader.encoder() instanceof Encoder));
        Assert.assertNotNull((Object)reader.context());
        Assert.assertEquals(Collections.emptyMap(), (Object)reader.options());
    }

    @Test
    public void testCustomRowClassAndEncoder() {
        final SparkSession spark = (SparkSession)Mockito.mock(SparkSession.class);
        Mockito.when((Object)spark.sparkContext()).thenReturn((Object)((SparkContext)Mockito.mock(SparkContext.class)));
        Reader<TestData> reader = new Reader<TestData>(){

            public SparkSession sparkSession() {
                return spark;
            }

            public Class<TestData> rowClass() {
                return TestData.class;
            }
        };
        Assert.assertEquals(TestData.class, (Object)reader.rowClass());
        Assert.assertNotNull((Object)reader.encoder());
        Assert.assertTrue((boolean)(reader.encoder() instanceof Encoder));
    }
}

