/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.testutils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.io.FileUtils;

public class TestUtils {
    public static String getLineBreakByOs() {
        String osVersion = System.getProperty("os.name");
        return osVersion.startsWith("Windows") ? "\r\n" : "\n";
    }

    public static String setTimeZone(String timeZone) {
        String originalTimeZone = TimeZone.getDefault().getID();
        TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        return originalTimeZone;
    }

    public static void setOriginalTimeZone(String originalTimeZone) {
        TimeZone.setDefault(TimeZone.getTimeZone(originalTimeZone));
    }

    public static Date getDate(int year, int month, int day, int hour, int minute, int second, String zoneId) {
        return Date.from(LocalDateTime.of(year, month, day, hour, minute, second).atZone(ZoneId.of(zoneId)).toInstant());
    }

    public static Path getResourceFileUrlInsideTempFolder(String filePath, String tempFolderPath, Class callingClass) {
        File targetFile = new File(tempFolderPath + "/" + filePath);
        try (InputStream inputStream = callingClass.getClassLoader().getResourceAsStream(filePath);){
            assert (inputStream != null);
            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)targetFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return targetFile.toPath();
    }
}

