/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.input;

import java.util.Collections;
import java.util.Map;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.immutables.value.Value;

public interface Reader<T> {
    @Value.Parameter
    public SparkSession sparkSession();

    @Value.Default
    default public Class<T> rowClass() {
        return Row.class;
    }

    @Value.Default
    default public Encoder<T> encoder() {
        return Row.class.equals(this.rowClass()) ? Encoders.kryo(Row.class) : Encoders.kryo(this.rowClass());
    }

    @Value.Derived
    default public JavaSparkContext context() {
        return JavaSparkContext.fromSparkContext((SparkContext)this.sparkSession().sparkContext());
    }

    @Value.Default
    default public Map<String, String> options() {
        return Collections.emptyMap();
    }
}

