/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.storage;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hadoop.fs.FileSystem;
import org.immutables.value.Generated;
import org.talend.bigdata.common.storage.GoogleStorage;
import org.talend.bigdata.common.storage.Storage;

@ParametersAreNonnullByDefault
@Generated(from="GoogleStorage", generator="Immutables")
public final class ImmutableGoogleStorage {
    private ImmutableGoogleStorage() {
    }

    @CheckReturnValue
    @Generated(from="GoogleStorage.Configuration", generator="Immutables")
    @Immutable
    public static final class Configuration
    implements GoogleStorage.Configuration {
        private final ImmutableMap<String, String> configuration;
        private final URI bucket;
        private final transient FileSystem fileSystem;

        private Configuration(ImmutableMap<String, String> configuration, URI bucket) {
            this.configuration = configuration;
            this.bucket = bucket;
            this.fileSystem = Objects.requireNonNull(GoogleStorage.Configuration.super.fileSystem(), "fileSystem");
        }

        public ImmutableMap<String, String> configuration() {
            return this.configuration;
        }

        @Override
        public URI bucket() {
            return this.bucket;
        }

        @Override
        public FileSystem fileSystem() {
            return this.fileSystem;
        }

        public final Configuration withConfiguration(Map<String, ? extends String> entries) {
            if (this.configuration == entries) {
                return this;
            }
            ImmutableMap newValue = ImmutableMap.copyOf(entries);
            return new Configuration((ImmutableMap<String, String>)newValue, this.bucket);
        }

        public final Configuration withBucket(URI value) {
            if (this.bucket == value) {
                return this;
            }
            URI newValue = Objects.requireNonNull(value, "bucket");
            return new Configuration(this.configuration, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Configuration && this.equalTo(0, (Configuration)another);
        }

        private boolean equalTo(int synthetic, Configuration another) {
            return this.configuration.equals(another.configuration) && this.bucket.equals(another.bucket) && this.fileSystem.equals(another.fileSystem);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.configuration.hashCode();
            h += (h << 5) + this.bucket.hashCode();
            h += (h << 5) + this.fileSystem.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Configuration").omitNullValues().add("configuration", this.configuration).add("bucket", (Object)this.bucket).add("fileSystem", (Object)this.fileSystem).toString();
        }

        public static Configuration copyOf(GoogleStorage.Configuration instance) {
            if (instance instanceof Configuration) {
                return (Configuration)instance;
            }
            return Configuration.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="GoogleStorage.Configuration", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_BUCKET = 1L;
            private long initBits = 1L;
            private ImmutableMap.Builder<String, String> configuration = ImmutableMap.builder();
            @Nullable
            private URI bucket;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(GoogleStorage.Configuration instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(Storage.Configuration instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Storage.Configuration instance;
                long bits = 0L;
                if (object instanceof GoogleStorage.Configuration) {
                    instance = (GoogleStorage.Configuration)object;
                    this.bucket(instance.bucket());
                    if ((bits & 1L) == 0L) {
                        this.putAllConfiguration(instance.configuration());
                        bits |= 1L;
                    }
                }
                if (object instanceof Storage.Configuration) {
                    instance = (Storage.Configuration)object;
                    if ((bits & 1L) == 0L) {
                        this.putAllConfiguration(instance.configuration());
                        bits |= 1L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder putConfiguration(String key, String value) {
                this.configuration.put((Object)key, (Object)value);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder putConfiguration(Map.Entry<String, ? extends String> entry) {
                this.configuration.put(entry);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder configuration(Map<String, ? extends String> entries) {
                this.configuration = ImmutableMap.builder();
                return this.putAllConfiguration(entries);
            }

            @CanIgnoreReturnValue
            public final Builder putAllConfiguration(Map<String, ? extends String> entries) {
                this.configuration.putAll(entries);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder bucket(URI bucket) {
                this.bucket = Objects.requireNonNull(bucket, "bucket");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            public Configuration build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Configuration((ImmutableMap<String, String>)this.configuration.build(), this.bucket);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("bucket");
                }
                return "Cannot build Configuration, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="GoogleStorage.GoogleCredentials", generator="Immutables")
    @Immutable
    public static final class GoogleCredentials
    implements GoogleStorage.GoogleCredentials {
        private final String type;
        private final String projectId;
        private final String privateKeyId;
        private final String privateKey;
        private final String clientEmail;
        private final String clientId;
        private final String authUri;
        private final String tokenUri;
        private final String authProviderX509CertUrl;
        private final String clientX509CertUrl;

        private GoogleCredentials(String type, String projectId, String privateKeyId, String privateKey, String clientEmail, String clientId, String authUri, String tokenUri, String authProviderX509CertUrl, String clientX509CertUrl) {
            this.type = type;
            this.projectId = projectId;
            this.privateKeyId = privateKeyId;
            this.privateKey = privateKey;
            this.clientEmail = clientEmail;
            this.clientId = clientId;
            this.authUri = authUri;
            this.tokenUri = tokenUri;
            this.authProviderX509CertUrl = authProviderX509CertUrl;
            this.clientX509CertUrl = clientX509CertUrl;
        }

        @Override
        @JsonProperty(value="type")
        public String type() {
            return this.type;
        }

        @Override
        @JsonProperty(value="project_id")
        public String projectId() {
            return this.projectId;
        }

        @Override
        @JsonProperty(value="private_key_id")
        public String privateKeyId() {
            return this.privateKeyId;
        }

        @Override
        @JsonProperty(value="private_key")
        public String privateKey() {
            return this.privateKey;
        }

        @Override
        @JsonProperty(value="client_email")
        public String clientEmail() {
            return this.clientEmail;
        }

        @Override
        @JsonProperty(value="client_id")
        public String clientId() {
            return this.clientId;
        }

        @Override
        @JsonProperty(value="auth_uri")
        public String authUri() {
            return this.authUri;
        }

        @Override
        @JsonProperty(value="token_uri")
        public String tokenUri() {
            return this.tokenUri;
        }

        @Override
        @JsonProperty(value="auth_provider_x509_cert_url")
        public String authProviderX509CertUrl() {
            return this.authProviderX509CertUrl;
        }

        @Override
        @JsonProperty(value="client_x509_cert_url")
        public String clientX509CertUrl() {
            return this.clientX509CertUrl;
        }

        public final GoogleCredentials withType(String value) {
            String newValue = Objects.requireNonNull(value, "type");
            if (this.type.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(newValue, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withProjectId(String value) {
            String newValue = Objects.requireNonNull(value, "projectId");
            if (this.projectId.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, newValue, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withPrivateKeyId(String value) {
            String newValue = Objects.requireNonNull(value, "privateKeyId");
            if (this.privateKeyId.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, newValue, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withPrivateKey(String value) {
            String newValue = Objects.requireNonNull(value, "privateKey");
            if (this.privateKey.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, newValue, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withClientEmail(String value) {
            String newValue = Objects.requireNonNull(value, "clientEmail");
            if (this.clientEmail.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, newValue, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withClientId(String value) {
            String newValue = Objects.requireNonNull(value, "clientId");
            if (this.clientId.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, newValue, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withAuthUri(String value) {
            String newValue = Objects.requireNonNull(value, "authUri");
            if (this.authUri.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, newValue, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withTokenUri(String value) {
            String newValue = Objects.requireNonNull(value, "tokenUri");
            if (this.tokenUri.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, newValue, this.authProviderX509CertUrl, this.clientX509CertUrl);
        }

        public final GoogleCredentials withAuthProviderX509CertUrl(String value) {
            String newValue = Objects.requireNonNull(value, "authProviderX509CertUrl");
            if (this.authProviderX509CertUrl.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, newValue, this.clientX509CertUrl);
        }

        public final GoogleCredentials withClientX509CertUrl(String value) {
            String newValue = Objects.requireNonNull(value, "clientX509CertUrl");
            if (this.clientX509CertUrl.equals(newValue)) {
                return this;
            }
            return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof GoogleCredentials && this.equalTo(0, (GoogleCredentials)another);
        }

        private boolean equalTo(int synthetic, GoogleCredentials another) {
            return this.type.equals(another.type) && this.projectId.equals(another.projectId) && this.privateKeyId.equals(another.privateKeyId) && this.privateKey.equals(another.privateKey) && this.clientEmail.equals(another.clientEmail) && this.clientId.equals(another.clientId) && this.authUri.equals(another.authUri) && this.tokenUri.equals(another.tokenUri) && this.authProviderX509CertUrl.equals(another.authProviderX509CertUrl) && this.clientX509CertUrl.equals(another.clientX509CertUrl);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.type.hashCode();
            h += (h << 5) + this.projectId.hashCode();
            h += (h << 5) + this.privateKeyId.hashCode();
            h += (h << 5) + this.privateKey.hashCode();
            h += (h << 5) + this.clientEmail.hashCode();
            h += (h << 5) + this.clientId.hashCode();
            h += (h << 5) + this.authUri.hashCode();
            h += (h << 5) + this.tokenUri.hashCode();
            h += (h << 5) + this.authProviderX509CertUrl.hashCode();
            h += (h << 5) + this.clientX509CertUrl.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"GoogleCredentials").omitNullValues().add("type", (Object)this.type).add("projectId", (Object)this.projectId).add("privateKeyId", (Object)this.privateKeyId).add("privateKey", (Object)this.privateKey).add("clientEmail", (Object)this.clientEmail).add("clientId", (Object)this.clientId).add("authUri", (Object)this.authUri).add("tokenUri", (Object)this.tokenUri).add("authProviderX509CertUrl", (Object)this.authProviderX509CertUrl).add("clientX509CertUrl", (Object)this.clientX509CertUrl).toString();
        }

        @Deprecated
        @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
        static GoogleCredentials fromJson(Json json) {
            Builder builder = GoogleCredentials.builder();
            if (json.type != null) {
                builder.type(json.type);
            }
            if (json.projectId != null) {
                builder.projectId(json.projectId);
            }
            if (json.privateKeyId != null) {
                builder.privateKeyId(json.privateKeyId);
            }
            if (json.privateKey != null) {
                builder.privateKey(json.privateKey);
            }
            if (json.clientEmail != null) {
                builder.clientEmail(json.clientEmail);
            }
            if (json.clientId != null) {
                builder.clientId(json.clientId);
            }
            if (json.authUri != null) {
                builder.authUri(json.authUri);
            }
            if (json.tokenUri != null) {
                builder.tokenUri(json.tokenUri);
            }
            if (json.authProviderX509CertUrl != null) {
                builder.authProviderX509CertUrl(json.authProviderX509CertUrl);
            }
            if (json.clientX509CertUrl != null) {
                builder.clientX509CertUrl(json.clientX509CertUrl);
            }
            return builder.build();
        }

        public static GoogleCredentials copyOf(GoogleStorage.GoogleCredentials instance) {
            if (instance instanceof GoogleCredentials) {
                return (GoogleCredentials)instance;
            }
            return GoogleCredentials.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="GoogleStorage.GoogleCredentials", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TYPE = 1L;
            private static final long INIT_BIT_PROJECT_ID = 2L;
            private static final long INIT_BIT_PRIVATE_KEY_ID = 4L;
            private static final long INIT_BIT_PRIVATE_KEY = 8L;
            private static final long INIT_BIT_CLIENT_EMAIL = 16L;
            private static final long INIT_BIT_CLIENT_ID = 32L;
            private static final long INIT_BIT_AUTH_URI = 64L;
            private static final long INIT_BIT_TOKEN_URI = 128L;
            private static final long INIT_BIT_AUTH_PROVIDER_X509_CERT_URL = 256L;
            private static final long INIT_BIT_CLIENT_X509_CERT_URL = 512L;
            private long initBits = 1023L;
            @Nullable
            private String type;
            @Nullable
            private String projectId;
            @Nullable
            private String privateKeyId;
            @Nullable
            private String privateKey;
            @Nullable
            private String clientEmail;
            @Nullable
            private String clientId;
            @Nullable
            private String authUri;
            @Nullable
            private String tokenUri;
            @Nullable
            private String authProviderX509CertUrl;
            @Nullable
            private String clientX509CertUrl;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(GoogleStorage.GoogleCredentials instance) {
                Objects.requireNonNull(instance, "instance");
                this.type(instance.type());
                this.projectId(instance.projectId());
                this.privateKeyId(instance.privateKeyId());
                this.privateKey(instance.privateKey());
                this.clientEmail(instance.clientEmail());
                this.clientId(instance.clientId());
                this.authUri(instance.authUri());
                this.tokenUri(instance.tokenUri());
                this.authProviderX509CertUrl(instance.authProviderX509CertUrl());
                this.clientX509CertUrl(instance.clientX509CertUrl());
                return this;
            }

            @JsonProperty(value="type")
            @CanIgnoreReturnValue
            public final Builder type(String type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @JsonProperty(value="project_id")
            @CanIgnoreReturnValue
            public final Builder projectId(String projectId) {
                this.projectId = Objects.requireNonNull(projectId, "projectId");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @JsonProperty(value="private_key_id")
            @CanIgnoreReturnValue
            public final Builder privateKeyId(String privateKeyId) {
                this.privateKeyId = Objects.requireNonNull(privateKeyId, "privateKeyId");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @JsonProperty(value="private_key")
            @CanIgnoreReturnValue
            public final Builder privateKey(String privateKey) {
                this.privateKey = Objects.requireNonNull(privateKey, "privateKey");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @JsonProperty(value="client_email")
            @CanIgnoreReturnValue
            public final Builder clientEmail(String clientEmail) {
                this.clientEmail = Objects.requireNonNull(clientEmail, "clientEmail");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @JsonProperty(value="client_id")
            @CanIgnoreReturnValue
            public final Builder clientId(String clientId) {
                this.clientId = Objects.requireNonNull(clientId, "clientId");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            @JsonProperty(value="auth_uri")
            @CanIgnoreReturnValue
            public final Builder authUri(String authUri) {
                this.authUri = Objects.requireNonNull(authUri, "authUri");
                this.initBits &= 0xFFFFFFFFFFFFFFBFL;
                return this;
            }

            @JsonProperty(value="token_uri")
            @CanIgnoreReturnValue
            public final Builder tokenUri(String tokenUri) {
                this.tokenUri = Objects.requireNonNull(tokenUri, "tokenUri");
                this.initBits &= 0xFFFFFFFFFFFFFF7FL;
                return this;
            }

            @JsonProperty(value="auth_provider_x509_cert_url")
            @CanIgnoreReturnValue
            public final Builder authProviderX509CertUrl(String authProviderX509CertUrl) {
                this.authProviderX509CertUrl = Objects.requireNonNull(authProviderX509CertUrl, "authProviderX509CertUrl");
                this.initBits &= 0xFFFFFFFFFFFFFEFFL;
                return this;
            }

            @JsonProperty(value="client_x509_cert_url")
            @CanIgnoreReturnValue
            public final Builder clientX509CertUrl(String clientX509CertUrl) {
                this.clientX509CertUrl = Objects.requireNonNull(clientX509CertUrl, "clientX509CertUrl");
                this.initBits &= 0xFFFFFFFFFFFFFDFFL;
                return this;
            }

            public GoogleCredentials build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new GoogleCredentials(this.type, this.projectId, this.privateKeyId, this.privateKey, this.clientEmail, this.clientId, this.authUri, this.tokenUri, this.authProviderX509CertUrl, this.clientX509CertUrl);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("type");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("projectId");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("privateKeyId");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("privateKey");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("clientEmail");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("clientId");
                }
                if ((this.initBits & 0x40L) != 0L) {
                    attributes.add("authUri");
                }
                if ((this.initBits & 0x80L) != 0L) {
                    attributes.add("tokenUri");
                }
                if ((this.initBits & 0x100L) != 0L) {
                    attributes.add("authProviderX509CertUrl");
                }
                if ((this.initBits & 0x200L) != 0L) {
                    attributes.add("clientX509CertUrl");
                }
                return "Cannot build GoogleCredentials, some of required attributes are not set " + attributes;
            }
        }

        @Deprecated
        @JsonDeserialize
        @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
        @Generated(from="GoogleStorage.GoogleCredentials", generator="Immutables")
        static final class Json
        implements GoogleStorage.GoogleCredentials {
            @Nullable
            String type;
            @Nullable
            String projectId;
            @Nullable
            String privateKeyId;
            @Nullable
            String privateKey;
            @Nullable
            String clientEmail;
            @Nullable
            String clientId;
            @Nullable
            String authUri;
            @Nullable
            String tokenUri;
            @Nullable
            String authProviderX509CertUrl;
            @Nullable
            String clientX509CertUrl;

            Json() {
            }

            @JsonProperty(value="type")
            public void setType(String type) {
                this.type = type;
            }

            @JsonProperty(value="project_id")
            public void setProjectId(String projectId) {
                this.projectId = projectId;
            }

            @JsonProperty(value="private_key_id")
            public void setPrivateKeyId(String privateKeyId) {
                this.privateKeyId = privateKeyId;
            }

            @JsonProperty(value="private_key")
            public void setPrivateKey(String privateKey) {
                this.privateKey = privateKey;
            }

            @JsonProperty(value="client_email")
            public void setClientEmail(String clientEmail) {
                this.clientEmail = clientEmail;
            }

            @JsonProperty(value="client_id")
            public void setClientId(String clientId) {
                this.clientId = clientId;
            }

            @JsonProperty(value="auth_uri")
            public void setAuthUri(String authUri) {
                this.authUri = authUri;
            }

            @JsonProperty(value="token_uri")
            public void setTokenUri(String tokenUri) {
                this.tokenUri = tokenUri;
            }

            @JsonProperty(value="auth_provider_x509_cert_url")
            public void setAuthProviderX509CertUrl(String authProviderX509CertUrl) {
                this.authProviderX509CertUrl = authProviderX509CertUrl;
            }

            @JsonProperty(value="client_x509_cert_url")
            public void setClientX509CertUrl(String clientX509CertUrl) {
                this.clientX509CertUrl = clientX509CertUrl;
            }

            @Override
            public String type() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String projectId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String privateKeyId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String privateKey() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String clientEmail() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String clientId() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String authUri() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String tokenUri() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String authProviderX509CertUrl() {
                throw new UnsupportedOperationException();
            }

            @Override
            public String clientX509CertUrl() {
                throw new UnsupportedOperationException();
            }
        }
    }

    @CheckReturnValue
    @Generated(from="GoogleStorage.WithServiceAccount", generator="Immutables")
    @Immutable
    public static final class WithServiceAccount
    implements GoogleStorage.WithServiceAccount {
        private final String temporaryFolder;
        private final String id;
        private final String projectId;
        private final String bucket;
        private final URI credentialsFile;
        private final String accountServiceIdentifier;

        private WithServiceAccount(String temporaryFolder, String id, String projectId, String bucket, URI credentialsFile, String accountServiceIdentifier) {
            this.temporaryFolder = temporaryFolder;
            this.id = id;
            this.projectId = projectId;
            this.bucket = bucket;
            this.credentialsFile = credentialsFile;
            this.accountServiceIdentifier = accountServiceIdentifier;
        }

        @Override
        public String temporaryFolder() {
            return this.temporaryFolder;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String projectId() {
            return this.projectId;
        }

        @Override
        public String bucket() {
            return this.bucket;
        }

        @Override
        public URI credentialsFile() {
            return this.credentialsFile;
        }

        @Override
        public String accountServiceIdentifier() {
            return this.accountServiceIdentifier;
        }

        public final WithServiceAccount withTemporaryFolder(String value) {
            String newValue = Objects.requireNonNull(value, "temporaryFolder");
            if (this.temporaryFolder.equals(newValue)) {
                return this;
            }
            return new WithServiceAccount(newValue, this.id, this.projectId, this.bucket, this.credentialsFile, this.accountServiceIdentifier);
        }

        public final WithServiceAccount withId(String value) {
            String newValue = Objects.requireNonNull(value, "id");
            if (this.id.equals(newValue)) {
                return this;
            }
            return new WithServiceAccount(this.temporaryFolder, newValue, this.projectId, this.bucket, this.credentialsFile, this.accountServiceIdentifier);
        }

        public final WithServiceAccount withProjectId(String value) {
            String newValue = Objects.requireNonNull(value, "projectId");
            if (this.projectId.equals(newValue)) {
                return this;
            }
            return new WithServiceAccount(this.temporaryFolder, this.id, newValue, this.bucket, this.credentialsFile, this.accountServiceIdentifier);
        }

        public final WithServiceAccount withBucket(String value) {
            String newValue = Objects.requireNonNull(value, "bucket");
            if (this.bucket.equals(newValue)) {
                return this;
            }
            return new WithServiceAccount(this.temporaryFolder, this.id, this.projectId, newValue, this.credentialsFile, this.accountServiceIdentifier);
        }

        public final WithServiceAccount withCredentialsFile(URI value) {
            if (this.credentialsFile == value) {
                return this;
            }
            URI newValue = Objects.requireNonNull(value, "credentialsFile");
            return new WithServiceAccount(this.temporaryFolder, this.id, this.projectId, this.bucket, newValue, this.accountServiceIdentifier);
        }

        public final WithServiceAccount withAccountServiceIdentifier(String value) {
            String newValue = Objects.requireNonNull(value, "accountServiceIdentifier");
            if (this.accountServiceIdentifier.equals(newValue)) {
                return this;
            }
            return new WithServiceAccount(this.temporaryFolder, this.id, this.projectId, this.bucket, this.credentialsFile, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof WithServiceAccount && this.equalTo(0, (WithServiceAccount)another);
        }

        private boolean equalTo(int synthetic, WithServiceAccount another) {
            return this.temporaryFolder.equals(another.temporaryFolder) && this.id.equals(another.id) && this.projectId.equals(another.projectId) && this.bucket.equals(another.bucket) && this.credentialsFile.equals(another.credentialsFile) && this.accountServiceIdentifier.equals(another.accountServiceIdentifier);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.temporaryFolder.hashCode();
            h += (h << 5) + this.id.hashCode();
            h += (h << 5) + this.projectId.hashCode();
            h += (h << 5) + this.bucket.hashCode();
            h += (h << 5) + this.credentialsFile.hashCode();
            h += (h << 5) + this.accountServiceIdentifier.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"WithServiceAccount").omitNullValues().add("temporaryFolder", (Object)this.temporaryFolder).add("id", (Object)this.id).add("projectId", (Object)this.projectId).add("bucket", (Object)this.bucket).add("credentialsFile", (Object)this.credentialsFile).add("accountServiceIdentifier", (Object)this.accountServiceIdentifier).toString();
        }

        public static WithServiceAccount copyOf(GoogleStorage.WithServiceAccount instance) {
            if (instance instanceof WithServiceAccount) {
                return (WithServiceAccount)instance;
            }
            return WithServiceAccount.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="GoogleStorage.WithServiceAccount", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TEMPORARY_FOLDER = 1L;
            private static final long INIT_BIT_ID = 2L;
            private static final long INIT_BIT_PROJECT_ID = 4L;
            private static final long INIT_BIT_BUCKET = 8L;
            private static final long INIT_BIT_CREDENTIALS_FILE = 16L;
            private static final long INIT_BIT_ACCOUNT_SERVICE_IDENTIFIER = 32L;
            private long initBits = 63L;
            @Nullable
            private String temporaryFolder;
            @Nullable
            private String id;
            @Nullable
            private String projectId;
            @Nullable
            private String bucket;
            @Nullable
            private URI credentialsFile;
            @Nullable
            private String accountServiceIdentifier;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(GoogleStorage instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(GoogleStorage.WithServiceAccount instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(Storage instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Storage instance;
                long bits = 0L;
                if (object instanceof GoogleStorage) {
                    instance = (GoogleStorage)object;
                    if ((bits & 1L) == 0L) {
                        this.bucket(instance.bucket());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.credentialsFile(instance.credentialsFile());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.temporaryFolder(instance.temporaryFolder());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.id(instance.id());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.projectId(instance.projectId());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof GoogleStorage.WithServiceAccount) {
                    instance = (GoogleStorage.WithServiceAccount)object;
                    if ((bits & 1L) == 0L) {
                        this.bucket(instance.bucket());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.credentialsFile(instance.credentialsFile());
                        bits |= 2L;
                    }
                    this.accountServiceIdentifier(instance.accountServiceIdentifier());
                    if ((bits & 4L) == 0L) {
                        this.temporaryFolder(instance.temporaryFolder());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.id(instance.id());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.projectId(instance.projectId());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof Storage) {
                    instance = (Storage)object;
                    if ((bits & 4L) == 0L) {
                        this.temporaryFolder(instance.temporaryFolder());
                        bits |= 4L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder temporaryFolder(String temporaryFolder) {
                this.temporaryFolder = Objects.requireNonNull(temporaryFolder, "temporaryFolder");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder id(String id) {
                this.id = Objects.requireNonNull(id, "id");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder projectId(String projectId) {
                this.projectId = Objects.requireNonNull(projectId, "projectId");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder bucket(String bucket) {
                this.bucket = Objects.requireNonNull(bucket, "bucket");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder credentialsFile(URI credentialsFile) {
                this.credentialsFile = Objects.requireNonNull(credentialsFile, "credentialsFile");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder accountServiceIdentifier(String accountServiceIdentifier) {
                this.accountServiceIdentifier = Objects.requireNonNull(accountServiceIdentifier, "accountServiceIdentifier");
                this.initBits &= 0xFFFFFFFFFFFFFFDFL;
                return this;
            }

            public WithServiceAccount build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new WithServiceAccount(this.temporaryFolder, this.id, this.projectId, this.bucket, this.credentialsFile, this.accountServiceIdentifier);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("temporaryFolder");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("id");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("projectId");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("bucket");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("credentialsFile");
                }
                if ((this.initBits & 0x20L) != 0L) {
                    attributes.add("accountServiceIdentifier");
                }
                return "Cannot build WithServiceAccount, some of required attributes are not set " + attributes;
            }
        }
    }

    @CheckReturnValue
    @Generated(from="GoogleStorage.Simple", generator="Immutables")
    @Immutable
    public static final class Simple
    implements GoogleStorage.Simple {
        private final String temporaryFolder;
        private final String id;
        private final String projectId;
        private final String bucket;
        private final URI credentialsFile;

        private Simple(String temporaryFolder, String id, String projectId, String bucket, URI credentialsFile) {
            this.temporaryFolder = temporaryFolder;
            this.id = id;
            this.projectId = projectId;
            this.bucket = bucket;
            this.credentialsFile = credentialsFile;
        }

        @Override
        public String temporaryFolder() {
            return this.temporaryFolder;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public String projectId() {
            return this.projectId;
        }

        @Override
        public String bucket() {
            return this.bucket;
        }

        @Override
        public URI credentialsFile() {
            return this.credentialsFile;
        }

        public final Simple withTemporaryFolder(String value) {
            String newValue = Objects.requireNonNull(value, "temporaryFolder");
            if (this.temporaryFolder.equals(newValue)) {
                return this;
            }
            return new Simple(newValue, this.id, this.projectId, this.bucket, this.credentialsFile);
        }

        public final Simple withId(String value) {
            String newValue = Objects.requireNonNull(value, "id");
            if (this.id.equals(newValue)) {
                return this;
            }
            return new Simple(this.temporaryFolder, newValue, this.projectId, this.bucket, this.credentialsFile);
        }

        public final Simple withProjectId(String value) {
            String newValue = Objects.requireNonNull(value, "projectId");
            if (this.projectId.equals(newValue)) {
                return this;
            }
            return new Simple(this.temporaryFolder, this.id, newValue, this.bucket, this.credentialsFile);
        }

        public final Simple withBucket(String value) {
            String newValue = Objects.requireNonNull(value, "bucket");
            if (this.bucket.equals(newValue)) {
                return this;
            }
            return new Simple(this.temporaryFolder, this.id, this.projectId, newValue, this.credentialsFile);
        }

        public final Simple withCredentialsFile(URI value) {
            if (this.credentialsFile == value) {
                return this;
            }
            URI newValue = Objects.requireNonNull(value, "credentialsFile");
            return new Simple(this.temporaryFolder, this.id, this.projectId, this.bucket, newValue);
        }

        public boolean equals(@Nullable Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof Simple && this.equalTo(0, (Simple)another);
        }

        private boolean equalTo(int synthetic, Simple another) {
            return this.temporaryFolder.equals(another.temporaryFolder) && this.id.equals(another.id) && this.projectId.equals(another.projectId) && this.bucket.equals(another.bucket) && this.credentialsFile.equals(another.credentialsFile);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.temporaryFolder.hashCode();
            h += (h << 5) + this.id.hashCode();
            h += (h << 5) + this.projectId.hashCode();
            h += (h << 5) + this.bucket.hashCode();
            h += (h << 5) + this.credentialsFile.hashCode();
            return h;
        }

        public String toString() {
            return MoreObjects.toStringHelper((String)"Simple").omitNullValues().add("temporaryFolder", (Object)this.temporaryFolder).add("id", (Object)this.id).add("projectId", (Object)this.projectId).add("bucket", (Object)this.bucket).add("credentialsFile", (Object)this.credentialsFile).toString();
        }

        public static Simple copyOf(GoogleStorage.Simple instance) {
            if (instance instanceof Simple) {
                return (Simple)instance;
            }
            return Simple.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="GoogleStorage.Simple", generator="Immutables")
        @NotThreadSafe
        public static final class Builder {
            private static final long INIT_BIT_TEMPORARY_FOLDER = 1L;
            private static final long INIT_BIT_ID = 2L;
            private static final long INIT_BIT_PROJECT_ID = 4L;
            private static final long INIT_BIT_BUCKET = 8L;
            private static final long INIT_BIT_CREDENTIALS_FILE = 16L;
            private long initBits = 31L;
            @Nullable
            private String temporaryFolder;
            @Nullable
            private String id;
            @Nullable
            private String projectId;
            @Nullable
            private String bucket;
            @Nullable
            private URI credentialsFile;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(GoogleStorage.Simple instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(GoogleStorage instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(Storage instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                Storage instance;
                long bits = 0L;
                if (object instanceof GoogleStorage.Simple) {
                    instance = (GoogleStorage.Simple)object;
                    if ((bits & 1L) == 0L) {
                        this.bucket(instance.bucket());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.credentialsFile(instance.credentialsFile());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.temporaryFolder(instance.temporaryFolder());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.id(instance.id());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.projectId(instance.projectId());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof GoogleStorage) {
                    instance = (GoogleStorage)object;
                    if ((bits & 1L) == 0L) {
                        this.bucket(instance.bucket());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.credentialsFile(instance.credentialsFile());
                        bits |= 2L;
                    }
                    if ((bits & 4L) == 0L) {
                        this.temporaryFolder(instance.temporaryFolder());
                        bits |= 4L;
                    }
                    if ((bits & 8L) == 0L) {
                        this.id(instance.id());
                        bits |= 8L;
                    }
                    if ((bits & 0x10L) == 0L) {
                        this.projectId(instance.projectId());
                        bits |= 0x10L;
                    }
                }
                if (object instanceof Storage) {
                    instance = (Storage)object;
                    if ((bits & 4L) == 0L) {
                        this.temporaryFolder(instance.temporaryFolder());
                        bits |= 4L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder temporaryFolder(String temporaryFolder) {
                this.temporaryFolder = Objects.requireNonNull(temporaryFolder, "temporaryFolder");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder id(String id) {
                this.id = Objects.requireNonNull(id, "id");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder projectId(String projectId) {
                this.projectId = Objects.requireNonNull(projectId, "projectId");
                this.initBits &= 0xFFFFFFFFFFFFFFFBL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder bucket(String bucket) {
                this.bucket = Objects.requireNonNull(bucket, "bucket");
                this.initBits &= 0xFFFFFFFFFFFFFFF7L;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder credentialsFile(URI credentialsFile) {
                this.credentialsFile = Objects.requireNonNull(credentialsFile, "credentialsFile");
                this.initBits &= 0xFFFFFFFFFFFFFFEFL;
                return this;
            }

            public Simple build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new Simple(this.temporaryFolder, this.id, this.projectId, this.bucket, this.credentialsFile);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("temporaryFolder");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("id");
                }
                if ((this.initBits & 4L) != 0L) {
                    attributes.add("projectId");
                }
                if ((this.initBits & 8L) != 0L) {
                    attributes.add("bucket");
                }
                if ((this.initBits & 0x10L) != 0L) {
                    attributes.add("credentialsFile");
                }
                return "Cannot build Simple, some of required attributes are not set " + attributes;
            }
        }
    }
}

