/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.tfileinput.parquet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.tfileinput.parquet.tFileInputParquetBase;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="tFileInputParquetBase", generator="Immutables")
@Immutable
public final class ImmutableTFileInputParquetBase
implements tFileInputParquetBase {
    private final SparkSession sparkSession;
    private final Class<Row> rowClass;
    private final Encoder<Row> encoder;
    private final JavaSparkContext context;
    private final ImmutableMap<String, String> options;
    private final URI previousURI;
    private final boolean isS3StorageWithBucketNameSpecified;
    private final boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
    private final boolean isGSSparkStorageWithDBKSparkMode;
    private final boolean isHdfsStorageClass;
    private final boolean useCDPKnox;
    private final boolean isSetHadoopConf;
    private final String gSStorageName;
    private final String s3UriExtractedFromPath;
    private final String uriPrefixHadoopConf;
    private final Class<?> gSClass;
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    private final boolean readDatesInLocalTimeZone;
    private final ImmutableList<String> paths;
    private final List<String> pathsWithPrefix;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTFileInputParquetBase(SparkSession sparkSession, Iterable<String> paths) {
        this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
        this.paths = ImmutableList.copyOf(paths);
        this.schemaFieldDescriptions = ImmutableList.of();
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.previousURI = this.initShim.previousURI();
        this.isS3StorageWithBucketNameSpecified = this.initShim.isS3StorageWithBucketNameSpecified();
        this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration = this.initShim.isNotEmptyHadoopPrefixWithDefineStorageConfiguration();
        this.isGSSparkStorageWithDBKSparkMode = this.initShim.isGSSparkStorageWithDBKSparkMode();
        this.isHdfsStorageClass = this.initShim.isHdfsStorageClass();
        this.useCDPKnox = this.initShim.useCDPKnox();
        this.isSetHadoopConf = this.initShim.isSetHadoopConf();
        this.gSStorageName = this.initShim.gSStorageName();
        this.s3UriExtractedFromPath = this.initShim.s3UriExtractedFromPath();
        this.uriPrefixHadoopConf = this.initShim.uriPrefixHadoopConf();
        this.gSClass = this.initShim.gSClass();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.readDatesInLocalTimeZone = this.initShim.readDatesInLocalTimeZone();
        this.pathsWithPrefix = this.initShim.pathsWithPrefix();
        this.initShim = null;
    }

    private ImmutableTFileInputParquetBase(Builder builder) {
        this.sparkSession = builder.sparkSession;
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        this.paths = builder.paths.build();
        if (builder.rowClass != null) {
            this.initShim.rowClass(builder.rowClass);
        }
        if (builder.encoder != null) {
            this.initShim.encoder(builder.encoder);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options((ImmutableMap<String, String>)builder.options.build());
        }
        if (builder.isS3StorageWithBucketNameSpecifiedIsSet()) {
            this.initShim.isS3StorageWithBucketNameSpecified(builder.isS3StorageWithBucketNameSpecified);
        }
        if (builder.isNotEmptyHadoopPrefixWithDefineStorageConfigurationIsSet()) {
            this.initShim.isNotEmptyHadoopPrefixWithDefineStorageConfiguration(builder.isNotEmptyHadoopPrefixWithDefineStorageConfiguration);
        }
        if (builder.isGSSparkStorageWithDBKSparkModeIsSet()) {
            this.initShim.isGSSparkStorageWithDBKSparkMode(builder.isGSSparkStorageWithDBKSparkMode);
        }
        if (builder.isHdfsStorageClassIsSet()) {
            this.initShim.isHdfsStorageClass(builder.isHdfsStorageClass);
        }
        if (builder.useCDPKnoxIsSet()) {
            this.initShim.useCDPKnox(builder.useCDPKnox);
        }
        if (builder.isSetHadoopConfIsSet()) {
            this.initShim.isSetHadoopConf(builder.isSetHadoopConf);
        }
        if (builder.gSStorageName != null) {
            this.initShim.gSStorageName(builder.gSStorageName);
        }
        if (builder.s3UriExtractedFromPath != null) {
            this.initShim.s3UriExtractedFromPath(builder.s3UriExtractedFromPath);
        }
        if (builder.uriPrefixHadoopConf != null) {
            this.initShim.uriPrefixHadoopConf(builder.uriPrefixHadoopConf);
        }
        if (builder.gSClass != null) {
            this.initShim.gSClass(builder.gSClass);
        }
        if (builder.readDatesInLocalTimeZoneIsSet()) {
            this.initShim.readDatesInLocalTimeZone(builder.readDatesInLocalTimeZone);
        }
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.previousURI = this.initShim.previousURI();
        this.isS3StorageWithBucketNameSpecified = this.initShim.isS3StorageWithBucketNameSpecified();
        this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration = this.initShim.isNotEmptyHadoopPrefixWithDefineStorageConfiguration();
        this.isGSSparkStorageWithDBKSparkMode = this.initShim.isGSSparkStorageWithDBKSparkMode();
        this.isHdfsStorageClass = this.initShim.isHdfsStorageClass();
        this.useCDPKnox = this.initShim.useCDPKnox();
        this.isSetHadoopConf = this.initShim.isSetHadoopConf();
        this.gSStorageName = this.initShim.gSStorageName();
        this.s3UriExtractedFromPath = this.initShim.s3UriExtractedFromPath();
        this.uriPrefixHadoopConf = this.initShim.uriPrefixHadoopConf();
        this.gSClass = this.initShim.gSClass();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.readDatesInLocalTimeZone = this.initShim.readDatesInLocalTimeZone();
        this.pathsWithPrefix = this.initShim.pathsWithPrefix();
        this.initShim = null;
    }

    private ImmutableTFileInputParquetBase(SparkSession sparkSession, Class<Row> rowClass, Encoder<Row> encoder, ImmutableMap<String, String> options, boolean isS3StorageWithBucketNameSpecified, boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration, boolean isGSSparkStorageWithDBKSparkMode, boolean isHdfsStorageClass, boolean useCDPKnox, boolean isSetHadoopConf, String gSStorageName, String s3UriExtractedFromPath, String uriPrefixHadoopConf, Class<?> gSClass, ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, boolean readDatesInLocalTimeZone, ImmutableList<String> paths) {
        this.sparkSession = sparkSession;
        this.initShim.rowClass(rowClass);
        this.initShim.encoder(encoder);
        this.initShim.options(options);
        this.initShim.isS3StorageWithBucketNameSpecified(isS3StorageWithBucketNameSpecified);
        this.initShim.isNotEmptyHadoopPrefixWithDefineStorageConfiguration(isNotEmptyHadoopPrefixWithDefineStorageConfiguration);
        this.initShim.isGSSparkStorageWithDBKSparkMode(isGSSparkStorageWithDBKSparkMode);
        this.initShim.isHdfsStorageClass(isHdfsStorageClass);
        this.initShim.useCDPKnox(useCDPKnox);
        this.initShim.isSetHadoopConf(isSetHadoopConf);
        this.initShim.gSStorageName(gSStorageName);
        this.initShim.s3UriExtractedFromPath(s3UriExtractedFromPath);
        this.initShim.uriPrefixHadoopConf(uriPrefixHadoopConf);
        this.initShim.gSClass(gSClass);
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.initShim.readDatesInLocalTimeZone(readDatesInLocalTimeZone);
        this.paths = paths;
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.previousURI = this.initShim.previousURI();
        this.isS3StorageWithBucketNameSpecified = this.initShim.isS3StorageWithBucketNameSpecified();
        this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration = this.initShim.isNotEmptyHadoopPrefixWithDefineStorageConfiguration();
        this.isGSSparkStorageWithDBKSparkMode = this.initShim.isGSSparkStorageWithDBKSparkMode();
        this.isHdfsStorageClass = this.initShim.isHdfsStorageClass();
        this.useCDPKnox = this.initShim.useCDPKnox();
        this.isSetHadoopConf = this.initShim.isSetHadoopConf();
        this.gSStorageName = this.initShim.gSStorageName();
        this.s3UriExtractedFromPath = this.initShim.s3UriExtractedFromPath();
        this.uriPrefixHadoopConf = this.initShim.uriPrefixHadoopConf();
        this.gSClass = this.initShim.gSClass();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.readDatesInLocalTimeZone = this.initShim.readDatesInLocalTimeZone();
        this.pathsWithPrefix = this.initShim.pathsWithPrefix();
        this.initShim = null;
    }

    private Class<Row> rowClassInitialize() {
        return tFileInputParquetBase.super.rowClass();
    }

    private Encoder<Row> encoderInitialize() {
        return tFileInputParquetBase.super.encoder();
    }

    private JavaSparkContext contextInitialize() {
        return tFileInputParquetBase.super.context();
    }

    private Map<String, String> optionsInitialize() {
        return tFileInputParquetBase.super.options();
    }

    private URI previousURIInitialize() {
        return tFileInputParquetBase.super.previousURI();
    }

    private boolean isS3StorageWithBucketNameSpecifiedInitialize() {
        return tFileInputParquetBase.super.isS3StorageWithBucketNameSpecified();
    }

    private boolean isNotEmptyHadoopPrefixWithDefineStorageConfigurationInitialize() {
        return tFileInputParquetBase.super.isNotEmptyHadoopPrefixWithDefineStorageConfiguration();
    }

    private boolean isGSSparkStorageWithDBKSparkModeInitialize() {
        return tFileInputParquetBase.super.isGSSparkStorageWithDBKSparkMode();
    }

    private boolean isHdfsStorageClassInitialize() {
        return tFileInputParquetBase.super.isHdfsStorageClass();
    }

    private boolean useCDPKnoxInitialize() {
        return tFileInputParquetBase.super.useCDPKnox();
    }

    private boolean isSetHadoopConfInitialize() {
        return tFileInputParquetBase.super.isSetHadoopConf();
    }

    private String gSStorageNameInitialize() {
        return tFileInputParquetBase.super.gSStorageName();
    }

    private String s3UriExtractedFromPathInitialize() {
        return tFileInputParquetBase.super.s3UriExtractedFromPath();
    }

    private String uriPrefixHadoopConfInitialize() {
        return tFileInputParquetBase.super.uriPrefixHadoopConf();
    }

    private Class<?> gSClassInitialize() {
        return tFileInputParquetBase.super.gSClass();
    }

    private StructType getOutputRowStructInitialize() {
        return tFileInputParquetBase.super.getOutputRowStruct();
    }

    private Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMapInitialize() {
        return tFileInputParquetBase.super.getSchemaFieldDescriptionsMap();
    }

    private boolean readDatesInLocalTimeZoneInitialize() {
        return tFileInputParquetBase.super.readDatesInLocalTimeZone();
    }

    private List<String> pathsWithPrefixInitialize() {
        return tFileInputParquetBase.super.pathsWithPrefix();
    }

    @Override
    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public Class<Row> rowClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowClass() : this.rowClass;
    }

    @Override
    public Encoder<Row> encoder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encoder() : this.encoder;
    }

    @Override
    public JavaSparkContext context() {
        InitShim shim = this.initShim;
        return shim != null ? shim.context() : this.context;
    }

    public ImmutableMap<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    @Override
    public URI previousURI() {
        InitShim shim = this.initShim;
        return shim != null ? shim.previousURI() : this.previousURI;
    }

    @Override
    public boolean isS3StorageWithBucketNameSpecified() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isS3StorageWithBucketNameSpecified() : this.isS3StorageWithBucketNameSpecified;
    }

    @Override
    public boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isNotEmptyHadoopPrefixWithDefineStorageConfiguration() : this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
    }

    @Override
    public boolean isGSSparkStorageWithDBKSparkMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isGSSparkStorageWithDBKSparkMode() : this.isGSSparkStorageWithDBKSparkMode;
    }

    @Override
    public boolean isHdfsStorageClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isHdfsStorageClass() : this.isHdfsStorageClass;
    }

    @Override
    public boolean useCDPKnox() {
        InitShim shim = this.initShim;
        return shim != null ? shim.useCDPKnox() : this.useCDPKnox;
    }

    @Override
    public boolean isSetHadoopConf() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isSetHadoopConf() : this.isSetHadoopConf;
    }

    @Override
    public String gSStorageName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gSStorageName() : this.gSStorageName;
    }

    @Override
    public String s3UriExtractedFromPath() {
        InitShim shim = this.initShim;
        return shim != null ? shim.s3UriExtractedFromPath() : this.s3UriExtractedFromPath;
    }

    @Override
    public String uriPrefixHadoopConf() {
        InitShim shim = this.initShim;
        return shim != null ? shim.uriPrefixHadoopConf() : this.uriPrefixHadoopConf;
    }

    @Override
    public Class<?> gSClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gSClass() : this.gSClass;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    @Override
    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    @Override
    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    public boolean readDatesInLocalTimeZone() {
        InitShim shim = this.initShim;
        return shim != null ? shim.readDatesInLocalTimeZone() : this.readDatesInLocalTimeZone;
    }

    public ImmutableList<String> paths() {
        return this.paths;
    }

    @Override
    public List<String> pathsWithPrefix() {
        InitShim shim = this.initShim;
        return shim != null ? shim.pathsWithPrefix() : this.pathsWithPrefix;
    }

    public final ImmutableTFileInputParquetBase withSparkSession(SparkSession value) {
        if (this.sparkSession == value) {
            return this;
        }
        SparkSession newValue = Objects.requireNonNull(value, "sparkSession");
        return new ImmutableTFileInputParquetBase(newValue, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withRowClass(Class<Row> value) {
        if (this.rowClass == value) {
            return this;
        }
        Class<Row> newValue = Objects.requireNonNull(value, "rowClass");
        return new ImmutableTFileInputParquetBase(this.sparkSession, newValue, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withEncoder(Encoder<Row> value) {
        if (this.encoder == value) {
            return this;
        }
        Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, newValue, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, (ImmutableMap<String, String>)newValue, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withIsS3StorageWithBucketNameSpecified(boolean value) {
        if (this.isS3StorageWithBucketNameSpecified == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, value, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withIsNotEmptyHadoopPrefixWithDefineStorageConfiguration(boolean value) {
        if (this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, value, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withIsGSSparkStorageWithDBKSparkMode(boolean value) {
        if (this.isGSSparkStorageWithDBKSparkMode == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, value, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withIsHdfsStorageClass(boolean value) {
        if (this.isHdfsStorageClass == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, value, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withUseCDPKnox(boolean value) {
        if (this.useCDPKnox == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, value, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withIsSetHadoopConf(boolean value) {
        if (this.isSetHadoopConf == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, value, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withGSStorageName(String value) {
        String newValue = Objects.requireNonNull(value, "gSStorageName");
        if (this.gSStorageName.equals(newValue)) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, newValue, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withS3UriExtractedFromPath(String value) {
        String newValue = Objects.requireNonNull(value, "s3UriExtractedFromPath");
        if (this.s3UriExtractedFromPath.equals(newValue)) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, newValue, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withUriPrefixHadoopConf(String value) {
        String newValue = Objects.requireNonNull(value, "uriPrefixHadoopConf");
        if (this.uriPrefixHadoopConf.equals(newValue)) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, newValue, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withGSClass(Class<?> value) {
        if (this.gSClass == value) {
            return this;
        }
        Class<?> newValue = Objects.requireNonNull(value, "gSClass");
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, newValue, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.readDatesInLocalTimeZone, this.paths);
    }

    public final ImmutableTFileInputParquetBase withReadDatesInLocalTimeZone(boolean value) {
        if (this.readDatesInLocalTimeZone == value) {
            return this;
        }
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, value, this.paths);
    }

    public final ImmutableTFileInputParquetBase withPaths(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, (ImmutableList<String>)newValue);
    }

    public final ImmutableTFileInputParquetBase withPaths(Iterable<String> elements) {
        if (this.paths == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTFileInputParquetBase(this.sparkSession, this.rowClass, this.encoder, this.options, this.isS3StorageWithBucketNameSpecified, this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration, this.isGSSparkStorageWithDBKSparkMode, this.isHdfsStorageClass, this.useCDPKnox, this.isSetHadoopConf, this.gSStorageName, this.s3UriExtractedFromPath, this.uriPrefixHadoopConf, this.gSClass, this.schemaFieldDescriptions, this.readDatesInLocalTimeZone, (ImmutableList<String>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTFileInputParquetBase && this.equalTo(0, (ImmutableTFileInputParquetBase)another);
    }

    private boolean equalTo(int synthetic, ImmutableTFileInputParquetBase another) {
        return this.sparkSession.equals(another.sparkSession) && this.rowClass.equals(another.rowClass) && this.encoder.equals(another.encoder) && this.context.equals(another.context) && this.options.equals(another.options) && this.previousURI.equals(another.previousURI) && this.isS3StorageWithBucketNameSpecified == another.isS3StorageWithBucketNameSpecified && this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration == another.isNotEmptyHadoopPrefixWithDefineStorageConfiguration && this.isGSSparkStorageWithDBKSparkMode == another.isGSSparkStorageWithDBKSparkMode && this.isHdfsStorageClass == another.isHdfsStorageClass && this.useCDPKnox == another.useCDPKnox && this.isSetHadoopConf == another.isSetHadoopConf && this.gSStorageName.equals(another.gSStorageName) && this.s3UriExtractedFromPath.equals(another.s3UriExtractedFromPath) && this.uriPrefixHadoopConf.equals(another.uriPrefixHadoopConf) && this.gSClass.equals(another.gSClass) && this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && this.readDatesInLocalTimeZone == another.readDatesInLocalTimeZone && this.paths.equals(another.paths) && this.pathsWithPrefix.equals(another.pathsWithPrefix);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sparkSession.hashCode();
        h += (h << 5) + this.rowClass.hashCode();
        h += (h << 5) + this.encoder.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.previousURI.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.isS3StorageWithBucketNameSpecified);
        h += (h << 5) + Booleans.hashCode((boolean)this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration);
        h += (h << 5) + Booleans.hashCode((boolean)this.isGSSparkStorageWithDBKSparkMode);
        h += (h << 5) + Booleans.hashCode((boolean)this.isHdfsStorageClass);
        h += (h << 5) + Booleans.hashCode((boolean)this.useCDPKnox);
        h += (h << 5) + Booleans.hashCode((boolean)this.isSetHadoopConf);
        h += (h << 5) + this.gSStorageName.hashCode();
        h += (h << 5) + this.s3UriExtractedFromPath.hashCode();
        h += (h << 5) + this.uriPrefixHadoopConf.hashCode();
        h += (h << 5) + this.gSClass.hashCode();
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.readDatesInLocalTimeZone);
        h += (h << 5) + this.paths.hashCode();
        h += (h << 5) + this.pathsWithPrefix.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"tFileInputParquetBase").omitNullValues().add("sparkSession", (Object)this.sparkSession).add("rowClass", this.rowClass).add("encoder", this.encoder).add("context", (Object)this.context).add("options", this.options).add("previousURI", (Object)this.previousURI).add("isS3StorageWithBucketNameSpecified", this.isS3StorageWithBucketNameSpecified).add("isNotEmptyHadoopPrefixWithDefineStorageConfiguration", this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration).add("isGSSparkStorageWithDBKSparkMode", this.isGSSparkStorageWithDBKSparkMode).add("isHdfsStorageClass", this.isHdfsStorageClass).add("useCDPKnox", this.useCDPKnox).add("isSetHadoopConf", this.isSetHadoopConf).add("gSStorageName", (Object)this.gSStorageName).add("s3UriExtractedFromPath", (Object)this.s3UriExtractedFromPath).add("uriPrefixHadoopConf", (Object)this.uriPrefixHadoopConf).add("gSClass", this.gSClass).add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("readDatesInLocalTimeZone", this.readDatesInLocalTimeZone).add("paths", this.paths).add("pathsWithPrefix", this.pathsWithPrefix).toString();
    }

    public static ImmutableTFileInputParquetBase of(SparkSession sparkSession, List<String> paths) {
        return ImmutableTFileInputParquetBase.of(sparkSession, paths);
    }

    public static ImmutableTFileInputParquetBase of(SparkSession sparkSession, Iterable<String> paths) {
        return new ImmutableTFileInputParquetBase(sparkSession, paths);
    }

    public static ImmutableTFileInputParquetBase copyOf(tFileInputParquetBase instance) {
        if (instance instanceof ImmutableTFileInputParquetBase) {
            return (ImmutableTFileInputParquetBase)instance;
        }
        return ImmutableTFileInputParquetBase.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="tFileInputParquetBase", generator="Immutables")
    private final class InitShim {
        private byte rowClassBuildStage = 0;
        private Class<Row> rowClass;
        private byte encoderBuildStage = 0;
        private Encoder<Row> encoder;
        private byte contextBuildStage = 0;
        private JavaSparkContext context;
        private byte optionsBuildStage = 0;
        private ImmutableMap<String, String> options;
        private byte previousURIBuildStage = 0;
        private URI previousURI;
        private byte isS3StorageWithBucketNameSpecifiedBuildStage = 0;
        private boolean isS3StorageWithBucketNameSpecified;
        private byte isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage = 0;
        private boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
        private byte isGSSparkStorageWithDBKSparkModeBuildStage = 0;
        private boolean isGSSparkStorageWithDBKSparkMode;
        private byte isHdfsStorageClassBuildStage = 0;
        private boolean isHdfsStorageClass;
        private byte useCDPKnoxBuildStage = 0;
        private boolean useCDPKnox;
        private byte isSetHadoopConfBuildStage = 0;
        private boolean isSetHadoopConf;
        private byte gSStorageNameBuildStage = 0;
        private String gSStorageName;
        private byte s3UriExtractedFromPathBuildStage = 0;
        private String s3UriExtractedFromPath;
        private byte uriPrefixHadoopConfBuildStage = 0;
        private String uriPrefixHadoopConf;
        private byte gSClassBuildStage = 0;
        private Class<?> gSClass;
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte readDatesInLocalTimeZoneBuildStage = 0;
        private boolean readDatesInLocalTimeZone;
        private byte pathsWithPrefixBuildStage = 0;
        private List<String> pathsWithPrefix;

        private InitShim() {
        }

        Class<Row> rowClass() {
            if (this.rowClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowClassBuildStage == 0) {
                this.rowClassBuildStage = (byte)-1;
                this.rowClass = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.rowClassInitialize(), "rowClass");
                this.rowClassBuildStage = 1;
            }
            return this.rowClass;
        }

        void rowClass(Class<Row> rowClass) {
            this.rowClass = rowClass;
            this.rowClassBuildStage = 1;
        }

        Encoder<Row> encoder() {
            if (this.encoderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encoderBuildStage == 0) {
                this.encoderBuildStage = (byte)-1;
                this.encoder = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.encoderInitialize(), "encoder");
                this.encoderBuildStage = 1;
            }
            return this.encoder;
        }

        void encoder(Encoder<Row> encoder) {
            this.encoder = encoder;
            this.encoderBuildStage = 1;
        }

        JavaSparkContext context() {
            if (this.contextBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contextBuildStage == 0) {
                this.contextBuildStage = (byte)-1;
                this.context = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.contextInitialize(), "context");
                this.contextBuildStage = 1;
            }
            return this.context;
        }

        ImmutableMap<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableMap.copyOf(ImmutableTFileInputParquetBase.this.optionsInitialize());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableMap<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        URI previousURI() {
            if (this.previousURIBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.previousURIBuildStage == 0) {
                this.previousURIBuildStage = (byte)-1;
                this.previousURI = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.previousURIInitialize(), "previousURI");
                this.previousURIBuildStage = 1;
            }
            return this.previousURI;
        }

        boolean isS3StorageWithBucketNameSpecified() {
            if (this.isS3StorageWithBucketNameSpecifiedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isS3StorageWithBucketNameSpecifiedBuildStage == 0) {
                this.isS3StorageWithBucketNameSpecifiedBuildStage = (byte)-1;
                this.isS3StorageWithBucketNameSpecified = ImmutableTFileInputParquetBase.this.isS3StorageWithBucketNameSpecifiedInitialize();
                this.isS3StorageWithBucketNameSpecifiedBuildStage = 1;
            }
            return this.isS3StorageWithBucketNameSpecified;
        }

        void isS3StorageWithBucketNameSpecified(boolean isS3StorageWithBucketNameSpecified) {
            this.isS3StorageWithBucketNameSpecified = isS3StorageWithBucketNameSpecified;
            this.isS3StorageWithBucketNameSpecifiedBuildStage = 1;
        }

        boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration() {
            if (this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage == 0) {
                this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage = (byte)-1;
                this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration = ImmutableTFileInputParquetBase.this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationInitialize();
                this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage = 1;
            }
            return this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
        }

        void isNotEmptyHadoopPrefixWithDefineStorageConfiguration(boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration) {
            this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration = isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
            this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage = 1;
        }

        boolean isGSSparkStorageWithDBKSparkMode() {
            if (this.isGSSparkStorageWithDBKSparkModeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isGSSparkStorageWithDBKSparkModeBuildStage == 0) {
                this.isGSSparkStorageWithDBKSparkModeBuildStage = (byte)-1;
                this.isGSSparkStorageWithDBKSparkMode = ImmutableTFileInputParquetBase.this.isGSSparkStorageWithDBKSparkModeInitialize();
                this.isGSSparkStorageWithDBKSparkModeBuildStage = 1;
            }
            return this.isGSSparkStorageWithDBKSparkMode;
        }

        void isGSSparkStorageWithDBKSparkMode(boolean isGSSparkStorageWithDBKSparkMode) {
            this.isGSSparkStorageWithDBKSparkMode = isGSSparkStorageWithDBKSparkMode;
            this.isGSSparkStorageWithDBKSparkModeBuildStage = 1;
        }

        boolean isHdfsStorageClass() {
            if (this.isHdfsStorageClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isHdfsStorageClassBuildStage == 0) {
                this.isHdfsStorageClassBuildStage = (byte)-1;
                this.isHdfsStorageClass = ImmutableTFileInputParquetBase.this.isHdfsStorageClassInitialize();
                this.isHdfsStorageClassBuildStage = 1;
            }
            return this.isHdfsStorageClass;
        }

        void isHdfsStorageClass(boolean isHdfsStorageClass) {
            this.isHdfsStorageClass = isHdfsStorageClass;
            this.isHdfsStorageClassBuildStage = 1;
        }

        boolean useCDPKnox() {
            if (this.useCDPKnoxBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.useCDPKnoxBuildStage == 0) {
                this.useCDPKnoxBuildStage = (byte)-1;
                this.useCDPKnox = ImmutableTFileInputParquetBase.this.useCDPKnoxInitialize();
                this.useCDPKnoxBuildStage = 1;
            }
            return this.useCDPKnox;
        }

        void useCDPKnox(boolean useCDPKnox) {
            this.useCDPKnox = useCDPKnox;
            this.useCDPKnoxBuildStage = 1;
        }

        boolean isSetHadoopConf() {
            if (this.isSetHadoopConfBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isSetHadoopConfBuildStage == 0) {
                this.isSetHadoopConfBuildStage = (byte)-1;
                this.isSetHadoopConf = ImmutableTFileInputParquetBase.this.isSetHadoopConfInitialize();
                this.isSetHadoopConfBuildStage = 1;
            }
            return this.isSetHadoopConf;
        }

        void isSetHadoopConf(boolean isSetHadoopConf) {
            this.isSetHadoopConf = isSetHadoopConf;
            this.isSetHadoopConfBuildStage = 1;
        }

        String gSStorageName() {
            if (this.gSStorageNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gSStorageNameBuildStage == 0) {
                this.gSStorageNameBuildStage = (byte)-1;
                this.gSStorageName = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.gSStorageNameInitialize(), "gSStorageName");
                this.gSStorageNameBuildStage = 1;
            }
            return this.gSStorageName;
        }

        void gSStorageName(String gSStorageName) {
            this.gSStorageName = gSStorageName;
            this.gSStorageNameBuildStage = 1;
        }

        String s3UriExtractedFromPath() {
            if (this.s3UriExtractedFromPathBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.s3UriExtractedFromPathBuildStage == 0) {
                this.s3UriExtractedFromPathBuildStage = (byte)-1;
                this.s3UriExtractedFromPath = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.s3UriExtractedFromPathInitialize(), "s3UriExtractedFromPath");
                this.s3UriExtractedFromPathBuildStage = 1;
            }
            return this.s3UriExtractedFromPath;
        }

        void s3UriExtractedFromPath(String s3UriExtractedFromPath) {
            this.s3UriExtractedFromPath = s3UriExtractedFromPath;
            this.s3UriExtractedFromPathBuildStage = 1;
        }

        String uriPrefixHadoopConf() {
            if (this.uriPrefixHadoopConfBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.uriPrefixHadoopConfBuildStage == 0) {
                this.uriPrefixHadoopConfBuildStage = (byte)-1;
                this.uriPrefixHadoopConf = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.uriPrefixHadoopConfInitialize(), "uriPrefixHadoopConf");
                this.uriPrefixHadoopConfBuildStage = 1;
            }
            return this.uriPrefixHadoopConf;
        }

        void uriPrefixHadoopConf(String uriPrefixHadoopConf) {
            this.uriPrefixHadoopConf = uriPrefixHadoopConf;
            this.uriPrefixHadoopConfBuildStage = 1;
        }

        Class<?> gSClass() {
            if (this.gSClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gSClassBuildStage == 0) {
                this.gSClassBuildStage = (byte)-1;
                this.gSClass = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.gSClassInitialize(), "gSClass");
                this.gSClassBuildStage = 1;
            }
            return this.gSClass;
        }

        void gSClass(Class<?> gSClass) {
            this.gSClass = gSClass;
            this.gSClassBuildStage = 1;
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.getOutputRowStructInitialize(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.getSchemaFieldDescriptionsMapInitialize(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        boolean readDatesInLocalTimeZone() {
            if (this.readDatesInLocalTimeZoneBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.readDatesInLocalTimeZoneBuildStage == 0) {
                this.readDatesInLocalTimeZoneBuildStage = (byte)-1;
                this.readDatesInLocalTimeZone = ImmutableTFileInputParquetBase.this.readDatesInLocalTimeZoneInitialize();
                this.readDatesInLocalTimeZoneBuildStage = 1;
            }
            return this.readDatesInLocalTimeZone;
        }

        void readDatesInLocalTimeZone(boolean readDatesInLocalTimeZone) {
            this.readDatesInLocalTimeZone = readDatesInLocalTimeZone;
            this.readDatesInLocalTimeZoneBuildStage = 1;
        }

        List<String> pathsWithPrefix() {
            if (this.pathsWithPrefixBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.pathsWithPrefixBuildStage == 0) {
                this.pathsWithPrefixBuildStage = (byte)-1;
                this.pathsWithPrefix = Objects.requireNonNull(ImmutableTFileInputParquetBase.this.pathsWithPrefixInitialize(), "pathsWithPrefix");
                this.pathsWithPrefixBuildStage = 1;
            }
            return this.pathsWithPrefix;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.rowClassBuildStage == -1) {
                attributes.add("rowClass");
            }
            if (this.encoderBuildStage == -1) {
                attributes.add("encoder");
            }
            if (this.contextBuildStage == -1) {
                attributes.add("context");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.previousURIBuildStage == -1) {
                attributes.add("previousURI");
            }
            if (this.isS3StorageWithBucketNameSpecifiedBuildStage == -1) {
                attributes.add("isS3StorageWithBucketNameSpecified");
            }
            if (this.isNotEmptyHadoopPrefixWithDefineStorageConfigurationBuildStage == -1) {
                attributes.add("isNotEmptyHadoopPrefixWithDefineStorageConfiguration");
            }
            if (this.isGSSparkStorageWithDBKSparkModeBuildStage == -1) {
                attributes.add("isGSSparkStorageWithDBKSparkMode");
            }
            if (this.isHdfsStorageClassBuildStage == -1) {
                attributes.add("isHdfsStorageClass");
            }
            if (this.useCDPKnoxBuildStage == -1) {
                attributes.add("useCDPKnox");
            }
            if (this.isSetHadoopConfBuildStage == -1) {
                attributes.add("isSetHadoopConf");
            }
            if (this.gSStorageNameBuildStage == -1) {
                attributes.add("gSStorageName");
            }
            if (this.s3UriExtractedFromPathBuildStage == -1) {
                attributes.add("s3UriExtractedFromPath");
            }
            if (this.uriPrefixHadoopConfBuildStage == -1) {
                attributes.add("uriPrefixHadoopConf");
            }
            if (this.gSClassBuildStage == -1) {
                attributes.add("gSClass");
            }
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.readDatesInLocalTimeZoneBuildStage == -1) {
                attributes.add("readDatesInLocalTimeZone");
            }
            if (this.pathsWithPrefixBuildStage == -1) {
                attributes.add("pathsWithPrefix");
            }
            return "Cannot build tFileInputParquetBase, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="tFileInputParquetBase", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SPARK_SESSION = 1L;
        private static final long OPT_BIT_OPTIONS = 1L;
        private static final long OPT_BIT_IS_S3_STORAGE_WITH_BUCKET_NAME_SPECIFIED = 2L;
        private static final long OPT_BIT_IS_NOT_EMPTY_HADOOP_PREFIX_WITH_DEFINE_STORAGE_CONFIGURATION = 4L;
        private static final long OPT_BIT_IS_G_S_SPARK_STORAGE_WITH_D_B_K_SPARK_MODE = 8L;
        private static final long OPT_BIT_IS_HDFS_STORAGE_CLASS = 16L;
        private static final long OPT_BIT_USE_C_D_P_KNOX = 32L;
        private static final long OPT_BIT_IS_SET_HADOOP_CONF = 64L;
        private static final long OPT_BIT_READ_DATES_IN_LOCAL_TIME_ZONE = 128L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private SparkSession sparkSession;
        @Nullable
        private Class<Row> rowClass;
        @Nullable
        private Encoder<Row> encoder;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        private boolean isS3StorageWithBucketNameSpecified;
        private boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
        private boolean isGSSparkStorageWithDBKSparkMode;
        private boolean isHdfsStorageClass;
        private boolean useCDPKnox;
        private boolean isSetHadoopConf;
        @Nullable
        private String gSStorageName;
        @Nullable
        private String s3UriExtractedFromPath;
        @Nullable
        private String uriPrefixHadoopConf;
        @Nullable
        private Class<?> gSClass;
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        private boolean readDatesInLocalTimeZone;
        private ImmutableList.Builder<String> paths = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(tFileInputParquetBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithUriBuildPrefix instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 0x200L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x200L;
                }
            }
            if (object instanceof tFileInputParquetBase) {
                instance = (tFileInputParquetBase)object;
                if ((bits & 1L) == 0L) {
                    this.uriPrefixHadoopConf(instance.uriPrefixHadoopConf());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.isS3StorageWithBucketNameSpecified(instance.isS3StorageWithBucketNameSpecified());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.isSetHadoopConf(instance.isSetHadoopConf());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.isHdfsStorageClass(instance.isHdfsStorageClass());
                    bits |= 8L;
                }
                this.readDatesInLocalTimeZone(instance.readDatesInLocalTimeZone());
                if ((bits & 0x10L) == 0L) {
                    this.gSClass(instance.gSClass());
                    bits |= 0x10L;
                }
                this.encoder(instance.encoder());
                if ((bits & 0x20L) == 0L) {
                    this.useCDPKnox(instance.useCDPKnox());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.s3UriExtractedFromPath(instance.s3UriExtractedFromPath());
                    bits |= 0x40L;
                }
                this.rowClass(instance.rowClass());
                this.sparkSession(instance.sparkSession());
                this.addAllPaths(instance.paths());
                if ((bits & 0x80L) == 0L) {
                    this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration(instance.isNotEmptyHadoopPrefixWithDefineStorageConfiguration());
                    bits |= 0x80L;
                }
                this.putAllOptions(instance.options());
                if ((bits & 0x100L) == 0L) {
                    this.gSStorageName(instance.gSStorageName());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.isGSSparkStorageWithDBKSparkMode(instance.isGSSparkStorageWithDBKSparkMode());
                    bits |= 0x400L;
                }
            }
            if (object instanceof Component.WithUriBuildPrefix) {
                instance = (Component.WithUriBuildPrefix)object;
                if ((bits & 1L) == 0L) {
                    this.uriPrefixHadoopConf(instance.uriPrefixHadoopConf());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.isS3StorageWithBucketNameSpecified(instance.isS3StorageWithBucketNameSpecified());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.isSetHadoopConf(instance.isSetHadoopConf());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.isHdfsStorageClass(instance.isHdfsStorageClass());
                    bits |= 8L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration(instance.isNotEmptyHadoopPrefixWithDefineStorageConfiguration());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.gSStorageName(instance.gSStorageName());
                    bits |= 0x100L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.gSClass(instance.gSClass());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.useCDPKnox(instance.useCDPKnox());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.s3UriExtractedFromPath(instance.s3UriExtractedFromPath());
                    bits |= 0x40L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.isGSSparkStorageWithDBKSparkMode(instance.isGSSparkStorageWithDBKSparkMode());
                    bits |= 0x400L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder sparkSession(SparkSession sparkSession) {
            this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowClass(Class<Row> rowClass) {
            this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoder(Encoder<Row> encoder) {
            this.encoder = Objects.requireNonNull(encoder, "encoder");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isS3StorageWithBucketNameSpecified(boolean isS3StorageWithBucketNameSpecified) {
            this.isS3StorageWithBucketNameSpecified = isS3StorageWithBucketNameSpecified;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isNotEmptyHadoopPrefixWithDefineStorageConfiguration(boolean isNotEmptyHadoopPrefixWithDefineStorageConfiguration) {
            this.isNotEmptyHadoopPrefixWithDefineStorageConfiguration = isNotEmptyHadoopPrefixWithDefineStorageConfiguration;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isGSSparkStorageWithDBKSparkMode(boolean isGSSparkStorageWithDBKSparkMode) {
            this.isGSSparkStorageWithDBKSparkMode = isGSSparkStorageWithDBKSparkMode;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isHdfsStorageClass(boolean isHdfsStorageClass) {
            this.isHdfsStorageClass = isHdfsStorageClass;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder useCDPKnox(boolean useCDPKnox) {
            this.useCDPKnox = useCDPKnox;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isSetHadoopConf(boolean isSetHadoopConf) {
            this.isSetHadoopConf = isSetHadoopConf;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gSStorageName(String gSStorageName) {
            this.gSStorageName = Objects.requireNonNull(gSStorageName, "gSStorageName");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder s3UriExtractedFromPath(String s3UriExtractedFromPath) {
            this.s3UriExtractedFromPath = Objects.requireNonNull(s3UriExtractedFromPath, "s3UriExtractedFromPath");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder uriPrefixHadoopConf(String uriPrefixHadoopConf) {
            this.uriPrefixHadoopConf = Objects.requireNonNull(uriPrefixHadoopConf, "uriPrefixHadoopConf");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder gSClass(Class<?> gSClass) {
            this.gSClass = Objects.requireNonNull(gSClass, "gSClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder readDatesInLocalTimeZone(boolean readDatesInLocalTimeZone) {
            this.readDatesInLocalTimeZone = readDatesInLocalTimeZone;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPaths(String element) {
            this.paths.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPaths(String ... elements) {
            this.paths.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder paths(Iterable<String> elements) {
            this.paths = ImmutableList.builder();
            return this.addAllPaths(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPaths(Iterable<String> elements) {
            this.paths.addAll(elements);
            return this;
        }

        public ImmutableTFileInputParquetBase build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTFileInputParquetBase(this);
        }

        private boolean optionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean isS3StorageWithBucketNameSpecifiedIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean isNotEmptyHadoopPrefixWithDefineStorageConfigurationIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean isGSSparkStorageWithDBKSparkModeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean isHdfsStorageClassIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean useCDPKnoxIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean isSetHadoopConfIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean readDatesInLocalTimeZoneIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sparkSession");
            }
            return "Cannot build tFileInputParquetBase, some of required attributes are not set " + attributes;
        }
    }
}

