/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.tfileinput.parquet;

import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.api.java.UDF2;
import org.apache.spark.sql.functions;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.common.input.FileReader;
import scala.Tuple2;

@Value.Immutable
public interface tFileInputParquetBase
extends FileReader<Row>,
Component.WithUriBuildPrefix,
Component.WithSchemaDescription {
    @Value.Default
    default public boolean readDatesInLocalTimeZone() {
        return false;
    }

    @Override
    @Value.Parameter
    public List<String> paths();

    @Value.Derived
    default public List<String> pathsWithPrefix() {
        Tuple2<URI, String> uriBuildTuple;
        try {
            uriBuildTuple = Component.WithUriBuildPrefix.super.setUriPrefix(this.context(), this.sparkSession(), this.paths().get(0));
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String prefix = (String)uriBuildTuple._2;
        return this.paths().stream().map(path -> prefix + path).collect(Collectors.toList());
    }

    @Value.Derived
    default public Dataset<Row> applyLocalTimezoneIfNeeded(Dataset<Row> dataset) {
        List dateFields;
        if (this.readDatesInLocalTimeZone() && !(dateFields = this.schemaFieldDescriptions().stream().filter(schemaFieldDescription -> schemaFieldDescription.type().equals("java.sql.Timestamp")).collect(Collectors.toList())).isEmpty()) {
            String sessionTimeZone = this.sparkSession().conf().get("spark.sql.session.timeZone");
            for (Component.SchemaFieldDescription schemaFieldDescription2 : dateFields) {
                dataset = dataset.withColumn(schemaFieldDescription2.name(), functions.callUDF((String)"forceTimeZone", (Column[])new Column[]{functions.col((String)schemaFieldDescription2.name()), functions.lit((Object)sessionTimeZone)}));
            }
        }
        return dataset;
    }

    public static class ForceTimeZone
    implements UDF2<Timestamp, String, Timestamp>,
    Serializable {
        public Timestamp call(Timestamp utcTs, String localTimeZone) throws Exception {
            LocalDateTime ldt = utcTs.toLocalDateTime();
            ZonedDateTime utcZonedDateTime = ldt.atZone(ZoneId.of(localTimeZone)).withZoneSameInstant(ZoneId.of("UTC"));
            ZonedDateTime targetZonedDateTime = utcZonedDateTime.withZoneSameLocal(ZoneId.of(localTimeZone));
            Instant instant = targetZonedDateTime.toInstant();
            return Timestamp.from(instant);
        }
    }
}

