/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.common.utils.storage;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.mapred.JobConf;
import org.talend.hadoop.fs.FileUtil;

public class StorageUtils {
    public static boolean checkIfWindows() throws ClassCastException {
        return System.getProperty("os.name").toUpperCase().contains("WINDOWS");
    }

    public static void deleteCommittedFile(Path sourceDirectoryPath, FileSystem fileSystem) throws IOException {
        RemoteIterator distantFilesIterator = fileSystem.listFiles(sourceDirectoryPath, false);
        while (distantFilesIterator.hasNext()) {
            LocatedFileStatus file = (LocatedFileStatus)distantFilesIterator.next();
            if (!file.getPath().toString().contains("_committed_")) continue;
            fileSystem.delete(file.getPath());
        }
    }

    public static void deleteTargetFile(boolean hasOverwrite, Path targetFilePath, FileSystem fileSystem) throws IOException {
        if (hasOverwrite && fileSystem.exists(targetFilePath) && !fileSystem.getFileStatus(targetFilePath).isDirectory()) {
            fileSystem.delete(targetFilePath, false);
        }
    }

    public static void copyMerge(FileSystem fileSystem, Path sourceDirectoryPath, Path targetFilePath, boolean removeSourceDirectory, JobConf jobConf, String addString, int headerByteCount) throws IOException {
        FileUtil.copyMerge((FileSystem)fileSystem, (Path)sourceDirectoryPath, (FileSystem)fileSystem, (Path)targetFilePath, (boolean)removeSourceDirectory, (Configuration)jobConf, (String)addString, (int)headerByteCount);
    }
}

