/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.altus;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AltusJobUtil {
    public static String STATUS_CLUSTER_CREATING = "CREATING";
    public static String STATUS_CLUSTER_CREATED = "CREATED";
    public static String STATUS_CLUSTER_TERMINATING = "TERMINATING";
    public static String STATUS_CLUSTER_TERMINATED = "TERMINATED";
    public static String STATUS_CLUSTER_ERROR = "ERROR";
    public static String STATUS_JOB_QUEUED = "QUEUED";
    public static String STATUS_JOB_SUBMITTING = "SUBMITTING";
    public static String STATUS_JOB_RUNNING = "RUNNING";
    public static String STATUS_JOB_COMPLETED = "COMPLETED";
    public static String STATUS_JOB_ERROR = "ERROR";
    private static Logger LOG = LoggerFactory.getLogger(AltusJobUtil.class);
    private static Pattern jobStatusPattern = Pattern.compile("\"status\": \"([^\"]+)\"");
    private static Pattern jobIdPattern = Pattern.compile("\"jobId\": \"([^\"]+)\"");

    public static int convertToReturnCode(String finalJobStatus) {
        LOG.info("Final Status: " + finalJobStatus);
        if (STATUS_JOB_COMPLETED.equals(finalJobStatus) || STATUS_CLUSTER_TERMINATED.equals(finalJobStatus)) {
            return 0;
        }
        return 1;
    }

    public static String generateJobArgument(String talendJobName, String mainClass, List<String> jarsFileUris, List<String> args, Map<String, String> conf) {
        String remoteArgs = AltusJobUtil.prepareArgs(args);
        String properties = AltusJobUtil.prepareProperties(conf);
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < jarsFileUris.size(); ++i) {
            sb.append(AltusJobUtil.wrapEscapeQuote(jarsFileUris.get(i)));
            if (i != jarsFileUris.size() - 1) {
                sb.append(", ");
                continue;
            }
            sb.append("]");
        }
        return "{" + AltusJobUtil.wrapEscapeQuote("name") + ": " + AltusJobUtil.wrapEscapeQuote(talendJobName) + "," + AltusJobUtil.wrapEscapeQuote("sparkJob") + ": { " + AltusJobUtil.wrapEscapeQuote("jars") + ": " + sb.toString() + "," + AltusJobUtil.wrapEscapeQuote("applicationArguments") + ":[" + remoteArgs + "]," + AltusJobUtil.wrapEscapeQuote("sparkArguments") + ":" + properties + ", " + AltusJobUtil.wrapEscapeQuote("mainClass") + ":" + AltusJobUtil.wrapEscapeQuote(mainClass) + "}}";
    }

    public static String prepareArgs(List<String> args) {
        String remoteArgs = "";
        if (args != null && args.size() > 0) {
            for (String mArg : args) {
                remoteArgs = remoteArgs + AltusJobUtil.wrapEscapeQuote(mArg) + ", ";
            }
        }
        remoteArgs = remoteArgs + AltusJobUtil.wrapEscapeQuote("-calledByAltus");
        return remoteArgs;
    }

    public static String prepareProperties(Map<String, String> conf) {
        String properties = "";
        if (conf != null && conf.size() > 0) {
            for (Map.Entry<String, String> element : conf.entrySet()) {
                properties = properties + "--conf " + element.getKey() + "=" + element.getValue() + " ";
            }
        }
        return AltusJobUtil.wrapEscapeQuote(properties);
    }

    public static String wrapEscapeQuote(String content) {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return "\\\"" + content + "\\\"";
        }
        return "\"" + content + "\"";
    }

    public static String maskAwsAccessSecretKeyInSparkConf(String originalStr) {
        return originalStr.replaceAll("(awsSecretAccessKey=|awsAccessKeyId=)([\\w\\d]*)", "$1*");
    }

    public static String getJobId(String pathToAltusCLI, String crn) throws IOException {
        CharSequence[] commandLineArray = new String[]{pathToAltusCLI, "dataeng", "list-jobs", "--cluster-crn", crn, "--max-items", "1"};
        LOG.info("Getting jobId : " + String.join((CharSequence)" ", commandLineArray));
        Process process = Runtime.getRuntime().exec((String[])commandLineArray);
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
        LOG.info("Response" + jobLog);
        if (jobLog.length() > 0) {
            stdInput.close();
            stdError.close();
            Matcher matcher = jobIdPattern.matcher(jobLog);
            if (matcher.find()) {
                return matcher.group(1);
            }
            return null;
        }
        LOG.error(AltusJobUtil.readStdBufferedReader(stdError));
        stdInput.close();
        stdError.close();
        return null;
    }

    public static String retrieveJobStatus(String jobId, String pathToAltusCLI) throws IOException {
        Process process = Runtime.getRuntime().exec(new String[]{pathToAltusCLI, "dataeng", "list-jobs", "--job-ids", "[" + AltusJobUtil.wrapEscapeQuote(jobId) + "]"});
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(process.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String jobLog = AltusJobUtil.readStdBufferedReader(stdInput);
        if (jobLog.length() > 0) {
            LOG.debug(jobLog);
            Matcher matcher = jobStatusPattern.matcher(jobLog);
            stdInput.close();
            stdError.close();
            if (matcher.find()) {
                String jobStatus = matcher.group(1);
                if (STATUS_JOB_QUEUED.equals(jobStatus)) {
                    LOG.info("The job is waiting for the cluster");
                } else if (STATUS_JOB_SUBMITTING.equals(jobStatus)) {
                    LOG.info("The job is submitted to the cluster.");
                } else if (STATUS_JOB_RUNNING.equals(jobStatus)) {
                    LOG.info("The job is running.");
                } else if (STATUS_JOB_COMPLETED.equals(jobStatus)) {
                    LOG.info("The job is completed.");
                }
                return jobStatus;
            }
            LOG.info("An error occured during the job processing.");
            return STATUS_JOB_ERROR;
        }
        LOG.error(AltusJobUtil.readStdBufferedReader(stdError));
        stdInput.close();
        stdError.close();
        return STATUS_JOB_ERROR;
    }

    public static boolean needToMonitorTheJob(String clusterStatus, String jobStatus, boolean deleteAfterExecution) {
        if (STATUS_CLUSTER_CREATING.equals(clusterStatus) || deleteAfterExecution && STATUS_CLUSTER_TERMINATING.equals(clusterStatus)) {
            return true;
        }
        if (deleteAfterExecution) {
            return STATUS_CLUSTER_CREATED.equals(clusterStatus) || STATUS_CLUSTER_TERMINATING.equals(clusterStatus);
        }
        return STATUS_CLUSTER_CREATED.equals(clusterStatus) && (STATUS_JOB_QUEUED.equals(jobStatus) || STATUS_JOB_SUBMITTING.equals(jobStatus) || STATUS_JOB_RUNNING.equals(jobStatus));
    }

    public static String readStdBufferedReader(BufferedReader reader) throws IOException {
        StringBuilder result = new StringBuilder();
        String s = null;
        while ((s = reader.readLine()) != null) {
            result.append(s);
            result.append("\n");
        }
        return result.toString();
    }
}

