/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.client.methods;

import java.net.URI;
import org.talend.bigdata.http.ProtocolVersion;
import org.talend.bigdata.http.RequestLine;
import org.talend.bigdata.http.client.config.RequestConfig;
import org.talend.bigdata.http.client.methods.AbstractExecutionAwareRequest;
import org.talend.bigdata.http.client.methods.Configurable;
import org.talend.bigdata.http.client.methods.HttpUriRequest;
import org.talend.bigdata.http.message.BasicRequestLine;
import org.talend.bigdata.http.params.HttpProtocolParams;

public abstract class HttpRequestBase
extends AbstractExecutionAwareRequest
implements HttpUriRequest,
Configurable {
    private ProtocolVersion version;
    private URI uri;
    private RequestConfig config;

    @Override
    public abstract String getMethod();

    public void setProtocolVersion(ProtocolVersion version) {
        this.version = version;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.version != null ? this.version : HttpProtocolParams.getVersion(this.getParams());
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    @Override
    public RequestLine getRequestLine() {
        String method = this.getMethod();
        ProtocolVersion ver = this.getProtocolVersion();
        URI uriCopy = this.getURI();
        String uritext = null;
        if (uriCopy != null) {
            uritext = uriCopy.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(method, uritext, ver);
    }

    @Override
    public RequestConfig getConfig() {
        return this.config;
    }

    public void setConfig(RequestConfig config) {
        this.config = config;
    }

    public void setURI(URI uri) {
        this.uri = uri;
    }

    public void started() {
    }

    public void releaseConnection() {
        this.reset();
    }

    public String toString() {
        return this.getMethod() + " " + this.getURI() + " " + this.getProtocolVersion();
    }
}

