/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.client;

import java.io.IOException;
import org.talend.bigdata.http.HttpEntity;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.StatusLine;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.client.HttpResponseException;
import org.talend.bigdata.http.client.ResponseHandler;
import org.talend.bigdata.http.util.EntityUtils;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

