/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.impl.io;

import java.io.IOException;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.HttpResponseFactory;
import org.talend.bigdata.http.NoHttpResponseException;
import org.talend.bigdata.http.ParseException;
import org.talend.bigdata.http.StatusLine;
import org.talend.bigdata.http.config.MessageConstraints;
import org.talend.bigdata.http.impl.DefaultHttpResponseFactory;
import org.talend.bigdata.http.impl.io.AbstractMessageParser;
import org.talend.bigdata.http.io.SessionInputBuffer;
import org.talend.bigdata.http.message.LineParser;
import org.talend.bigdata.http.message.ParserCursor;
import org.talend.bigdata.http.params.HttpParams;
import org.talend.bigdata.http.util.Args;
import org.talend.bigdata.http.util.CharArrayBuffer;

public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, HttpParams params) {
        super(buffer, lineParser, params);
        this.responseFactory = Args.notNull(responseFactory, "Response factory");
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(buffer, lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this(buffer, null, null, constraints);
    }

    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this(buffer, null, null, MessageConstraints.DEFAULT);
    }

    @Override
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException, ParseException {
        this.lineBuf.clear();
        int readLen = sessionBuffer.readLine(this.lineBuf);
        if (readLen == -1) {
            throw new NoHttpResponseException("The target server failed to respond");
        }
        ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, cursor);
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

