/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.protocol;

import java.io.IOException;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.HttpResponseInterceptor;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class ResponseServer
implements HttpResponseInterceptor {
    private final String originServer;

    public ResponseServer(String originServer) {
        this.originServer = originServer;
    }

    public ResponseServer() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Args.notNull(response, "HTTP response");
        if (!response.containsHeader("Server") && this.originServer != null) {
            response.addHeader("Server", this.originServer);
        }
    }
}

