/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.jackson.databind.ext;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.talend.bigdata.jackson.core.JsonGenerator;
import org.talend.bigdata.jackson.core.JsonToken;
import org.talend.bigdata.jackson.core.type.WritableTypeId;
import org.talend.bigdata.jackson.databind.JavaType;
import org.talend.bigdata.jackson.databind.JsonMappingException;
import org.talend.bigdata.jackson.databind.SerializerProvider;
import org.talend.bigdata.jackson.databind.annotation.JacksonStdImpl;
import org.talend.bigdata.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import org.talend.bigdata.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import org.talend.bigdata.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import org.talend.bigdata.jackson.databind.jsontype.TypeSerializer;
import org.talend.bigdata.jackson.databind.ser.std.StdScalarSerializer;

@JacksonStdImpl
public class SqlBlobSerializer
extends StdScalarSerializer<Blob> {
    public SqlBlobSerializer() {
        super(Blob.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, Blob value) {
        return value == null;
    }

    @Override
    public void serialize(Blob value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        this._writeValue(value, gen, ctxt);
    }

    @Override
    public void serializeWithType(Blob value, JsonGenerator gen, SerializerProvider ctxt, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(gen, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        this._writeValue(value, gen, ctxt);
        typeSer.writeTypeSuffix(gen, typeIdDef);
    }

    protected void _writeValue(Blob value, JsonGenerator gen, SerializerProvider ctxt) throws IOException {
        InputStream in = null;
        try {
            in = value.getBinaryStream();
        }
        catch (SQLException e) {
            ctxt.reportMappingProblem(e, "Failed to access `java.sql.Blob` value to write as binary value", new Object[0]);
        }
        gen.writeBinary(ctxt.getConfig().getBase64Variant(), in, -1);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

