/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpRequestInterceptor;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.StatusLine;
import org.talend.bigdata.http.client.HttpRequestRetryHandler;
import org.talend.bigdata.http.client.ServiceUnavailableRetryStrategy;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.client.utils.URIBuilder;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.http.impl.client.HttpClientBuilder;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.http.util.EntityUtils;
import org.talend.bigdata.jackson.core.JsonProcessingException;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.SerializationFeature;
import org.talend.bigdata.jackson.databind.node.ArrayNode;
import org.talend.bigdata.jackson.databind.node.ObjectNode;
import org.talend.bigdata.lang3.tuple.Pair;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.databricks.DatabricksCluster;
import org.talend.bigdata.launcher.databricks.api.jobs.Endpoints;
import org.talend.bigdata.launcher.fs.DatabricksFileSystem;
import org.talend.bigdata.launcher.fs.DatabricksUCFileSystem;
import org.talend.bigdata.launcher.fs.DatabricksWSFileSystem;
import org.talend.bigdata.launcher.utils.BigDataLauncherException;

public abstract class DatabricksJob
extends Job {
    protected boolean isCancelled;
    protected boolean isRunSubmit;
    protected String mJarToExecute;
    protected String mClassToExecute;
    protected String mAppName;
    protected String mjobJarName;
    protected final String endpoint;
    protected String mRunId;
    protected String mJobId;
    protected Map<String, String> mConf;
    protected String token;
    protected String mClusterId;
    protected Map<String, String> mTuningConf;
    protected DatabricksFileSystem mFileSystem;
    protected DatabricksUCFileSystem mUCFileSystem;
    protected DatabricksWSFileSystem mWSFileSystem;
    protected String mFilePath;
    protected String mLibJars;
    protected List<String> mLibraries;
    protected List<String> mArgs;
    protected String userAgent;
    protected DatabricksCluster transientCluster;
    protected RunLifeCycleState lifeCycleState;
    protected RunResultState resultState;
    protected boolean production;
    protected boolean isUC;
    protected boolean isWS;
    protected boolean isACLEnabled;
    protected String mUserName;
    protected String mSPName;
    protected String mPermissionLevel;
    protected String mGroupName;
    protected long msBeforeRequest;
    protected CloseableHttpClient httpClient;
    private static final Logger LOG = LoggerFactory.getLogger(DatabricksJob.class);
    protected static final int API_RETRY_SLEEP = 5000;
    protected static final int API_MAX_RETRY_COUNT = 10;

    public DatabricksJob(String rootEndpoint) {
        this.endpoint = rootEndpoint;
        this.httpClient = this.createHttpClient();
    }

    private URIBuilder createURIBuilder(String endpoint, Endpoints apiPath) throws URISyntaxException {
        URI baseURI = new URI(endpoint);
        URIBuilder builder = new URIBuilder(endpoint);
        builder.setPath(baseURI.getPath() + apiPath.getAPIPath());
        return builder;
    }

    protected void uploadJars() {
        this.mFileSystem.updateDatabricksJarList(this.mFilePath, this.mjobJarName);
        this.mLibraries = new ArrayList<String>();
        for (String jar : this.mLibJars.split(",")) {
            File jarFile = new File(jar);
            if (!jar.startsWith("dbfs") && this.mFileSystem.notExistsOrIsDifferent(jar, this.mFilePath + jarFile.getName())) {
                this.mFileSystem.copyFromLocal(jar, this.mFilePath + jarFile.getName());
                LOG.debug("Upload of " + jar + " to dbfs:" + this.mFilePath + jarFile.getName());
            } else {
                LOG.debug("Skip upload of " + jar + " because it is already present and of the same size on DBFS");
            }
            this.mLibraries.add("dbfs:" + this.mFilePath + jarFile.getName());
        }
    }

    protected void uploadJarsUC() throws HttpException, IOException {
        this.mUCFileSystem.updateDatabricksJarList(this.mFilePath, this.mjobJarName);
        this.mLibraries = new ArrayList<String>();
        for (String jar : this.mLibJars.split(",")) {
            File jarFile = new File(jar);
            if (this.mUCFileSystem.notExistsOrIsDifferent(jar, this.mFilePath + jarFile.getName())) {
                this.mUCFileSystem.copyFromLocalToUC(jar, this.mFilePath + jarFile.getName());
                LOG.debug("Upload of {} to volume: {}/{}", new Object[]{jar, this.mFilePath, jarFile.getName()});
            } else {
                LOG.debug("Skip upload of {} because it is already present and of the same size on volume", (Object)jar);
            }
            this.mLibraries.add(this.mFilePath + jarFile.getName());
        }
    }

    public void uploadJarsWS() throws HttpException, IOException {
        this.mWSFileSystem.updateDatabricksJarList(this.mFilePath, this.mjobJarName);
        this.mLibraries = new ArrayList<String>();
        for (String jar : this.mLibJars.split(",")) {
            File jarFile = new File(jar);
            this.mWSFileSystem.copyFromLocalToWS(jar, this.mFilePath + jarFile.getName(), this.mFilePath);
            LOG.debug("Upload of {} to workspace: {}{} in folder {}", new Object[]{jar, this.mFilePath, jarFile.getName(), this.mFilePath});
            this.mLibraries.add(this.mFilePath + jarFile.getName());
        }
    }

    protected String createJobObject() throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, true);
        return this.createJobObject(mapper);
    }

    protected String createJobObject(ObjectMapper mapper) throws JsonProcessingException {
        ObjectNode body = mapper.createObjectNode();
        body.put("run_name", this.mAppName);
        body.put("name", this.mAppName);
        if (!this.useTransientCuster()) {
            body.put("existing_cluster_id", this.mClusterId);
        } else {
            body.set("new_cluster", (JsonNode)mapper.valueToTree(this.transientCluster));
        }
        ObjectNode spark_jar_body = mapper.createObjectNode();
        spark_jar_body.put("main_class_name", this.mClassToExecute);
        if (this.mArgs != null && this.mArgs.size() > 0) {
            ArrayList<String> parameters = new ArrayList<String>(this.mArgs);
            parameters.add("-calledByDatabricks");
            spark_jar_body.set("parameters", (JsonNode)mapper.valueToTree(parameters));
        }
        body.set("spark_jar_task", spark_jar_body);
        if (this.isACLEnabled) {
            ObjectNode acl_body = mapper.createObjectNode();
            if (this.mUserName != null && this.mPermissionLevel != null) {
                acl_body.put("user_name", this.mUserName);
                acl_body.put("permission_level", this.mPermissionLevel);
            }
            if (this.mGroupName != null && this.mPermissionLevel != null) {
                acl_body.put("group_name", this.mGroupName);
                acl_body.put("permission_level", this.mPermissionLevel);
            }
            if (this.mSPName != null && this.mPermissionLevel != null) {
                acl_body.put("service_principal", this.mSPName);
                acl_body.put("permission_level", this.mPermissionLevel);
            }
            body.set("access_control_list", acl_body);
        }
        if (this.mLibraries != null && this.mLibraries.size() > 0) {
            ArrayNode libraries_body = mapper.createArrayNode();
            List libraries_nodes = this.mLibraries.stream().map(jar -> mapper.createObjectNode().put("jar", (String)jar)).collect(Collectors.toList());
            libraries_body.addAll(libraries_nodes);
            body.set("libraries", libraries_body);
        }
        return mapper.writeValueAsString(body);
    }

    protected synchronized void createJobAndRun() {
        URI runEndpoint;
        HttpResponse response;
        URI apiEndpoint;
        String body;
        if (this.isCancelled) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        if (this.isRunSubmit) {
            try {
                body = this.createJobObject(mapper);
                apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.RUNS_SUBMIT).build();
                Request httpRequest = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body, ContentType.APPLICATION_JSON);
                response = Executor.newInstance(this.httpClient).execute(httpRequest).returnResponse();
                if (response.getStatusLine().getStatusCode() != 200) {
                    LOG.error(EntityUtils.toString(response.getEntity(), "UTF-8"));
                    throw new BigDataLauncherException(this.getErrorMessage(response.getStatusLine().toString(), Endpoints.RUNS_SUBMIT.getAPIPath()));
                }
                JsonNode json = mapper.readTree(response.getEntity().getContent());
                this.mRunId = json.get("run_id").asText("null");
                LOG.info(String.format("Job submitted with id %s", this.mRunId));
            }
            catch (UnsupportedEncodingException uee) {
                throw new BigDataLauncherException("current platform does not support charset " + ContentType.APPLICATION_JSON.getCharset().displayName());
            }
            catch (IOException | URISyntaxException ioe) {
                throw new BigDataLauncherException("unexpected I/O error", ioe);
            }
        }
        try {
            body = this.createJobObject(mapper);
            apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.CREATE).build();
            Request htttpRequest = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body, ContentType.APPLICATION_JSON);
            response = Executor.newInstance(this.httpClient).execute(htttpRequest).returnResponse();
            if (response.getStatusLine().getStatusCode() != 200) {
                LOG.error(EntityUtils.toString(response.getEntity(), "UTF-8"));
                throw new BigDataLauncherException(this.getErrorMessage(response.getStatusLine().toString(), Endpoints.CREATE.getAPIPath()));
            }
            JsonNode json = mapper.readTree(response.getEntity().getContent());
            this.mJobId = json.get("job_id").asText("null");
            LOG.info("Job created with id : " + this.mJobId);
        }
        catch (UnsupportedEncodingException uee) {
            throw new BigDataLauncherException("current platform does not support charset " + ContentType.APPLICATION_JSON.getCharset().displayName());
        }
        catch (IOException | URISyntaxException ioe) {
            throw new BigDataLauncherException("unexpected I/O error", ioe);
        }
        try {
            ObjectNode node = mapper.createObjectNode();
            node.put("job_id", this.mJobId);
            String body2 = mapper.writeValueAsString(node);
            URI apiEndpoint2 = this.createURIBuilder(this.endpoint, Endpoints.RUN_NOW).build();
            Request htttpRequest = Request.Post(apiEndpoint2).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body2, ContentType.APPLICATION_JSON);
            HttpResponse response2 = Executor.newInstance(this.httpClient).execute(htttpRequest).returnResponse();
            if (response2.getStatusLine().getStatusCode() != 200) {
                throw new BigDataLauncherException(this.getErrorMessage(response2.getStatusLine().toString(), Endpoints.CREATE.getAPIPath()));
            }
            JsonNode json = mapper.readTree(response2.getEntity().getContent());
            this.mRunId = json.get("run_id").asText("null");
            LOG.info("Run started with id : " + this.mRunId);
        }
        catch (UnsupportedEncodingException uee) {
            throw new BigDataLauncherException("current platform does not support charset " + ContentType.APPLICATION_JSON.getCharset().displayName());
        }
        catch (IOException | URISyntaxException ioe) {
            throw new BigDataLauncherException("unexpected I/O error", ioe);
        }
        try {
            runEndpoint = this.createURIBuilder(this.endpoint, Endpoints.RUNS_GET).setParameter("run_id", this.mRunId).build();
        }
        catch (URISyntaxException use) {
            throw new BigDataLauncherException(String.format("ensure endpoint is correctly set (was: %s)", this.endpoint), use);
        }
        try {
            Request httpRequest = Request.Get(runEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token);
            HttpResponse response3 = Executor.newInstance(this.httpClient).execute(httpRequest).returnResponse();
            JsonNode json = mapper.readTree(response3.getEntity().getContent());
            if (json.get("run_page_url") != null) {
                LOG.info(String.format("logs of job : %s", json.get("run_page_url").asText("null")));
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new BigDataLauncherException("current platform does not support charset " + ContentType.APPLICATION_JSON.getCharset().displayName());
        }
        catch (IOException ioe) {
            throw new BigDataLauncherException("unexpected I/O error", ioe);
        }
    }

    protected int restartCluster() {
        try {
            HttpResponse response;
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("cluster_id", this.mClusterId);
            String body = mapper.writeValueAsString(node);
            if (this.isClusterTerminated()) {
                URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.START_CLUSTER).build();
                Request htttpRequest = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body, ContentType.APPLICATION_JSON);
                response = Executor.newInstance(this.httpClient).execute(htttpRequest).returnResponse();
                if (response.getStatusLine().getStatusCode() != 200) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(this.getStatusMessage(response.getStatusLine().toString(), Endpoints.START_CLUSTER.getAPIPath()));
                    }
                    throw new BigDataLauncherException(this.getErrorMessage(response.getStatusLine().toString(), Endpoints.START_CLUSTER.getAPIPath(), response.getEntity().toString()));
                }
                LOG.info("Cluster started with id : " + this.mClusterId);
            } else {
                URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.RESTART_CLUSTER).build();
                Request htttpRequest = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body, ContentType.APPLICATION_JSON);
                response = Executor.newInstance(this.httpClient).execute(htttpRequest).returnResponse();
                if (response.getStatusLine().getStatusCode() != 200) {
                    if (LOG.isErrorEnabled()) {
                        LOG.error(this.getStatusMessage(response.getStatusLine().toString(), Endpoints.RESTART_CLUSTER.getAPIPath()));
                    }
                    throw new BigDataLauncherException(this.getErrorMessage(response.getStatusLine().toString(), Endpoints.RESTART_CLUSTER.getAPIPath(), response.getEntity().toString()));
                }
                LOG.info("Cluster restarted with id : " + this.mClusterId);
            }
            return response.getStatusLine().getStatusCode();
        }
        catch (IOException | URISyntaxException ioe) {
            throw new BigDataLauncherException("unexpected I/O error", ioe);
        }
    }

    protected boolean isClusterTerminated() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            ObjectNode node = mapper.createObjectNode();
            node.put("cluster_id", this.mClusterId);
            String body = mapper.writeValueAsString(node);
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.GET_CLUSTERS).build();
            Request htttpRequest = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body, ContentType.APPLICATION_JSON);
            HttpResponse response = Executor.newInstance(this.httpClient).execute(htttpRequest).returnResponse();
            boolean result = true;
            if (response.getStatusLine().getStatusCode() != 200) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(this.getStatusMessage(response.getStatusLine().toString(), Endpoints.RESTART_CLUSTER.getAPIPath()));
                }
                throw new BigDataLauncherException(this.getErrorMessage(response.getStatusLine().toString(), Endpoints.RESTART_CLUSTER.getAPIPath(), response.getEntity().toString()));
            }
            JsonNode json = mapper.readTree(response.getEntity().getContent());
            String clusterStatus = json.get("state").asText("null");
            result = "TERMINATED".equals(clusterStatus);
            return result;
        }
        catch (IOException | URISyntaxException ioe) {
            throw new BigDataLauncherException("unexpected I/O error", ioe);
        }
    }

    protected int getReturnCodeFromState(RunLifeCycleState lifeCycleState, RunResultState resultState) {
        if (lifeCycleState.compareTo(RunLifeCycleState.TERMINATED) == 0 && resultState.compareTo(RunResultState.SUCCESS) == 0) {
            return 0;
        }
        LOG.error("Run terminated with status " + lifeCycleState.name() + " and result " + resultState.name() + "\nCheck logs on Spark UI for more information");
        return 1;
    }

    protected boolean isJobDone(RunLifeCycleState state) {
        return state.compareTo(RunLifeCycleState.TERMINATED) == 0 || state.compareTo(RunLifeCycleState.SKIPPED) == 0 || state.compareTo(RunLifeCycleState.INTERNAL_ERROR) == 0;
    }

    protected <T extends Enum<T>> T jsonToEnum(Class<T> clazz, JsonNode node) {
        T resultState = null;
        if (node != null && node.asText() != null) {
            try {
                resultState = Enum.valueOf(clazz, node.asText());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return resultState;
    }

    protected int awaitEnd() {
        URI runEndpoint;
        ObjectMapper mapper = new ObjectMapper();
        try {
            runEndpoint = this.createURIBuilder(this.endpoint, Endpoints.RUNS_GET).setParameter("run_id", this.mRunId).build();
        }
        catch (URISyntaxException use) {
            throw new BigDataLauncherException(String.format("ensure endpoint is correctly set (was: %s)", this.endpoint), use);
        }
        Request httpRequest = Request.Get(runEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token);
        AtomicInteger maxRetry = new AtomicInteger(3);
        do {
            try {
                Thread.sleep(this.msBeforeRequest);
                Pair result = Executor.newInstance(this.httpClient).execute(httpRequest).handleResponse(httpResponse -> {
                    maxRetry.set(3);
                    int status = httpResponse.getStatusLine().getStatusCode();
                    if (status == 200) {
                        JsonNode node = mapper.readTree(httpResponse.getEntity().getContent());
                        JsonNode state = node.get("state");
                        RunLifeCycleState lifeCycleState = this.jsonToEnum(RunLifeCycleState.class, state.get("life_cycle_state"));
                        RunResultState resultState = this.jsonToEnum(RunResultState.class, state.get("result_state"));
                        LOG.info("Run status : " + (Object)((Object)lifeCycleState) + ", " + state.get("state_message").asText());
                        LOG.info("Run result : " + (Object)((Object)resultState));
                        return Pair.of(lifeCycleState, resultState);
                    }
                    LOG.error(this.getStatusMessage(httpResponse.getStatusLine().toString(), Endpoints.RUNS_GET.getAPIPath()));
                    throw new BigDataLauncherException(this.getStatusMessage(String.valueOf(status), Endpoints.RUNS_GET.getAPIPath()));
                });
                this.lifeCycleState = (RunLifeCycleState)((Object)result.getLeft());
                this.resultState = (RunResultState)((Object)result.getRight());
            }
            catch (InterruptedException ie) {
                throw new BigDataLauncherException("Interruption requested", ie);
            }
            catch (IOException e) {
                if (maxRetry.getAndDecrement() >= 0) continue;
                throw new BigDataLauncherException("Unexpected error", e);
            }
        } while (!this.isJobDone(this.lifeCycleState));
        return this.getReturnCodeFromState(this.lifeCycleState, this.resultState);
    }

    @Override
    public int executeJob() throws BigDataLauncherException, HttpException, IOException {
        this.lifeCycleState = RunLifeCycleState.PENDING;
        if (this.isUC) {
            this.mUCFileSystem = new DatabricksUCFileSystem(this.endpoint, this.token, this.userAgent, true, this.httpClient);
            this.uploadJarsUC();
        } else if (this.isWS) {
            this.mWSFileSystem = new DatabricksWSFileSystem(this.endpoint, this.token, this.userAgent, true, this.httpClient);
            this.uploadJarsWS();
        } else {
            this.mFileSystem = new DatabricksFileSystem(this.endpoint, this.token, this.userAgent, true, this.httpClient);
            this.uploadJars();
        }
        if (!this.useTransientCuster() && !this.production) {
            this.restartCluster();
        }
        this.createJobAndRun();
        return this.awaitEnd();
    }

    private boolean useTransientCuster() {
        return this.transientCluster != null;
    }

    @Override
    public synchronized void cancelJob() throws InterruptedException, URISyntaxException, IOException {
        this.isCancelled = true;
        if (this.mRunId == null) {
            return;
        }
        if (!RunLifeCycleState.PENDING.equals((Object)this.lifeCycleState) && !RunLifeCycleState.RUNNING.equals((Object)this.lifeCycleState)) {
            return;
        }
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode node = mapper.createObjectNode();
        node.put("run_id", this.mRunId);
        String body = mapper.writeValueAsString(node);
        URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.RUNS_CANCEL).build();
        Request httpRequest = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).bodyString(body, ContentType.APPLICATION_JSON);
        StatusLine responseStatus = Executor.newInstance(this.httpClient).execute(httpRequest).returnResponse().getStatusLine();
        int status = responseStatus.getStatusCode();
        if (status != 200) {
            if (LOG.isErrorEnabled()) {
                LOG.error(this.getStatusMessage(responseStatus.toString(), Endpoints.RUNS_CANCEL.getAPIPath()));
            }
            throw new BigDataLauncherException(this.getStatusMessage(responseStatus.toString(), Endpoints.RUNS_CANCEL.getAPIPath()));
        }
        this.awaitEnd();
        LOG.info("Run " + this.mRunId + " canceled");
    }

    private CloseableHttpClient createHttpClient() {
        HttpRequestInterceptor logInterceptor = (request, context) -> {
            LOG.info("###");
            LOG.info(String.format("%s | Cluster ID : %s", request.getRequestLine().toString(), this.mClusterId));
            LOG.debug("");
            Arrays.stream(request.getAllHeaders()).filter(x -> !"Authorization".equals(x.getName())).map(Object::toString).forEach(arg_0 -> ((Logger)LOG).debug(arg_0));
            LOG.debug("");
            LOG.info("###");
        };
        HttpRequestRetryHandler retryHandler = new HttpRequestRetryHandler(){

            @Override
            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                if (executionCount < 10) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return true;
                }
                return false;
            }
        };
        ServiceUnavailableRetryStrategy serviceUnavailStrategy = new ServiceUnavailableRetryStrategy(){

            @Override
            public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
                if (response.getStatusLine().getStatusCode() == 429 && executionCount < 10) {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    LOG.info("attempting a retry on 429 error");
                    return true;
                }
                return false;
            }

            @Override
            public long getRetryInterval() {
                return 5000L;
            }
        };
        return HttpClientBuilder.create().setRetryHandler(retryHandler).setServiceUnavailableRetryStrategy(serviceUnavailStrategy).addInterceptorLast(logInterceptor).build();
    }

    private String getErrorMessage(String statusLine, String endpoint, String responseEntity) {
        return String.format("Error response '%s' for %s : %s", statusLine, endpoint, responseEntity);
    }

    private String getErrorMessage(String statusLine, String endpoint) {
        return String.format("Error response '%s' for %s", statusLine, endpoint);
    }

    private String getStatusMessage(String statusLine, String endpoint) {
        return String.format("Status '%s' for %s", statusLine, endpoint);
    }

    public static enum RunLifeCycleState {
        PENDING,
        RUNNING,
        TERMINATING,
        TERMINATED,
        SKIPPED,
        INTERNAL_ERROR;

    }

    public static enum RunResultState {
        SUCCESS,
        FAILED,
        TIMEOUT,
        CANCELED;

    }
}

