/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.client.utils.URIBuilder;
import org.talend.bigdata.io.IOUtils;
import org.talend.bigdata.jackson.databind.DeserializationFeature;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.launcher.databricks.api.policies.Endpoints;
import org.talend.bigdata.launcher.utils.BigDataLauncherException;

public class DatabricksPoliciesClient {
    public final String endpoint;
    public final String token;
    public final String userAgent;
    private static Logger LOG = LoggerFactory.getLogger(DatabricksPoliciesClient.class);
    private ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public DatabricksPoliciesClient(String endpoint, String token, String userAgent) {
        this.endpoint = endpoint;
        this.token = token;
        this.userAgent = userAgent;
    }

    private URIBuilder createURIBuilder(String endpoint, Endpoints apiPath) throws URISyntaxException {
        URI baseURI = new URI(endpoint);
        URIBuilder builder = new URIBuilder(endpoint);
        builder.setPath(baseURI.getPath() + apiPath.getAPIPath());
        return builder;
    }

    public String getPolicyId(String policyName) {
        List<Policy> policies = this.getPolicies();
        for (Policy policy : policies) {
            if (policyName == null || !policyName.equals(policy.name)) continue;
            return policy.policy_id;
        }
        return "POLICY_NOT_FOUND(" + policyName + ")";
    }

    public List<Policy> getPolicies() throws BigDataLauncherException {
        try {
            List<Policy> result;
            URI uri = this.createURIBuilder(this.endpoint, Endpoints.LIST_POLICIES).build();
            Request request = Request.Get(uri).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token);
            HttpResponse response = request.execute().returnResponse();
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    List<Policy> policies = this.mapper.readValue((InputStream)response.getEntity().getContent(), PolicyList.class).policies;
                    if (policies == null) {
                        policies = Collections.emptyList();
                    }
                    result = policies;
                    break;
                }
                case 404: {
                    result = Collections.emptyList();
                    break;
                }
                default: {
                    LOG.debug(String.valueOf(response.getStatusLine().getStatusCode()));
                    throw new HttpException(IOUtils.toString(response.getEntity().getContent()));
                }
            }
            return result;
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting policies", new Object[0]), e);
        }
    }

    public static class Policy {
        public String policy_id;
        public String name;
        public String definition;
        public Long created_at_timestamp;
    }

    public static class PolicyList {
        public List<Policy> policies;
    }

    public static class Builder {
        private String endpoint;
        private String token;
        private String userAgent;

        public Builder withEndpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public Builder withToken(String token) {
            this.token = token;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        public DatabricksPoliciesClient build() {
            return new DatabricksPoliciesClient(this.endpoint, this.token, this.userAgent);
        }
    }
}

