/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.databricks;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.databricks.DatabricksCluster;
import org.talend.bigdata.launcher.databricks.DatabricksJob;
import org.talend.bigdata.launcher.security.Credentials;

public class SparkBatchJob
extends DatabricksJob {
    private SparkBatchJob(String appName, String jobJarName, String jarToExecute, String classToExecute, String endpoint, Credentials credentials, Map<String, String> conf, Map<String, String> tuningConf, String token, String clusterId, String libjars, String filePath, List<String> args, String userAgent, DatabricksCluster cluster, boolean production, long msBeforeRequest, boolean isRunSubmit, boolean isUC, boolean isWS, boolean isACLEnabled, String user, String group, String sp, String permission) {
        super(endpoint);
        this.mAppName = appName;
        this.mjobJarName = jobJarName;
        this.mJarToExecute = jarToExecute;
        this.mClassToExecute = classToExecute;
        this.mCredentials = credentials;
        this.mConf = conf;
        this.mTuningConf = tuningConf;
        this.token = token;
        this.mClusterId = clusterId;
        this.mLibJars = libjars;
        this.mFilePath = filePath;
        this.mArgs = args;
        this.userAgent = userAgent;
        this.transientCluster = cluster;
        this.production = production;
        this.msBeforeRequest = msBeforeRequest;
        this.isRunSubmit = isRunSubmit;
        this.isUC = isUC;
        this.isWS = isWS;
        this.isACLEnabled = isACLEnabled;
        this.mUserName = user;
        this.mGroupName = group;
        this.mSPName = sp;
        this.mPermissionLevel = permission;
    }

    public static class Builder {
        private String mJarToExecute;
        private String mClassToExecute;
        private String mAppName;
        private String mjobJarName;
        private String mEndpoint;
        private String mToken;
        private String mClusterId;
        private Credentials mCredentials;
        private Map<String, String> mConf;
        private Map<String, String> mTuningConf;
        private String mLibJars;
        private String mFilePath;
        private List<String> mArgs;
        private String mUserAgent;
        private DatabricksCluster transientCluster;
        private boolean production;
        private long msBeforeRequest;
        private boolean isRunSubmit;
        private boolean isUC;
        private boolean isWS;
        private boolean isACLEnabled;
        private String mUserName;
        private String mGroupName;
        private String mSPName;
        private String mPermissionLevel;

        public Builder withAppName(String appName) {
            this.mAppName = appName;
            return this;
        }

        public Builder withJobJarName(String jobJarName) {
            this.mjobJarName = jobJarName;
            return this;
        }

        public Builder withJarToExecute(String jarToExecute) {
            this.mJarToExecute = jarToExecute;
            return this;
        }

        public Builder withClassToExecute(String classToExecute) {
            this.mClassToExecute = classToExecute;
            return this;
        }

        public Builder withEndpoint(String endpoint) {
            this.mEndpoint = endpoint;
            return this;
        }

        public Builder withCredentials(Credentials credentials) {
            this.mCredentials = credentials;
            return this;
        }

        public Builder withConf(Map<String, String> conf) {
            this.mConf = conf;
            return this;
        }

        public Builder withTuningConf(Map<String, String> conf) {
            this.mTuningConf = conf;
            return this;
        }

        public Builder withToken(String token) {
            this.mToken = token;
            return this;
        }

        public Builder withU2MToken(String U2MToken) {
            this.mToken = U2MToken;
            return this;
        }

        public Builder withM2MToken(String M2MToken) {
            this.mToken = M2MToken;
            return this;
        }

        public Builder withClusterId(String clusterId) {
            this.mClusterId = clusterId;
            return this;
        }

        public Builder withLibJars(String libjars) {
            this.mLibJars = libjars;
            return this;
        }

        public Builder withFilePath(String path) {
            this.mFilePath = "/FileStore" + path;
            this.isUC = false;
            this.isWS = false;
            return this;
        }

        public Builder withFilePath(String catalog, String schema, String volume, String path) {
            this.mFilePath = "/Volumes/" + catalog.concat("/") + schema.concat("/") + volume + path;
            this.isUC = true;
            this.isWS = false;
            return this;
        }

        public Builder withFilePathWS(String path) {
            this.mFilePath = "/Workspace/" + path;
            this.isUC = false;
            this.isWS = true;
            return this;
        }

        public Builder withArgs(List<String> args) {
            this.mArgs = args;
            return this;
        }

        public Builder withUserAgent(String userAgent) {
            this.mUserAgent = userAgent;
            return this;
        }

        public Builder withTransientCluster(DatabricksCluster cluster) {
            this.transientCluster = cluster;
            return this;
        }

        public Builder withProductionMode(boolean production) {
            this.production = production;
            return this;
        }

        public Builder withCustomIntervalBetweenRequests(long msBeforeRequest) {
            this.msBeforeRequest = msBeforeRequest;
            return this;
        }

        public Builder withRunSubmit(boolean isRunSubmit) {
            this.isRunSubmit = isRunSubmit;
            return this;
        }

        public Builder withACL(boolean isACL) {
            this.isACLEnabled = isACL;
            return this;
        }

        public Builder withUser(String user) {
            this.mUserName = user;
            return this;
        }

        public Builder withGroup(String group) {
            this.mGroupName = group;
            return this;
        }

        public Builder withSP(String sp) {
            this.mSPName = sp;
            return this;
        }

        public Builder withPermission(String permission) {
            this.mPermissionLevel = permission;
            return this;
        }

        public SparkBatchJob build() {
            return new SparkBatchJob(this.mAppName, this.mjobJarName, this.mJarToExecute, this.mClassToExecute, this.mEndpoint, this.mCredentials, this.mConf, this.mTuningConf, this.mToken, this.mClusterId, this.mLibJars, this.mFilePath, this.mArgs, this.mUserAgent, this.transientCluster, this.production, this.msBeforeRequest, this.isRunSubmit, this.isUC, this.isWS, this.isACLEnabled, this.mUserName, this.mGroupName, this.mSPName, this.mPermissionLevel);
        }
    }
}

