/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.client.utils.URIBuilder;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.http.entity.StringEntity;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.jackson.databind.DeserializationFeature;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ObjectNode;
import org.talend.bigdata.launcher.databricks.api.workspace.Endpoints;
import org.talend.bigdata.launcher.fs.DatabricksFileSystem;
import org.talend.bigdata.launcher.utils.BigDataLauncherException;

public class DatabricksUCFileSystem
extends DatabricksFileSystem {
    public final String endpoint;
    public final String token;
    public final String userAgent;
    protected CloseableHttpClient httpClient;
    protected static final Logger LOG = LoggerFactory.getLogger(DatabricksUCFileSystem.class);
    private final ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public DatabricksUCFileSystem(String endpoint, String token, String userAgent, boolean overwrite, CloseableHttpClient httpClient) {
        super(endpoint, token, userAgent);
        this.endpoint = endpoint;
        this.token = token;
        this.userAgent = userAgent;
        this.overwrite = overwrite;
        this.httpClient = httpClient;
    }

    private URIBuilder createURIBuilderWithPath(String endpoint, org.talend.bigdata.launcher.databricks.api.files.Endpoints apiPath, String path) throws URISyntaxException {
        URI baseURI = new URI(endpoint);
        URIBuilder builder = new URIBuilder(endpoint);
        builder.setPath(baseURI.getPath() + apiPath.getAPIPath() + path);
        return builder;
    }

    public void copyFromLocalToUC(String localFile, String path) throws IOException {
        File file = new File(localFile);
        FileInputStream fis = new FileInputStream(file);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        try {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("path", path);
            node.put("overwrite", this.overwrite);
            URI apiEndpoint = this.createURIBuilderWithPath(this.endpoint, org.talend.bigdata.launcher.databricks.api.files.Endpoints.CREATE, path).build();
            Request request = Request.Put(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON)).bodyStream(fis);
            Executor.newInstance(this.httpClient).execute(request).returnResponse();
        }
        catch (IOException | URISyntaxException e) {
            throw new BigDataLauncherException(String.format("Error creating file at '%s'", path), e);
        }
    }

    @Override
    public List<DatabricksFileSystem.FileInfo> list(String folder, boolean includeSubDir) throws BigDataLauncherException {
        try {
            URI uri = this.createURIBuilder(this.endpoint, Endpoints.LIST).setParameter("path", folder).build();
            return this.getFileInfoList(uri, includeSubDir);
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting content of remote folder '%s'", folder), e);
        }
    }

    @Override
    public DatabricksFileSystem.FileInfo getStatus(String remoteFile) {
        try {
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.GET_STATUS).setParameter("path", remoteFile).build();
            return this.getFileInfo(apiEndpoint);
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting status of remote file '%s'", remoteFile), e);
        }
    }
}

