/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.Path;
import org.talend.bigdata.launcher.fs.FileSystem;

public class HadoopFileSystem
extends FileSystem {
    protected org.apache.hadoop.fs.FileSystem fs;

    public HadoopFileSystem(org.apache.hadoop.fs.FileSystem fs) {
        this.fs = fs;
    }

    public HadoopFileSystem(Configuration conf) throws IOException {
        this.fs = org.apache.hadoop.fs.FileSystem.get((Configuration)conf);
    }

    @Override
    public boolean exists(String file) {
        boolean doesExist = false;
        try {
            doesExist = this.fs.exists(new Path(file));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return doesExist;
    }

    @Override
    public InputStream open(String file) {
        FSDataInputStream is = null;
        try {
            is = this.fs.open(new Path(file));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return is;
    }

    @Override
    public void delete(String folder) {
        try {
            this.fs.delete(new Path(folder), true);
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void mkdir(String folder) {
        try {
            this.fs.mkdirs(new Path(folder));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Override
    public void copyFromLocal(String localFile, String targetFolder) {
        try {
            this.fs.copyFromLocalFile(new Path(localFile), new Path(targetFolder));
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    public String getRemoteFileSystemRootPath() {
        return "";
    }

    @Override
    public String getFileSystemPrefix() {
        return org.apache.hadoop.fs.FileSystem.getDefaultUri((Configuration)this.fs.getConf()).toString();
    }
}

