/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.http.protocol;

import java.io.IOException;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpRequest;
import org.talend.bigdata.http.HttpRequestInterceptor;
import org.talend.bigdata.http.annotation.Contract;
import org.talend.bigdata.http.annotation.ThreadingBehavior;
import org.talend.bigdata.http.protocol.HttpContext;
import org.talend.bigdata.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

