/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpHost;
import org.talend.bigdata.http.HttpRequestInterceptor;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.auth.AuthScope;
import org.talend.bigdata.http.client.config.RequestConfig;
import org.talend.bigdata.http.config.RegistryBuilder;
import org.talend.bigdata.http.conn.socket.PlainConnectionSocketFactory;
import org.talend.bigdata.http.conn.ssl.NoopHostnameVerifier;
import org.talend.bigdata.http.conn.ssl.SSLConnectionSocketFactory;
import org.talend.bigdata.http.impl.client.BasicCredentialsProvider;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.http.impl.client.HttpClientBuilder;
import org.talend.bigdata.http.impl.conn.PoolingHttpClientConnectionManager;
import org.talend.bigdata.http.message.BasicHeader;
import org.talend.bigdata.http.ssl.SSLContextBuilder;
import org.talend.bigdata.http.util.EntityUtils;
import org.talend.bigdata.jackson.core.JsonProcessingException;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ArrayNode;
import org.talend.bigdata.jackson.databind.node.ObjectNode;
import org.talend.bigdata.launcher.EndpointDescriptor;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.SparkRequestMethod;
import org.talend.bigdata.launcher.utils.Utils;

public abstract class SparkBaseJob
extends Job {
    public static final String SUCCESS = "success";
    public static final String ERROR = "error";
    public static final String DEAD = "dead";
    public static final String CANCELLED = "cancelled";
    public static final String ERROR_WHEN_CALLING = "Error when calling ";
    private static final List<BasicHeader> baseHeaderList = Arrays.asList(new BasicHeader("Accept", "*/*"), new BasicHeader("Cache-Control", "no-cache"), new BasicHeader("Pragma", "no-cache"));
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkBaseJob.class);
    protected FileSystem mFileSystem;
    protected String mRemoteFolder;
    protected String mLivyEndpoint;
    protected String userAgent;
    protected String mLibjars;
    protected String mUsername;
    protected Map<String, String> mConf;
    protected String mAppName;
    protected String mJarToExecute;
    protected String mClassToExecute;
    protected String mDriverMemory;
    protected String mExecutorMemory;
    protected Integer mDriverCore;
    protected Integer mExecutorCore;
    protected List<String> mArgs;
    protected StringBuilder log;
    protected Integer pollingIntervalDuration;
    protected Integer maxMissingStatuses;
    protected Long jobId;

    private CloseableHttpClient createHttpClient(int connectionTimeout, int socketTimeout, boolean useSSLContext, boolean filterAuthorizationHeader, List<BasicHeader> headersList) {
        HttpRequestInterceptor logInterceptor = (request, context) -> {
            String requestLine = request.getRequestLine().toString();
            LOGGER.info("###");
            LOGGER.info(requestLine);
            LOGGER.debug("");
            Stream<String> stringStream = Arrays.stream(request.getAllHeaders()).map(Object::toString);
            if (filterAuthorizationHeader) {
                stringStream = stringStream.filter(s -> !s.contains("Authorization"));
            }
            stringStream.forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            LOGGER.debug("");
            LOGGER.debug("###");
        };
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(connectionTimeout).setSocketTimeout(socketTimeout).build();
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create().addInterceptorLast(logInterceptor).disableContentCompression().disableAutomaticRetries().setUserAgent(this.userAgent).setDefaultHeaders(headersList).setDefaultRequestConfig(requestConfig);
        if (this.mCredentials != null) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(HttpHost.create(this.mLivyEndpoint)), this.mCredentials);
            httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
        }
        if (useSSLContext) {
            try {
                SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(null, (x509CertChain, authType) -> true).build();
                httpClientBuilder.setSSLContext(sslContext).setConnectionManager(new PoolingHttpClientConnectionManager(RegistryBuilder.create().register("http", PlainConnectionSocketFactory.INSTANCE).register("https", (PlainConnectionSocketFactory)((Object)new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)NoopHostnameVerifier.INSTANCE))).build()));
            }
            catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
                LOGGER.error(e.getMessage());
            }
        }
        return httpClientBuilder.build();
    }

    protected CloseableHttpClient createHttpClient(int connectionTimeout, int socketTimeout) {
        return this.createHttpClient(connectionTimeout, socketTimeout, false, true, baseHeaderList);
    }

    protected CloseableHttpClient createHttpClientWithSSL(int connectionTimeout, int socketTimeout) {
        return this.createHttpClient(connectionTimeout, socketTimeout, true, false, baseHeaderList);
    }

    protected CloseableHttpClient createHttpClientLivy(int connectionTimeout, int socketTimeout) {
        ArrayList<BasicHeader> headerList = new ArrayList<BasicHeader>(baseHeaderList);
        headerList.add(new BasicHeader("Content-Type", "application/json"));
        return this.createHttpClient(connectionTimeout, socketTimeout, false, true, headerList);
    }

    protected int getReturnCode(String state) {
        if (SUCCESS.equals(state)) {
            return 0;
        }
        return 1;
    }

    protected boolean isJobDone(String state) {
        return SUCCESS.equals(state) || CANCELLED.equals(state) || ERROR.equals(state) || DEAD.equals(state);
    }

    protected void checkResponse(EndpointDescriptor request, HttpResponse response) throws HttpException {
        this.checkResponse(request, response, 200);
    }

    protected void checkResponse(EndpointDescriptor request, HttpResponse response, int httpCode) throws HttpException {
        if (response.getStatusLine().getStatusCode() != httpCode) {
            String entityResponse = "";
            LOGGER.error("Error when calling {} - {}", (Object)request.getFullEndpoint(), (Object)response.getStatusLine());
            try {
                entityResponse = EntityUtils.toString(response.getEntity());
                LOGGER.error("Error message: {} ", (Object)entityResponse);
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage());
            }
            throw new HttpException(ERROR_WHEN_CALLING + request.getFullEndpoint() + ": " + response.getStatusLine() + " Message: " + entityResponse);
        }
    }

    protected void checkResponse(EndpointDescriptor request, HttpResponse response, List<Integer> httpCodes) throws HttpException {
        if (httpCodes == null || !httpCodes.contains(response.getStatusLine().getStatusCode())) {
            throw new HttpException(ERROR_WHEN_CALLING + request.getFullEndpoint() + ": " + response.getStatusLine());
        }
    }

    protected ObjectNode createExecuteBodyObjectNode(ObjectMapper mapper) {
        ObjectNode jobj = mapper.createObjectNode();
        if (this.mFileSystem != null && this.mJarToExecute != null) {
            jobj.put("file", this.getPath());
        }
        jobj.put("className", this.mClassToExecute);
        jobj.set("args", this.getArgs(mapper));
        jobj.set("conf", this.getConf(mapper));
        jobj.put("name", this.mAppName);
        if (this.mDriverCore != null) {
            jobj.put("driverCores", this.mDriverCore);
        }
        if (this.mExecutorCore != null) {
            jobj.put("executorCores", this.mExecutorCore);
        }
        if (this.mDriverMemory != null) {
            jobj.put("driverMemory", this.mDriverMemory);
        }
        if (this.mExecutorMemory != null) {
            jobj.put("executorMemory", this.mExecutorMemory);
        }
        return jobj;
    }

    private ObjectNode getConf(ObjectMapper mapper) {
        ObjectNode conf = mapper.createObjectNode();
        if (this.mConf != null) {
            for (Map.Entry<String, String> e : this.mConf.entrySet()) {
                conf.put(e.getKey(), e.getValue());
            }
        }
        return conf;
    }

    private ArrayNode getArgs(ObjectMapper mapper) {
        ArrayNode args = mapper.createArrayNode();
        args.add("-calledByLivy");
        if (this.mArgs != null && !this.mArgs.isEmpty()) {
            for (String mArg : this.mArgs) {
                args.add(mArg);
            }
        }
        return args;
    }

    private String getPath() {
        return this.mFileSystem.getFileSystemPrefix() + "/" + this.mRemoteFolder + "/jar/" + new File(this.mJarToExecute).getName();
    }

    protected abstract String createExecuteBody(ObjectMapper var1, String var2) throws JsonProcessingException;

    protected <T extends EndpointDescriptor> long start(ObjectMapper mapper, String body, int httpCode, T request) throws IOException, HttpException {
        LOGGER.info(" ============================================================================================================================================ ");
        LOGGER.info(" Body: \n\n{}\n", (Object)body);
        LOGGER.info(" ============================================================================================================================================ ");
        HttpResponse response = request.execute();
        this.checkResponse(request, response, httpCode);
        JsonNode result = mapper.readTree(response.getEntity().getContent());
        return result.get("id").asLong();
    }

    protected <T extends EndpointDescriptor> int waitStatus(ObjectMapper mapper, T request) throws InterruptedException, HttpException, IOException {
        String state = ERROR;
        long authorizedMissingCalls = this.maxMissingStatuses.intValue();
        do {
            Thread.sleep(this.pollingIntervalDuration.intValue());
            try {
                HttpResponse response = request.execute();
                this.checkResponse(request, response);
                state = mapper.readTree(response.getEntity().getContent()).get("state").asText();
                LOGGER.info("State : {}", (Object)state);
                authorizedMissingCalls = this.maxMissingStatuses.intValue();
            }
            catch (IOException e) {
                if (--authorizedMissingCalls == 0L) {
                    throw new IOException("Failed to get status of job. Error when calling " + request.getFullEndpoint(), e);
                }
                LOGGER.warn("Failed to get status of job. retrying.");
            }
        } while (!this.isJobDone(state) && authorizedMissingCalls > 0L);
        return this.getReturnCode(state);
    }

    protected <T extends EndpointDescriptor> StringBuilder generateLog(ObjectMapper mapper, T request) throws HttpException {
        try {
            HttpResponse response = request.execute();
            this.checkResponse(request, response);
            JsonNode logsAsJson = mapper.readTree(response.getEntity().getContent()).get("log");
            return Utils.buildLog(logsAsJson);
        }
        catch (IOException e) {
            throw new HttpException(ERROR_WHEN_CALLING + request.getFullEndpoint(), e);
        }
    }

    protected String sendFiles() throws IOException, InvalidKeyException, URISyntaxException {
        return Utils.sendFiles(this.mRemoteFolder, null, this.mFileSystem, this.mJarToExecute, this.mLibjars);
    }

    public StringBuilder getJobLog() {
        return this.log;
    }

    private <T extends EndpointDescriptor> void cancel(T request) throws HttpException {
        HttpResponse response;
        long authorizedMissingCalls = this.maxMissingStatuses.intValue();
        do {
            try {
                response = request.execute();
                this.checkResponse(request, response, Arrays.asList(200, 201, 202));
            }
            catch (IOException | HttpException e) {
                throw new HttpException(ERROR_WHEN_CALLING + request.getFullEndpoint(), e);
            }
        } while (response == null && authorizedMissingCalls > 0L);
    }

    public <T extends EndpointDescriptor> void cancelJob(SparkRequestMethod<T> func) throws Exception {
        for (long max = (long)this.maxMissingStatuses.intValue(); this.jobId == null && max > 0L; --max) {
            Thread.sleep(this.pollingIntervalDuration.intValue());
        }
        if (this.jobId != null) {
            this.cancel((EndpointDescriptor)func.getSparkJobRequest());
        } else {
            LOGGER.error("Can not cancel the job as it seems to not have started (no Job Id)");
        }
    }
}

