/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.fs;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.codec.binary.Base64;
import org.talend.bigdata.http.HttpException;
import org.talend.bigdata.http.HttpResponse;
import org.talend.bigdata.http.client.fluent.Executor;
import org.talend.bigdata.http.client.fluent.Request;
import org.talend.bigdata.http.client.utils.URIBuilder;
import org.talend.bigdata.http.entity.ContentType;
import org.talend.bigdata.http.entity.StringEntity;
import org.talend.bigdata.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.http.impl.client.HttpClientBuilder;
import org.talend.bigdata.io.IOUtils;
import org.talend.bigdata.jackson.databind.DeserializationFeature;
import org.talend.bigdata.jackson.databind.JsonNode;
import org.talend.bigdata.jackson.databind.ObjectMapper;
import org.talend.bigdata.jackson.databind.node.ObjectNode;
import org.talend.bigdata.launcher.databricks.api.dbfs.Endpoints;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.utils.BigDataLauncherException;

public class DatabricksFileSystem
extends FileSystem {
    public final String endpoint;
    public final String token;
    public final String userAgent;
    public String filePath;
    protected String jobJarName;
    protected Map<String, Long> clusterJars;
    protected CloseableHttpClient httpClient;
    protected static final int API_MAX_RETRY = 3;
    protected static final int API_MAX_SIZE = 0x100000;
    protected static Logger LOG = LoggerFactory.getLogger(DatabricksFileSystem.class);
    private ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public DatabricksFileSystem(String endpoint, String token, String userAgent) {
        this(endpoint, token, userAgent, true);
    }

    public DatabricksFileSystem(String endpoint, String token, String userAgent, boolean overwrite) {
        this(endpoint, token, userAgent, overwrite, HttpClientBuilder.create().build());
    }

    public DatabricksFileSystem(String endpoint, String token, String userAgent, boolean overwrite, CloseableHttpClient httpClient) {
        this.endpoint = endpoint;
        this.token = token;
        this.userAgent = userAgent;
        this.overwrite = overwrite;
        this.clusterJars = new HashMap<String, Long>();
        this.httpClient = httpClient;
    }

    private URIBuilder createURIBuilder(String endpoint, Endpoints apiPath) throws URISyntaxException {
        URI baseURI = new URI(endpoint);
        URIBuilder builder = new URIBuilder(endpoint);
        builder.setPath(baseURI.getPath() + apiPath.getAPIPath());
        return builder;
    }

    public FileInfo getStatus(String remoteFile) {
        try {
            FileInfo result;
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.GET_STATUS).setParameter("path", remoteFile).build();
            Request request = Request.Get(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token);
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    result = this.mapper.readValue(response.getEntity().getContent(), FileInfo.class);
                    break;
                }
                case 404: {
                    result = null;
                    break;
                }
                default: {
                    throw new HttpException(String.format("HTTP Protocol Error : ", response.getStatusLine(), apiEndpoint.toString()));
                }
            }
            return result;
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting status of remote file '%s'", remoteFile), e);
        }
    }

    public List<FileInfo> list(String folder) throws BigDataLauncherException {
        return this.list(folder, false);
    }

    public List<FileInfo> list(String folder, boolean includeSubDir) throws BigDataLauncherException {
        try {
            List<FileInfo> result;
            URI uri = this.createURIBuilder(this.endpoint, Endpoints.LIST).setParameter("path", folder).build();
            Request request = Request.Get(uri).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token);
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            switch (response.getStatusLine().getStatusCode()) {
                case 200: {
                    List<FileInfo> fileList = this.mapper.readValue((InputStream)response.getEntity().getContent(), FileInfoList.class).files;
                    if (fileList == null) {
                        fileList = Collections.emptyList();
                    }
                    if (includeSubDir) {
                        FileInfo fileInfo;
                        ListIterator<FileInfo> iter = fileList.listIterator();
                        while (iter.hasNext() && (fileInfo = iter.next()) != null) {
                            if (!fileInfo.is_dir.booleanValue()) continue;
                            for (FileInfo subFileInfo : this.list(fileInfo.path, true)) {
                                iter.add(subFileInfo);
                            }
                        }
                    }
                    result = fileList;
                    break;
                }
                case 404: {
                    result = Collections.emptyList();
                    break;
                }
                default: {
                    LOG.debug(String.valueOf(response.getStatusLine().getStatusCode()));
                    throw new HttpException(IOUtils.toString(response.getEntity().getContent()));
                }
            }
            return result;
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting content of remote folder '%s'", folder), e);
        }
    }

    @Override
    public boolean exists(String file) {
        if (this.clusterJars == null) {
            this.updateDatabricksJarList(this.filePath, this.jobJarName);
        }
        return this.clusterJars.containsKey(file);
    }

    public boolean notExistsOrIsDifferent(String localFile, String mockRemoteFile) {
        FileInfo fileStatus = this.getStatus(mockRemoteFile);
        if (fileStatus == null) {
            LOG.debug(mockRemoteFile + " does not exist on DBFS");
            return true;
        }
        if (mockRemoteFile.toLowerCase().contains(this.jobJarName.toLowerCase())) {
            LOG.info("forcing upload of application jar");
            return true;
        }
        if (new File(localFile).length() != fileStatus.file_size.longValue()) {
            LOG.info(localFile + " has different size, reuploading");
            return true;
        }
        LOG.info("skipping upload of " + localFile);
        return false;
    }

    private OutputStream readFile(OutputStream stream, String path) throws BigDataLauncherException {
        return this.readFileBlock(stream, path, 0, 3);
    }

    private OutputStream readFileBlock(OutputStream stream, String path, int offset, int retry) throws BigDataLauncherException {
        try {
            URI uri = this.createURIBuilder(this.endpoint, Endpoints.READ).setParameter("path", path).setParameter("offset", Integer.toString(offset)).setParameter("length", Integer.toString(0x100000)).build();
            Request request = Request.Get(uri).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token);
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            if (response.getStatusLine().getStatusCode() == 200 && retry > 0) {
                Base64 encoder = new Base64();
                JsonNode node = this.mapper.readTree(response.getEntity().getContent());
                int block_size = Integer.parseInt(String.valueOf(node.get("bytes_read")));
                stream.write(encoder.decode(String.valueOf(node.get("data"))));
                stream.flush();
                if (block_size == 0x100000) {
                    return this.readFileBlock(stream, path, offset + 0x100000, 3);
                }
                return stream;
            }
            if (retry > 0) {
                return this.readFileBlock(stream, path, offset, --retry);
            }
            throw new HttpException(this.mapper.readValue(response.getEntity().getContent(), String.class));
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting content of remote file '%s'", path), e);
        }
    }

    @Override
    public InputStream open(String file) {
        ByteArrayInputStream result;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            this.readFile(stream, file);
            result = new ByteArrayInputStream(stream.toByteArray());
        }
        catch (BigDataLauncherException e) {
            LOG.error("error reading file " + file, (Throwable)e);
            result = new ByteArrayInputStream(new byte[0]);
        }
        return result;
    }

    @Override
    public void delete(String path) throws BigDataLauncherException {
        try {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("path", path);
            node.put("overwrite", this.overwrite);
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.DELETE).build();
            Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(this.mapper.readValue(response.getEntity().getContent(), String.class));
            }
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting content of remote file '%s'", path), e);
        }
    }

    @Override
    public void mkdir(String path) {
        try {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("path", path);
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.MKDIRS).build();
            Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new HttpException(this.mapper.readValue(response.getEntity().getContent(), String.class));
            }
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error getting content of remote file '%s'", path), e);
        }
    }

    private void sendFileBlock(String path, long handle, byte[] block) {
        this.sendFileBlock(path, handle, block, 3);
    }

    private void sendFileBlock(String path, long handle, byte[] block, int retry) {
        try {
            ObjectNode node = this.mapper.createObjectNode();
            node.put("handle", handle);
            node.put("data", new String(block));
            URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.ADD_BLOCK).build();
            Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
            HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
            if (response.getStatusLine().getStatusCode() != 200 && retry > 0) {
                this.sendFileBlock(path, handle, block, --retry);
            } else if (retry == 0) {
                throw new HttpException(this.mapper.readValue(response.getEntity().getContent(), String.class));
            }
        }
        catch (IOException | URISyntaxException | HttpException e) {
            throw new BigDataLauncherException(String.format("Error write block for file '%s'", path), e);
        }
    }

    public void copyToLocal(String remoteFile, String localFile) {
        this.copyToLocal(remoteFile, localFile, true);
    }

    public void copyToLocal(String remoteFile, String localFile, boolean localOverwrite) {
        Path localPath = Paths.get(localFile, new String[0]);
        if (localPath.toFile().exists() && !localOverwrite) {
            throw new BigDataLauncherException("Local file already exists : " + localPath.toAbsolutePath().toString());
        }
        if (!localPath.getParent().toFile().exists() && !localPath.getParent().toFile().mkdirs()) {
            throw new BigDataLauncherException("Could not create local folder : " + localPath.getParent().toAbsolutePath().toString());
        }
        try (FileOutputStream fileOutput = new FileOutputStream(localPath.toFile());){
            this.readFile(fileOutput, remoteFile);
        }
        catch (IOException e) {
            throw new BigDataLauncherException("Unexpected Error: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void copyFromLocal(String localFile, String path) {
        block31: {
            this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            Long handle = null;
            try {
                ObjectNode node = this.mapper.createObjectNode();
                node.put("path", path);
                node.put("overwrite", this.overwrite);
                URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.CREATE).build();
                Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
                HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
                if (response.getStatusLine().getStatusCode() != 200) {
                    if (response.getEntity() != null && response.getEntity().getContent() != null) {
                        throw new HttpException(IOUtils.toString(response.getEntity().getContent()));
                    }
                    throw new HttpException("Unexpected HTTP response code " + response.getStatusLine());
                }
                ReadReponseCreate data = this.mapper.readValue(response.getEntity().getContent(), ReadReponseCreate.class);
                if (data != null) {
                    handle = data.handle;
                }
                if (handle == null) {
                    throw new IOException("Error in reponse: handle value can not be null");
                }
            }
            catch (IOException | URISyntaxException | HttpException e) {
                throw new BigDataLauncherException(String.format("Error creating file at '%s'", path), e);
            }
            File file = new File(localFile);
            int file_length = new Long(file.length()).intValue();
            int buffer_size = Math.min(0x100000, file_length);
            byte[] buffer = new byte[buffer_size];
            Base64 encoder = new Base64();
            try (FileInputStream fis = new FileInputStream(file);
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                while (bis.read(buffer) > 0) {
                    byte[] decodedBytes = encoder.encode(buffer);
                    this.sendFileBlock(path, handle, decodedBytes);
                    if ((file_length -= buffer_size) <= 0 || file_length >= 0x100000) continue;
                    buffer_size = file_length;
                    buffer = new byte[buffer_size];
                }
            }
            try {
                ObjectNode node = this.mapper.createObjectNode();
                node.put("handle", handle);
                URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.CLOSE).build();
                Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
                HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
                if (response.getStatusLine().getStatusCode() != 200) {
                    throw new HttpException(IOUtils.toString(response.getEntity().getContent()));
                }
                break block31;
            }
            catch (IOException | URISyntaxException | HttpException e) {
                throw new BigDataLauncherException(String.format("Error closing file at '%s'", path), e);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    try {
                        ObjectNode node = this.mapper.createObjectNode();
                        node.put("handle", handle);
                        URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.CLOSE).build();
                        Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
                        HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
                        if (response.getStatusLine().getStatusCode() != 200) {
                            throw new HttpException(IOUtils.toString(response.getEntity().getContent()));
                        }
                    }
                    catch (IOException | URISyntaxException | HttpException e2) {
                        throw new BigDataLauncherException(String.format("Error closing file at '%s'", path), e2);
                    }
                    throw throwable;
                }
                try {
                    ObjectNode node = this.mapper.createObjectNode();
                    node.put("handle", handle);
                    URI apiEndpoint = this.createURIBuilder(this.endpoint, Endpoints.CLOSE).build();
                    Request request = Request.Post(apiEndpoint).userAgent(this.userAgent).setHeader("Accept", "*/*").setHeader("Authorization", "Bearer " + this.token).body(new StringEntity(this.mapper.writeValueAsString(node), ContentType.APPLICATION_JSON));
                    HttpResponse response = Executor.newInstance(this.httpClient).execute(request).returnResponse();
                    if (response.getStatusLine().getStatusCode() != 200) {
                        throw new HttpException(IOUtils.toString(response.getEntity().getContent()));
                    }
                }
                catch (IOException | URISyntaxException | HttpException e3) {
                    throw new BigDataLauncherException(String.format("Error closing file at '%s'", path), e3);
                }
            }
        }
    }

    @Override
    public String getFileSystemPrefix() {
        return null;
    }

    public void updateDatabricksJarList(String baseFolder, String jobJarName) {
        this.clusterJars = this.list(baseFolder).stream().filter(x -> x.is_dir == false).collect(Collectors.toMap(x -> x.path, x -> x.file_size));
        this.jobJarName = jobJarName;
    }

    public static class FileInfoList {
        public List<FileInfo> files;
    }

    public static class FileInfo {
        public String path;
        public Boolean is_dir;
        public Long file_size;
    }

    public static class ReadReponseCreate {
        public Long handle;

        public String toString() {
            return "Handle number = " + this.handle + "\n";
        }

        public String toStringHandle() {
            return Long.toString(this.handle);
        }
    }

    public static class ReadResponseOpen {
        public long bytes_read;
        public String data;

        public ReadResponseOpen(long read, String dataFile) {
            Base64 decoder = new Base64();
            byte[] decodedBytes = decoder.decode(dataFile);
            this.bytes_read = read;
            this.data = new String(decodedBytes);
        }

        public String toString() {
            String res = "Bytes read = " + this.bytes_read + "\n";
            res = res + "Data = " + this.data;
            return res;
        }
    }
}

