/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.manage.google.dataproc;

import com.google.api.services.dataproc.Dataproc;
import java.io.IOException;
import java.security.GeneralSecurityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.google.dataproc.DataprocDriver;

public class DataprocDeleteCluster {
    private static Logger LOG = LoggerFactory.getLogger(DataprocDeleteCluster.class);
    protected String talendJobName;
    protected String clusterName;
    protected String projectId;
    protected String region;
    protected String serviceAccountCredentialsPath;

    private DataprocDeleteCluster() {
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public void run() throws IOException, GeneralSecurityException, InterruptedException {
        Dataproc dataproc = DataprocDriver.createDataprocClient(this.talendJobName, this.serviceAccountCredentialsPath);
        LOG.info("Sending deletion request for cluster " + this.clusterName);
        Dataproc.Projects.Regions.Clusters.Delete deleteCluster = dataproc.projects().regions().clusters().delete(this.projectId, this.region, this.clusterName);
        deleteCluster.execute();
        LOG.info("A request has been sent to delete cluster " + this.clusterName);
    }

    public static class Builder {
        private DataprocDeleteCluster dataprocCreateCluster = new DataprocDeleteCluster();

        private Builder() {
        }

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder withServiceAccountCredentialsPath(String serviceAccountCredentialsPath) {
            this.dataprocCreateCluster.serviceAccountCredentialsPath = serviceAccountCredentialsPath;
            return this;
        }

        public Builder withTalendJobName(String talendJobName) {
            this.dataprocCreateCluster.talendJobName = talendJobName;
            return this;
        }

        public Builder withClusterName(String clusterName) {
            this.dataprocCreateCluster.clusterName = clusterName;
            return this;
        }

        public Builder withRegion(String region) {
            this.dataprocCreateCluster.region = region;
            return this;
        }

        public Builder withProjectId(String projectId) {
            this.dataprocCreateCluster.projectId = projectId;
            return this;
        }

        public DataprocDeleteCluster build() {
            return this.dataprocCreateCluster;
        }
    }
}

