/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.utils;

import java.util.List;
import java.util.Map;
import org.talend.bigdata.launcher.SparkBaseJob;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.security.Credentials;
import org.talend.bigdata.launcher.utils.Utils;

public abstract class BaseBuilder<T extends SparkBaseJob> {
    protected FileSystem fileSystem;
    protected String remoteFolder;
    protected String livyEndpoint;
    protected String livyVersion;
    protected String libJars;
    protected String username;
    protected String jarToExecute;
    protected String classToExecute;
    protected String driverMemory;
    protected String executorMemory;
    protected Integer driverCore;
    protected Integer executorCore;
    protected List<String> arguments;
    protected Map<String, String> configuration;
    protected String applicationName;
    protected Credentials credentials;
    protected Integer intervalPollingDuration;
    protected Integer maxMissingStatuses;
    protected Integer socketTimeout = 15000;
    protected Integer connectionTimeout = 15000;
    protected String userAgent = "Talend Studio";
    protected String token;
    protected String sparkPoolsName;

    public BaseBuilder<T> withAccessToken(String token) {
        this.token = token;
        return this;
    }

    public BaseBuilder<T> withSparkPools(String sparkPoolsName) {
        this.sparkPoolsName = sparkPoolsName;
        return this;
    }

    public BaseBuilder<T> withFileSystem(FileSystem fs) {
        this.fileSystem = fs;
        return this;
    }

    public BaseBuilder<T> withJarToExecute(String jarToExecute) {
        this.jarToExecute = jarToExecute;
        return this;
    }

    public BaseBuilder<T> withClassToExecute(String classToExecute) {
        this.classToExecute = classToExecute;
        return this;
    }

    public BaseBuilder<T> withLivyEndpoint(String endpoint) {
        if ((endpoint = Utils.removeLastSlash(endpoint)).endsWith("/livy")) {
            endpoint = endpoint.substring(0, endpoint.length() - 5);
        } else if (endpoint.endsWith("/livy_for_spark3")) {
            endpoint = endpoint.substring(0, endpoint.length() - 16);
        }
        this.livyEndpoint = Utils.removeLastSlash(endpoint);
        return this;
    }

    public BaseBuilder<T> withCredentials(Credentials credentials) {
        this.credentials = credentials;
        return this;
    }

    public BaseBuilder<T> withIntervalPollingDuration(Integer intervalDuration) {
        this.intervalPollingDuration = intervalDuration;
        return this;
    }

    public BaseBuilder<T> withIntervalPollingDuration(String intervalDuration) {
        this.intervalPollingDuration = Integer.parseInt(intervalDuration);
        return this;
    }

    public BaseBuilder<T> withMaxMissingStatuses(Integer maxMissingStatuses) {
        this.maxMissingStatuses = maxMissingStatuses;
        return this;
    }

    public BaseBuilder<T> withMaxMissingStatuses(String maxMissingStatuses) {
        this.maxMissingStatuses = Integer.parseInt(maxMissingStatuses);
        return this;
    }

    public BaseBuilder<T> withConnectionTimeout(String connectionTimeout) {
        this.connectionTimeout = Integer.parseInt(connectionTimeout);
        return this;
    }

    public BaseBuilder<T> withSocketTimeout(String socketTimeout) {
        this.socketTimeout = Integer.parseInt(socketTimeout);
        return this;
    }

    public BaseBuilder<T> withUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public BaseBuilder<T> withRemoteFolder(String remoteFolder) {
        this.remoteFolder = Utils.removeFirstAndLastSlash(remoteFolder);
        return this;
    }

    public BaseBuilder<T> withUsername(String username) {
        this.username = username;
        return this;
    }

    public BaseBuilder<T> withLibJars(String libJars) {
        this.libJars = libJars;
        return this;
    }

    public BaseBuilder<T> withAppName(String appName) {
        this.applicationName = appName;
        return this;
    }

    public BaseBuilder<T> withDriverMemory(String memory) {
        if (memory != null) {
            this.driverMemory = memory;
        }
        return this;
    }

    public BaseBuilder<T> withExecutorMemory(String memory) {
        if (memory != null) {
            this.executorMemory = memory;
        }
        return this;
    }

    public BaseBuilder<T> withDriverCore(String core) {
        if (core != null) {
            this.driverCore = Integer.parseInt(core);
        }
        return this;
    }

    public BaseBuilder<T> withExecutorCore(String core) {
        if (core != null) {
            this.executorCore = Integer.parseInt(core);
        }
        return this;
    }

    public BaseBuilder<T> withConf(Map<String, String> conf) {
        this.configuration = conf;
        return this;
    }

    public BaseBuilder<T> withArgs(List<String> args) {
        this.arguments = args;
        return this;
    }

    public BaseBuilder<T> withLivyVersion(String livyVersion) {
        this.livyVersion = livyVersion;
        return this;
    }

    public abstract T build();
}

