/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.jobserver;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Map;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.Job;
import org.talend.bigdata.launcher.jobserver.JobServerRequest;
import org.talend.bigdata.launcher.security.Credentials;
import org.talend.bigdata.launcher.utils.Utils;

public abstract class JobServerJob
extends Job {
    protected String mJarToExecute;
    protected String mClassToExecute;
    protected String mAppName;
    protected String mEndpoint;
    protected String mUserAgent;
    protected CloseableHttpClient httpClient;
    protected String mJobId;
    protected Map<String, String> mConf;
    protected Map<String, String> mTuningConf;
    protected Long mExitCode;
    protected Exception mException;
    private static final String OK = "OK";
    private static final String ERROR = "ERROR";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobServerJob.class);

    JobServerJob(String appName, String jarToExecute, String classToExecute, String endpoint, Credentials credentials, Map<String, String> conf, Map<String, String> tuningConf) throws URISyntaxException {
        this.mAppName = appName;
        this.mJarToExecute = jarToExecute;
        this.mClassToExecute = classToExecute;
        this.mEndpoint = endpoint;
        this.mCredentials = credentials;
        this.mConf = conf;
        this.mTuningConf = tuningConf;
        this.mUserAgent = "Apache CXF 2.7.7";
        if (this.mEndpoint == null) {
            throw new URISyntaxException("", "missing endpoint");
        }
        this.httpClient = this.createHttpClient();
    }

    private CloseableHttpClient createHttpClient() throws URISyntaxException {
        HttpRequestInterceptor logInterceptor = (request, context) -> {
            LOGGER.info("###");
            LOGGER.info(request.getRequestLine().toString());
            LOGGER.debug("");
            Arrays.stream(request.getAllHeaders()).map(Object::toString).forEach(arg_0 -> ((Logger)LOGGER).debug(arg_0));
            LOGGER.debug("");
            LOGGER.info("###");
        };
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(new AuthScope(HttpHost.create((String)new URI(this.mEndpoint).getHost())), (org.apache.http.auth.Credentials)this.mCredentials);
        return HttpClientBuilder.create().addInterceptorLast(logInterceptor).disableContentCompression().setUserAgent(this.mUserAgent).setDefaultHeaders(Arrays.asList(new BasicHeader("Accept", "*/*"), new BasicHeader("Cache-Control", "no-cache"), new BasicHeader("Pragma", "no-cache"))).setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    public void setClassToExecute(String clazz) {
        this.mClassToExecute = clazz;
    }

    public void setJarToExecute(String jar) {
        this.mJarToExecute = jar;
    }

    public void setAppName(String appName) {
        this.mAppName = appName;
    }

    public Exception getException() {
        return this.mException;
    }

    public Integer getExitCode() {
        return this.mExitCode.intValue();
    }

    private void checkResponse(JobServerRequest request, HttpResponse response) throws HttpException {
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new HttpException("Error when calling " + request.getFullEndpoint() + ": " + response.getStatusLine());
        }
    }

    private void sendJar() throws Exception {
        JobServerRequest request = JobServerRequest.sendJar(this.mEndpoint, this.mAppName, new File(this.mJarToExecute)).withHttpClient((HttpClient)this.httpClient);
        HttpResponse response = request.execute();
        this.checkResponse(request, response);
    }

    private void execute() throws Exception {
        String body = Utils.toConfString(this.mConf, this.mTuningConf);
        JobServerRequest request = JobServerRequest.run(this.mEndpoint, this.mAppName, this.mClassToExecute, body).withHttpClient((HttpClient)this.httpClient);
        HttpResponse response = request.execute();
        this.checkResponse(request, response);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(response.getEntity().getContent());
        this.mJobId = node.get("result").get("jobId").asText();
    }

    private String getResult() throws Exception {
        HttpResponse response;
        JsonNode result;
        boolean running;
        JobServerRequest request = JobServerRequest.state(this.mEndpoint, this.mAppName, this.mClassToExecute, this.mJobId);
        ObjectMapper mapper = new ObjectMapper();
        Executor executor = Executor.newInstance((HttpClient)this.httpClient).authPreemptive(request.uri.getAuthority());
        do {
            Thread.sleep(2000L);
        } while (running = "RUNNING".equals((result = mapper.readTree((response = request.executeWith(executor)).getEntity().getContent())).get("status").asText()));
        return this.parseResult(result);
    }

    private String parseResult(JsonNode node) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, ClassNotFoundException, NoSuchMethodException, SecurityException {
        String result;
        switch (result = node.get("status").asText()) {
            case "OK": {
                this.mExitCode = node.get("result").asLong();
                break;
            }
            case "ERROR": {
                this.mException = Utils.buildException((JsonNode)node.get(ERROR));
                break;
            }
            default: {
                this.mException = new IllegalStateException("invalid job status returned: " + node.get("status"));
            }
        }
        return result;
    }

    public int executeJob() throws Exception {
        String jobResult;
        this.sendJar();
        this.execute();
        switch (jobResult = this.getResult()) {
            case "OK": {
                return this.getExitCode();
            }
        }
        throw this.getException();
    }
}

