/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.CloseableHttpClient;
import org.talend.bigdata.launcher.SparkBaseJob;
import org.talend.bigdata.launcher.fs.FileSystem;
import org.talend.bigdata.launcher.livy.SparkJobRequest;
import org.talend.bigdata.launcher.security.Credentials;
import org.talend.bigdata.launcher.utils.BaseBuilder;

public class SparkJob
extends SparkBaseJob {
    protected CloseableHttpClient httpClient;
    protected String mLivyVersion;
    int returnCode;

    private SparkJob(FileSystem fs, Credentials credentials, String userAgent, String remoteFolder, String livyEndpoint, String livyVersion, String libJars, String username, String classToExecute, String jarToExecute, Map<String, String> conf, String appName, String driverMemory, String executorMemory, Integer driverCore, Integer executorCore, List<String> args, Integer pollingIntervalDuration, Integer maxMissingStatuses, int connectionTimeout, int socketTimeout) {
        this.mClassToExecute = classToExecute;
        this.mCredentials = credentials;
        this.userAgent = userAgent;
        this.mFileSystem = fs;
        this.mJarToExecute = jarToExecute;
        this.mLibjars = libJars;
        this.mLivyEndpoint = livyEndpoint;
        this.mLivyVersion = livyVersion;
        this.mRemoteFolder = remoteFolder;
        this.mUsername = username;
        this.mConf = conf;
        this.mAppName = appName;
        this.mDriverCore = driverCore;
        this.mDriverMemory = driverMemory;
        this.mExecutorCore = executorCore;
        this.mExecutorMemory = executorMemory;
        this.mArgs = args;
        this.pollingIntervalDuration = pollingIntervalDuration;
        this.maxMissingStatuses = maxMissingStatuses;
        this.returnCode = -1;
        if (this.mLivyEndpoint != null) {
            this.httpClient = this.createHttpClientWithSSL(connectionTimeout, socketTimeout);
        }
    }

    protected String createExecuteBody(ObjectMapper mapper, String remoteLibJars) throws JsonProcessingException {
        ObjectNode executeBodyObjectNode = this.createExecuteBodyObjectNode(mapper);
        if (remoteLibJars != null) {
            ArrayNode jars = mapper.createArrayNode();
            for (String jar : remoteLibJars.split(",")) {
                jars.add(jar);
            }
            executeBodyObjectNode.set("jars", (JsonNode)jars);
        }
        return mapper.writeValueAsString((Object)executeBodyObjectNode);
    }

    public int executeJob() throws Exception {
        String remoteLibJars = this.sendFiles();
        ObjectMapper mapper = new ObjectMapper();
        String body = this.createExecuteBody(mapper, remoteLibJars);
        this.jobId = this.start(mapper, body, 201, SparkJobRequest.run(this.mLivyEndpoint, body, this.mUsername, this.mCredentials.getPassword(), this.mLivyVersion).withHttpClient((HttpClient)this.httpClient));
        this.returnCode = this.waitStatus(new ObjectMapper(), SparkJobRequest.state(this.mLivyEndpoint, this.jobId, this.mLivyVersion).withHttpClient((HttpClient)this.httpClient));
        this.log = this.generateLog(new ObjectMapper(), SparkJobRequest.log(this.mLivyEndpoint, this.jobId, this.mLivyVersion).withHttpClient((HttpClient)this.httpClient));
        return this.getReturnCode();
    }

    public void cancelJob() throws Exception {
        this.cancelJob(() -> SparkJobRequest.log(this.mLivyEndpoint, this.jobId, this.mLivyVersion).withHttpClient((HttpClient)this.httpClient));
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public static class Builder
    extends BaseBuilder<SparkJob> {
        public SparkJob build() {
            return new SparkJob(this.fileSystem, this.credentials, this.userAgent, this.remoteFolder, this.livyEndpoint, this.livyVersion, this.libJars, this.username, this.classToExecute, this.jarToExecute, this.configuration, this.applicationName, this.driverMemory, this.executorMemory, this.driverCore, this.executorCore, this.arguments, this.intervalPollingDuration, this.maxMissingStatuses, this.connectionTimeout, this.socketTimeout);
        }
    }
}

