/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.launcher.livy;

import java.io.IOException;
import java.util.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.bigdata.launcher.EndpointDescriptor;

class SparkJobRequest
implements EndpointDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkJobRequest.class);
    HttpClient httpClient;
    Request request;
    String rootEndpoint;
    String apiPath;
    String username;

    private static SparkJobRequest Get(String rootEndpoint, String apiPath) {
        String fullEndpoint = rootEndpoint.endsWith("/") ? rootEndpoint + apiPath : rootEndpoint + "/" + apiPath;
        return new SparkJobRequest(Request.Get((String)fullEndpoint), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Delete(String rootEndpoint, String apiPath, String username) {
        String fullEndpoint = rootEndpoint.endsWith("/") ? rootEndpoint + apiPath : rootEndpoint + "/" + apiPath;
        return new SparkJobRequest(Request.Delete((String)fullEndpoint).addHeader((Header)new BasicHeader("X-Requested-By", username)), rootEndpoint, apiPath);
    }

    private static SparkJobRequest Post(String rootEndpoint, String apiPath, String body, String username, String password) {
        String auth = Base64.getEncoder().encodeToString((username + ":" + password).getBytes());
        String fullEndpoint = rootEndpoint.endsWith("/") ? rootEndpoint + apiPath : rootEndpoint + "/" + apiPath;
        LOGGER.debug("Full endpoint to call: {} Authorization: ", (Object)fullEndpoint, (Object)auth);
        return new SparkJobRequest(Request.Post((String)fullEndpoint).addHeader((Header)new BasicHeader("X-Requested-By", username)).addHeader("Authorization", "Basic " + auth).bodyString(body, ContentType.APPLICATION_JSON), rootEndpoint, apiPath);
    }

    public static SparkJobRequest run(String rootEndpoint, String body, String username, String password, String livyVersion) {
        return SparkJobRequest.Post(rootEndpoint, livyVersion + "/batches", body, username, password);
    }

    public static SparkJobRequest log(String rootEndpoint, Long jobId, String livyVersion) {
        System.out.println("<<<<<<<<<<LOG: endpoint = " + rootEndpoint + "/" + livyVersion + "/batches/" + jobId + "/log");
        return SparkJobRequest.Get(rootEndpoint, livyVersion + "/batches/" + jobId + "/log");
    }

    public static SparkJobRequest state(String rootEndpoint, Long jobId, String livyVersion) {
        System.out.println("<<<<<<<<<<STATE: endpoint = " + rootEndpoint + "/" + livyVersion + "/batches/" + jobId + "/state");
        return SparkJobRequest.Get(rootEndpoint, livyVersion + "/batches/" + jobId + "/state");
    }

    public static SparkJobRequest cancel(String rootEndpoint, Long jobId, String username, String livyVersion) {
        System.out.println("<<<<<<<<<<CANCEL: endpoint = " + rootEndpoint + "/" + livyVersion + "/batches/" + jobId);
        return SparkJobRequest.Delete(rootEndpoint, livyVersion + "/batches/" + jobId, username);
    }

    public SparkJobRequest withHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    private SparkJobRequest(Request request, String rootEndpoint, String apiPath) {
        this.request = request;
        this.rootEndpoint = StringUtils.removeEnd((String)rootEndpoint, (String)"/");
        this.apiPath = apiPath;
        this.username = "";
    }

    private SparkJobRequest(Request request, String rootEndpoint, String apiPath, String username) {
        this.request = request;
        this.rootEndpoint = StringUtils.removeEnd((String)rootEndpoint, (String)"/");
        this.apiPath = apiPath;
        this.username = username;
    }

    public HttpResponse execute() throws IOException {
        Executor executor = Executor.newInstance((HttpClient)this.httpClient).authPreemptive(this.rootEndpoint);
        return executor.execute(this.request).returnResponse();
    }

    public String getFullEndpoint() {
        this.rootEndpoint = StringUtils.removeEnd((String)this.rootEndpoint, (String)"/");
        return this.rootEndpoint + "/" + this.apiPath;
    }
}

