/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.common.output;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.immutables.value.Value;

public interface StreamWriter {
    @Value.Parameter
    public Dataset<Row> input();

    @Value.Default
    default public Encoder<Row> encoder() {
        return Encoders.kryo(Row.class);
    }

    @Value.Default
    default public Class<?> rowClass() {
        return Row.class;
    }

    @Value.Default
    default public Map<String, String> options() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public Optional<String> queryName() {
        return Optional.empty();
    }

    @Value.Default
    default public OutputMode outputMode() {
        return OutputMode.Append();
    }

    public Optional<Trigger> trigger();

    default public StreamingQuery start() throws TimeoutException {
        return this.writer().start();
    }

    default public DataStreamWriter<Row> writer() {
        DataStreamWriter writer = this.input().writeStream().options(this.options()).outputMode(this.outputMode());
        if (this.queryName().isPresent()) {
            writer = writer.queryName(this.queryName().get());
        }
        if (this.trigger().isPresent()) {
            writer = writer.trigger(this.trigger().get());
        }
        return writer;
    }
}

