/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.misc.tlogrow.util;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;

public class TableFormatLogger {
    String[] des_top = new String[]{".", ".", "-", "+"};
    String[] des_head = new String[]{"|=", "=|", "-", "+"};
    String[] des_bottom = new String[]{"'", "'", "-", "+"};
    String name = "";
    int nbColumns = 0;
    List<String[]> list = new ArrayList<String[]>();
    int[] colLengths = new int[this.nbColumns];

    public void setNbColumns(int nbColumns) {
        this.nbColumns = nbColumns;
        this.colLengths = new int[nbColumns];
    }

    public void addRow(String[] row) {
        for (int i = 0; i < this.nbColumns; ++i) {
            if (row[i] == null) continue;
            this.colLengths[i] = Math.max(this.colLengths[i], row[i].length());
        }
        this.list.add(row);
    }

    public void resetList() {
        this.list.clear();
    }

    public void setTableName(String name) {
        this.name = name;
    }

    public StringBuilder format() {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append((CharSequence)this.print(this.des_top));
        int totals = 0;
        for (int i2 = 0; i2 < this.colLengths.length; ++i2) {
            totals += this.colLengths[i2];
        }
        sb.append("|");
        int k = 0;
        for (k = 0; k < (totals + this.nbColumns - 1 - this.name.length()) / 2; ++k) {
            sb.append(' ');
        }
        sb.append(this.name);
        for (i = 0; i < totals + this.nbColumns - 1 - this.name.length() - k; ++i) {
            sb.append(' ');
        }
        sb.append("|\n");
        sb.append((CharSequence)this.print(this.des_head));
        for (i = 0; i < this.list.size(); ++i) {
            String[] row = this.list.get(i);
            Formatter formatter = new Formatter(new StringBuilder());
            StringBuilder sbformat = new StringBuilder();
            for (int j = 0; j < this.nbColumns; ++j) {
                int j1 = j + 1;
                sbformat.append("|%" + j1 + "$-");
                sbformat.append(this.colLengths[j]);
                sbformat.append("s");
            }
            sbformat.append("|\n");
            formatter.format(sbformat.toString(), row);
            sb.append(formatter.toString());
            if (i != 0) continue;
            sb.append((CharSequence)this.print(this.des_head));
        }
        sb.append((CharSequence)this.print(this.des_bottom));
        return sb;
    }

    private StringBuilder print(String[] fillChars) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(fillChars[0]);
        if (this.nbColumns > 1) {
            for (i = 0; i < this.colLengths[0] - fillChars[0].length() + 1; ++i) {
                sb.append(fillChars[2]);
            }
            sb.append(fillChars[3]);
        }
        for (int j = 0; j < this.nbColumns - 2; ++j) {
            for (int i2 = 0; i2 < this.colLengths[j + 1] - fillChars[3].length() + 1; ++i2) {
                sb.append(fillChars[2]);
            }
            sb.append(fillChars[3]);
        }
        for (i = 0; i < this.colLengths[this.nbColumns - 1] - fillChars[1].length() + 1; ++i) {
            sb.append(fillChars[2]);
        }
        sb.append(fillChars[1]);
        sb.append("\n");
        return sb;
    }
}

