/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.processing.fields;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.DatumWriter;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificRecordBase;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Value;
import org.talend.bigdata.common.Component;

@Value.Enclosing
public interface TWriteAvroFields {

    public static class WriteAvroFieldsException
    extends RuntimeException {
        public WriteAvroFieldsException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Value.Immutable
    public static abstract class Dataframe<T extends SpecificRecordBase>
    implements Serializable,
    Component.WithSchemaDescription {
        private transient DatumWriter<GenericRecord> datumWriter;
        private transient BinaryEncoder binaryEncoder;
        private transient ByteArrayOutputStream outputStream;
        private transient StructType outputStructType;

        public abstract T avroRecord();

        abstract Dataset<Row> inputDataset();

        @Value.Default
        public Dataset<Row> getBinaryRecordFromAvro() {
            Dataset binaryDataset = this.inputDataset().map(this::convert, Encoders.BINARY());
            Dataset select = binaryDataset.select(new Column[]{binaryDataset.col("value").as("serializedValue")});
            StructField byteBufferField = new StructField("serializedValue", DataTypes.BinaryType, true, Metadata.empty());
            if (this.outputStructType == null) {
                this.outputStructType = new StructType(new StructField[]{byteBufferField});
            }
            return select;
        }

        private byte[] convert(Row value) {
            if (this.datumWriter == null) {
                this.datumWriter = new GenericDatumWriter(this.avroRecord().getSchema());
            }
            if (this.outputStream == null) {
                this.outputStream = new ByteArrayOutputStream();
            } else {
                this.outputStream.reset();
            }
            this.binaryEncoder = EncoderFactory.get().binaryEncoder((OutputStream)this.outputStream, this.binaryEncoder);
            try {
                this.datumWriter.write((Object)this.getGenericRecord(value), (Encoder)this.binaryEncoder);
                this.binaryEncoder.flush();
                return this.outputStream.toByteArray();
            }
            catch (IOException e) {
                throw new WriteAvroFieldsException("Failed to convert row to Avro", e);
            }
        }

        private GenericRecord getGenericRecord(Row value) {
            this.avroRecord().getSchema().getFields().forEach(field -> {
                String name = field.name();
                Object fieldValue = value.getAs(name);
                Object parsedValue = this.schemaFieldDescriptions().stream().filter(fieldDescription -> !fieldDescription.name().contains(" ") ? fieldDescription.name().equals(name) : fieldDescription.name().replace(" ", "_").equals(name)).findFirst().map(fieldDescription -> fieldDescription.parseObject(fieldValue, field)).orElse(fieldValue);
                this.avroRecord().put(field.name(), parsedValue);
            });
            return this.avroRecord();
        }
    }
}

