/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.common.input;

import java.util.List;
import java.util.Optional;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.streaming.DataStreamReader;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.common.input.StreamReader;

class StreamReaderTest {
    StreamReaderTest() {
    }

    @Test
    void testEventTimeWatermarking() {
        final SparkSession spark = (SparkSession)Mockito.mock(SparkSession.class);
        DataStreamReader dataStreamReader = (DataStreamReader)Mockito.mock(DataStreamReader.class);
        Dataset ds = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)dataStreamReader.load()).thenReturn((Object)ds);
        Mockito.when((Object)dataStreamReader.options(ArgumentMatchers.anyMap())).thenReturn((Object)dataStreamReader);
        Mockito.when((Object)spark.readStream()).thenReturn((Object)dataStreamReader);
        StreamReader reader = new StreamReader(){

            public List<Component.SchemaFieldDescription> schemaFieldDescriptions() {
                return List.of();
            }

            public SparkSession sparkSession() {
                return spark;
            }

            public Optional<StreamReader.WatermarkingType> enableWatermarking() {
                return Optional.of(StreamReader.WatermarkingType.EVENT_TIME);
            }

            public Optional<String> watermarkColumn() {
                return Optional.of("event_time");
            }

            public Optional<String> watermarkDelay() {
                return Optional.of("10 minutes");
            }

            public Optional<String> format() {
                return Optional.empty();
            }
        };
        reader.load();
        ((Dataset)Mockito.verify((Object)ds)).withWatermark("event_time", "10 minutes");
    }

    @Test
    void testProcessingTimeWatermarking() {
        final SparkSession spark = (SparkSession)Mockito.mock(SparkSession.class);
        DataStreamReader dataStreamReader = (DataStreamReader)Mockito.mock(DataStreamReader.class);
        Dataset ds = (Dataset)Mockito.mock(Dataset.class);
        Mockito.when((Object)ds.withColumn(Mockito.anyString(), (Column)ArgumentMatchers.any(Column.class))).thenReturn((Object)ds);
        Mockito.when((Object)dataStreamReader.load()).thenReturn((Object)ds);
        Mockito.when((Object)dataStreamReader.options(ArgumentMatchers.anyMap())).thenReturn((Object)dataStreamReader);
        Mockito.when((Object)spark.readStream()).thenReturn((Object)dataStreamReader);
        StreamReader reader = new StreamReader(){

            public List<Component.SchemaFieldDescription> schemaFieldDescriptions() {
                return List.of();
            }

            public SparkSession sparkSession() {
                return spark;
            }

            public Optional<StreamReader.WatermarkingType> enableWatermarking() {
                return Optional.of(StreamReader.WatermarkingType.PROCESSING_TIME);
            }

            public Optional<String> watermarkColumn() {
                return Optional.empty();
            }

            public Optional<String> watermarkDelay() {
                return Optional.of("10 minutes");
            }

            public Optional<String> format() {
                return Optional.empty();
            }
        };
        reader.load();
        ((Dataset)Mockito.verify((Object)ds)).withColumn("processing_time", functions.current_timestamp());
        ((Dataset)Mockito.verify((Object)ds)).withWatermark("processing_time", "10 minutes");
    }
}

