/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.kafka;

import java.util.concurrent.TimeoutException;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.talend.bigdata.structuredstreaming.kafka.ImmutableTKafkaOutput;
import org.talend.bigdata.structuredstreaming.kafka.TKafkaConfiguration;

class TKafkaOutputTest {
    TKafkaOutputTest() {
    }

    @Test
    void writeTest() throws TimeoutException, StreamingQueryException {
        SparkSession spark = (SparkSession)Mockito.mock(SparkSession.class);
        Dataset ds = (Dataset)Mockito.mock(Dataset.class);
        DataStreamWriter dataStreamWriter = (DataStreamWriter)Mockito.mock(DataStreamWriter.class);
        TKafkaConfiguration tKafkaConfiguration = (TKafkaConfiguration)Mockito.mock(TKafkaConfiguration.class);
        StreamingQuery streamingQuery = (StreamingQuery)Mockito.mock(StreamingQuery.class);
        Mockito.when((Object)ds.map((MapFunction)ArgumentMatchers.any(MapFunction.class), (Encoder)ArgumentMatchers.any(Encoder.class))).thenReturn((Object)ds);
        Mockito.when((Object)ds.writeStream()).thenReturn((Object)dataStreamWriter);
        Mockito.when((Object)dataStreamWriter.format("kafka")).thenReturn((Object)dataStreamWriter);
        Mockito.when((Object)tKafkaConfiguration.brokerList()).thenReturn((Object)"brokerlist");
        Mockito.when((Object)dataStreamWriter.option("kafka.bootstrap.servers", "brokerlist")).thenReturn((Object)dataStreamWriter);
        Mockito.when((Object)dataStreamWriter.option("topic", "")).thenReturn((Object)dataStreamWriter);
        Mockito.when((Object)dataStreamWriter.start()).thenReturn((Object)streamingQuery);
        ImmutableTKafkaOutput.Dataframe kafkaOutput = ImmutableTKafkaOutput.Dataframe.builder().sparkSession(spark).inputDataset(ds).tKafkaConfiguration(tKafkaConfiguration).build();
        Assertions.assertNotNull((Object)kafkaOutput);
        kafkaOutput.write();
        ((DataStreamWriter)Mockito.verify((Object)dataStreamWriter)).option("kafka.bootstrap.servers", "brokerlist");
        ((DataStreamWriter)Mockito.verify((Object)dataStreamWriter)).option("topic", "");
    }
}

