/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.common.output;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.streaming.DataStreamWriter;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.Trigger;
import org.immutables.value.Value;
import org.talend.bigdata.common.output.Writer;

public interface StreamWriter
extends Writer<Row> {
    @Value.Default
    default public Map<String, String> options() {
        return Collections.emptyMap();
    }

    @Value.Default
    default public Optional<String> queryName() {
        return Optional.empty();
    }

    @Value.Default
    default public OutputMode outputMode() {
        return OutputMode.Append();
    }

    public Optional<Trigger> trigger();

    default public StreamingQuery start() throws TimeoutException {
        return this.writer().start();
    }

    default public DataStreamWriter<Row> writer() {
        return this.writer((Dataset<Row>)this.input());
    }

    default public DataStreamWriter<Row> writer(Dataset<Row> input) {
        DataStreamWriter writer = input.writeStream().options(this.options()).outputMode(this.outputMode());
        if (this.queryName().isPresent()) {
            writer = writer.queryName(this.queryName().get());
        }
        if (this.trigger().isPresent()) {
            writer = writer.trigger(this.trigger().get());
        }
        return writer;
    }
}

