/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.structuredstreaming.technical.tfixedflowstreaminput;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.immutables.value.Generated;
import org.talend.bigdata.common.Component;
import org.talend.bigdata.structuredstreaming.common.input.StreamReader;
import org.talend.bigdata.structuredstreaming.technical.tfixedflowstreaminput.TFixedFlowStreamInput;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TFixedFlowStreamInput", generator="Immutables")
@Immutable
public final class ImmutableTFixedFlowStreamInput
extends TFixedFlowStreamInput {
    private final SparkSession sparkSession;
    private final Class<Row> rowClass;
    private final Encoder<Row> encoder;
    private final JavaSparkContext context;
    private final ImmutableMap<String, String> options;
    private final ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions;
    private final StructType outputRowStruct;
    private final Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
    @Nullable
    private final StreamReader.WatermarkingType enableWatermarking;
    @Nullable
    private final String watermarkColumn;
    @Nullable
    private final String watermarkDelay;
    @Nullable
    private final String format;
    private final ImmutableList<Row> rows;
    private final int duplicateRowsBy;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableTFixedFlowStreamInput(SparkSession sparkSession) {
        this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
        this.schemaFieldDescriptions = ImmutableList.of();
        this.enableWatermarking = null;
        this.watermarkColumn = null;
        this.watermarkDelay = null;
        this.format = null;
        this.rows = ImmutableList.of();
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.duplicateRowsBy = this.initShim.duplicateRowsBy();
        this.initShim = null;
    }

    private ImmutableTFixedFlowStreamInput(Builder builder) {
        this.sparkSession = builder.sparkSession;
        this.schemaFieldDescriptions = builder.schemaFieldDescriptions.build();
        this.enableWatermarking = builder.enableWatermarking;
        this.watermarkColumn = builder.watermarkColumn;
        this.watermarkDelay = builder.watermarkDelay;
        this.format = builder.format;
        this.rows = builder.rows.build();
        if (builder.rowClass != null) {
            this.initShim.rowClass(builder.rowClass);
        }
        if (builder.encoder != null) {
            this.initShim.encoder(builder.encoder);
        }
        if (builder.optionsIsSet()) {
            this.initShim.options((ImmutableMap<String, String>)builder.options.build());
        }
        if (builder.duplicateRowsByIsSet()) {
            this.initShim.duplicateRowsBy(builder.duplicateRowsBy);
        }
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.duplicateRowsBy = this.initShim.duplicateRowsBy();
        this.initShim = null;
    }

    private ImmutableTFixedFlowStreamInput(SparkSession sparkSession, Class<Row> rowClass, Encoder<Row> encoder, ImmutableMap<String, String> options, ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions, @Nullable StreamReader.WatermarkingType enableWatermarking, @Nullable String watermarkColumn, @Nullable String watermarkDelay, @Nullable String format, ImmutableList<Row> rows, int duplicateRowsBy) {
        this.sparkSession = sparkSession;
        this.initShim.rowClass(rowClass);
        this.initShim.encoder(encoder);
        this.initShim.options(options);
        this.schemaFieldDescriptions = schemaFieldDescriptions;
        this.enableWatermarking = enableWatermarking;
        this.watermarkColumn = watermarkColumn;
        this.watermarkDelay = watermarkDelay;
        this.format = format;
        this.rows = rows;
        this.initShim.duplicateRowsBy(duplicateRowsBy);
        this.rowClass = this.initShim.rowClass();
        this.encoder = this.initShim.encoder();
        this.context = this.initShim.context();
        this.options = this.initShim.options();
        this.outputRowStruct = this.initShim.getOutputRowStruct();
        this.schemaFieldDescriptionsMap = this.initShim.getSchemaFieldDescriptionsMap();
        this.duplicateRowsBy = this.initShim.duplicateRowsBy();
        this.initShim = null;
    }

    public SparkSession sparkSession() {
        return this.sparkSession;
    }

    public Class<Row> rowClass() {
        InitShim shim = this.initShim;
        return shim != null ? shim.rowClass() : this.rowClass;
    }

    public Encoder<Row> encoder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.encoder() : this.encoder;
    }

    public JavaSparkContext context() {
        InitShim shim = this.initShim;
        return shim != null ? shim.context() : this.context;
    }

    public ImmutableMap<String, String> options() {
        InitShim shim = this.initShim;
        return shim != null ? shim.options() : this.options;
    }

    public ImmutableList<Component.SchemaFieldDescription> schemaFieldDescriptions() {
        return this.schemaFieldDescriptions;
    }

    public StructType getOutputRowStruct() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getOutputRowStruct() : this.outputRowStruct;
    }

    public Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemaFieldDescriptionsMap() : this.schemaFieldDescriptionsMap;
    }

    @Override
    public Optional<StreamReader.WatermarkingType> enableWatermarking() {
        return Optional.ofNullable(this.enableWatermarking);
    }

    @Override
    public Optional<String> watermarkColumn() {
        return Optional.ofNullable(this.watermarkColumn);
    }

    @Override
    public Optional<String> watermarkDelay() {
        return Optional.ofNullable(this.watermarkDelay);
    }

    @Override
    public Optional<String> format() {
        return Optional.ofNullable(this.format);
    }

    public ImmutableList<Row> rows() {
        return this.rows;
    }

    @Override
    public int duplicateRowsBy() {
        InitShim shim = this.initShim;
        return shim != null ? shim.duplicateRowsBy() : this.duplicateRowsBy;
    }

    public final ImmutableTFixedFlowStreamInput withSparkSession(SparkSession value) {
        if (this.sparkSession == value) {
            return this;
        }
        SparkSession newValue = Objects.requireNonNull(value, "sparkSession");
        return new ImmutableTFixedFlowStreamInput(newValue, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withRowClass(Class<Row> value) {
        if (this.rowClass == value) {
            return this;
        }
        Class<Row> newValue = Objects.requireNonNull(value, "rowClass");
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, newValue, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withEncoder(Encoder<Row> value) {
        if (this.encoder == value) {
            return this;
        }
        Encoder<Row> newValue = Objects.requireNonNull(value, "encoder");
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, newValue, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withOptions(Map<String, ? extends String> entries) {
        if (this.options == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, (ImmutableMap<String, String>)newValue, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
        if (this.schemaFieldDescriptions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, (ImmutableList<Component.SchemaFieldDescription>)newValue, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withEnableWatermarking(StreamReader.WatermarkingType value) {
        StreamReader.WatermarkingType newValue = Objects.requireNonNull(value, "enableWatermarking");
        if (this.enableWatermarking == newValue) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, newValue, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withEnableWatermarking(Optional<? extends StreamReader.WatermarkingType> optional) {
        StreamReader.WatermarkingType value = optional.orElse(null);
        if (this.enableWatermarking == value) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, value, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withWatermarkColumn(String value) {
        String newValue = Objects.requireNonNull(value, "watermarkColumn");
        if (Objects.equals(this.watermarkColumn, newValue)) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, newValue, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withWatermarkColumn(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.watermarkColumn, value)) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, value, this.watermarkDelay, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withWatermarkDelay(String value) {
        String newValue = Objects.requireNonNull(value, "watermarkDelay");
        if (Objects.equals(this.watermarkDelay, newValue)) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, newValue, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withWatermarkDelay(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.watermarkDelay, value)) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, value, this.format, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withFormat(String value) {
        String newValue = Objects.requireNonNull(value, "format");
        if (Objects.equals(this.format, newValue)) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, newValue, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withFormat(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.format, value)) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, value, this.rows, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withRows(Row ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, (ImmutableList<Row>)newValue, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withRows(Iterable<? extends Row> elements) {
        if (this.rows == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, (ImmutableList<Row>)newValue, this.duplicateRowsBy);
    }

    public final ImmutableTFixedFlowStreamInput withDuplicateRowsBy(int value) {
        if (this.duplicateRowsBy == value) {
            return this;
        }
        return new ImmutableTFixedFlowStreamInput(this.sparkSession, this.rowClass, this.encoder, this.options, this.schemaFieldDescriptions, this.enableWatermarking, this.watermarkColumn, this.watermarkDelay, this.format, this.rows, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTFixedFlowStreamInput && this.equalTo(0, (ImmutableTFixedFlowStreamInput)another);
    }

    private boolean equalTo(int synthetic, ImmutableTFixedFlowStreamInput another) {
        return this.sparkSession.equals(another.sparkSession) && this.rowClass.equals(another.rowClass) && this.encoder.equals(another.encoder) && this.context.equals(another.context) && this.options.equals(another.options) && this.schemaFieldDescriptions.equals(another.schemaFieldDescriptions) && this.outputRowStruct.equals((Object)another.outputRowStruct) && this.schemaFieldDescriptionsMap.equals(another.schemaFieldDescriptionsMap) && Objects.equals((Object)this.enableWatermarking, (Object)another.enableWatermarking) && Objects.equals(this.watermarkColumn, another.watermarkColumn) && Objects.equals(this.watermarkDelay, another.watermarkDelay) && Objects.equals(this.format, another.format) && this.rows.equals(another.rows) && this.duplicateRowsBy == another.duplicateRowsBy;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.sparkSession.hashCode();
        h += (h << 5) + this.rowClass.hashCode();
        h += (h << 5) + this.encoder.hashCode();
        h += (h << 5) + this.context.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.schemaFieldDescriptions.hashCode();
        h += (h << 5) + this.outputRowStruct.hashCode();
        h += (h << 5) + this.schemaFieldDescriptionsMap.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.enableWatermarking);
        h += (h << 5) + Objects.hashCode(this.watermarkColumn);
        h += (h << 5) + Objects.hashCode(this.watermarkDelay);
        h += (h << 5) + Objects.hashCode(this.format);
        h += (h << 5) + this.rows.hashCode();
        h += (h << 5) + this.duplicateRowsBy;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TFixedFlowStreamInput").omitNullValues().add("sparkSession", (Object)this.sparkSession).add("rowClass", this.rowClass).add("encoder", this.encoder).add("context", (Object)this.context).add("options", this.options).add("schemaFieldDescriptions", this.schemaFieldDescriptions).add("outputRowStruct", (Object)this.outputRowStruct).add("schemaFieldDescriptionsMap", this.schemaFieldDescriptionsMap).add("enableWatermarking", (Object)this.enableWatermarking).add("watermarkColumn", (Object)this.watermarkColumn).add("watermarkDelay", (Object)this.watermarkDelay).add("format", (Object)this.format).add("rows", this.rows).add("duplicateRowsBy", this.duplicateRowsBy).toString();
    }

    public static ImmutableTFixedFlowStreamInput of(SparkSession sparkSession) {
        return new ImmutableTFixedFlowStreamInput(sparkSession);
    }

    public static ImmutableTFixedFlowStreamInput copyOf(TFixedFlowStreamInput instance) {
        if (instance instanceof ImmutableTFixedFlowStreamInput) {
            return (ImmutableTFixedFlowStreamInput)instance;
        }
        return ImmutableTFixedFlowStreamInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TFixedFlowStreamInput", generator="Immutables")
    private final class InitShim {
        private byte rowClassBuildStage = 0;
        private Class<Row> rowClass;
        private byte encoderBuildStage = 0;
        private Encoder<Row> encoder;
        private byte contextBuildStage = 0;
        private JavaSparkContext context;
        private byte optionsBuildStage = 0;
        private ImmutableMap<String, String> options;
        private byte outputRowStructBuildStage = 0;
        private StructType outputRowStruct;
        private byte schemaFieldDescriptionsMapBuildStage = 0;
        private Map<String, Component.SchemaFieldDescription> schemaFieldDescriptionsMap;
        private byte duplicateRowsByBuildStage = 0;
        private int duplicateRowsBy;

        private InitShim() {
        }

        Class<Row> rowClass() {
            if (this.rowClassBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rowClassBuildStage == 0) {
                this.rowClassBuildStage = (byte)-1;
                this.rowClass = Objects.requireNonNull(ImmutableTFixedFlowStreamInput.super.rowClass(), "rowClass");
                this.rowClassBuildStage = 1;
            }
            return this.rowClass;
        }

        void rowClass(Class<Row> rowClass) {
            this.rowClass = rowClass;
            this.rowClassBuildStage = 1;
        }

        Encoder<Row> encoder() {
            if (this.encoderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.encoderBuildStage == 0) {
                this.encoderBuildStage = (byte)-1;
                this.encoder = Objects.requireNonNull(ImmutableTFixedFlowStreamInput.super.encoder(), "encoder");
                this.encoderBuildStage = 1;
            }
            return this.encoder;
        }

        void encoder(Encoder<Row> encoder) {
            this.encoder = encoder;
            this.encoderBuildStage = 1;
        }

        JavaSparkContext context() {
            if (this.contextBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.contextBuildStage == 0) {
                this.contextBuildStage = (byte)-1;
                this.context = Objects.requireNonNull(ImmutableTFixedFlowStreamInput.super.context(), "context");
                this.contextBuildStage = 1;
            }
            return this.context;
        }

        ImmutableMap<String, String> options() {
            if (this.optionsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.optionsBuildStage == 0) {
                this.optionsBuildStage = (byte)-1;
                this.options = ImmutableMap.copyOf((Map)ImmutableTFixedFlowStreamInput.super.options());
                this.optionsBuildStage = 1;
            }
            return this.options;
        }

        void options(ImmutableMap<String, String> options) {
            this.options = options;
            this.optionsBuildStage = 1;
        }

        StructType getOutputRowStruct() {
            if (this.outputRowStructBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.outputRowStructBuildStage == 0) {
                this.outputRowStructBuildStage = (byte)-1;
                this.outputRowStruct = Objects.requireNonNull(ImmutableTFixedFlowStreamInput.super.getOutputRowStruct(), "outputRowStruct");
                this.outputRowStructBuildStage = 1;
            }
            return this.outputRowStruct;
        }

        Map<String, Component.SchemaFieldDescription> getSchemaFieldDescriptionsMap() {
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemaFieldDescriptionsMapBuildStage == 0) {
                this.schemaFieldDescriptionsMapBuildStage = (byte)-1;
                this.schemaFieldDescriptionsMap = Objects.requireNonNull(ImmutableTFixedFlowStreamInput.super.getSchemaFieldDescriptionsMap(), "schemaFieldDescriptionsMap");
                this.schemaFieldDescriptionsMapBuildStage = 1;
            }
            return this.schemaFieldDescriptionsMap;
        }

        int duplicateRowsBy() {
            if (this.duplicateRowsByBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.duplicateRowsByBuildStage == 0) {
                this.duplicateRowsByBuildStage = (byte)-1;
                this.duplicateRowsBy = ImmutableTFixedFlowStreamInput.super.duplicateRowsBy();
                this.duplicateRowsByBuildStage = 1;
            }
            return this.duplicateRowsBy;
        }

        void duplicateRowsBy(int duplicateRowsBy) {
            this.duplicateRowsBy = duplicateRowsBy;
            this.duplicateRowsByBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.rowClassBuildStage == -1) {
                attributes.add("rowClass");
            }
            if (this.encoderBuildStage == -1) {
                attributes.add("encoder");
            }
            if (this.contextBuildStage == -1) {
                attributes.add("context");
            }
            if (this.optionsBuildStage == -1) {
                attributes.add("options");
            }
            if (this.outputRowStructBuildStage == -1) {
                attributes.add("outputRowStruct");
            }
            if (this.schemaFieldDescriptionsMapBuildStage == -1) {
                attributes.add("schemaFieldDescriptionsMap");
            }
            if (this.duplicateRowsByBuildStage == -1) {
                attributes.add("duplicateRowsBy");
            }
            return "Cannot build TFixedFlowStreamInput, attribute initializers form cycle " + attributes;
        }
    }

    @Generated(from="TFixedFlowStreamInput", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_SPARK_SESSION = 1L;
        private static final long OPT_BIT_OPTIONS = 1L;
        private static final long OPT_BIT_DUPLICATE_ROWS_BY = 2L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private SparkSession sparkSession;
        @Nullable
        private Class<Row> rowClass;
        @Nullable
        private Encoder<Row> encoder;
        private ImmutableMap.Builder<String, String> options = ImmutableMap.builder();
        private ImmutableList.Builder<Component.SchemaFieldDescription> schemaFieldDescriptions = ImmutableList.builder();
        @Nullable
        private StreamReader.WatermarkingType enableWatermarking;
        @Nullable
        private String watermarkColumn;
        @Nullable
        private String watermarkDelay;
        @Nullable
        private String format;
        private ImmutableList.Builder<Row> rows = ImmutableList.builder();
        private int duplicateRowsBy;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Component.WithSchemaDescription instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StreamReader instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TFixedFlowStreamInput instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<StreamReader.WatermarkingType> enableWatermarkingOptional;
            Optional<String> formatOptional;
            Optional<String> watermarkColumnOptional;
            Optional<String> watermarkDelayOptional;
            Component.WithSchemaDescription instance;
            long bits = 0L;
            if (object instanceof Component.WithSchemaDescription) {
                instance = (Component.WithSchemaDescription)object;
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
            }
            if (object instanceof StreamReader) {
                instance = (StreamReader)object;
                if ((bits & 1L) == 0L) {
                    watermarkDelayOptional = instance.watermarkDelay();
                    if (watermarkDelayOptional.isPresent()) {
                        this.watermarkDelay(watermarkDelayOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    watermarkColumnOptional = instance.watermarkColumn();
                    if (watermarkColumnOptional.isPresent()) {
                        this.watermarkColumn(watermarkColumnOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    formatOptional = instance.format();
                    if (formatOptional.isPresent()) {
                        this.format(formatOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    enableWatermarkingOptional = instance.enableWatermarking();
                    if (enableWatermarkingOptional.isPresent()) {
                        this.enableWatermarking(enableWatermarkingOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
            }
            if (object instanceof TFixedFlowStreamInput) {
                instance = (TFixedFlowStreamInput)object;
                this.rowClass(instance.rowClass());
                this.duplicateRowsBy(instance.duplicateRowsBy());
                if ((bits & 1L) == 0L) {
                    watermarkDelayOptional = instance.watermarkDelay();
                    if (watermarkDelayOptional.isPresent()) {
                        this.watermarkDelay(watermarkDelayOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.sparkSession(instance.sparkSession());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    watermarkColumnOptional = instance.watermarkColumn();
                    if (watermarkColumnOptional.isPresent()) {
                        this.watermarkColumn(watermarkColumnOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.putAllOptions(instance.options());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    formatOptional = instance.format();
                    if (formatOptional.isPresent()) {
                        this.format(formatOptional);
                    }
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    enableWatermarkingOptional = instance.enableWatermarking();
                    if (enableWatermarkingOptional.isPresent()) {
                        this.enableWatermarking(enableWatermarkingOptional);
                    }
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.addAllSchemaFieldDescriptions(instance.schemaFieldDescriptions());
                    bits |= 0x40L;
                }
                this.addAllRows(instance.rows());
                this.encoder((Encoder<Row>)instance.encoder());
            }
        }

        @CanIgnoreReturnValue
        public final Builder sparkSession(SparkSession sparkSession) {
            this.sparkSession = Objects.requireNonNull(sparkSession, "sparkSession");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rowClass(Class<Row> rowClass) {
            this.rowClass = Objects.requireNonNull(rowClass, "rowClass");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder encoder(Encoder<Row> encoder) {
            this.encoder = Objects.requireNonNull(encoder, "encoder");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(String key, String value) {
            this.options.put((Object)key, (Object)value);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putOptions(Map.Entry<String, ? extends String> entry) {
            this.options.put(entry);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder options(Map<String, ? extends String> entries) {
            this.options = ImmutableMap.builder();
            this.optBits |= 1L;
            return this.putAllOptions(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllOptions(Map<String, ? extends String> entries) {
            this.options.putAll(entries);
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription element) {
            this.schemaFieldDescriptions.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSchemaFieldDescriptions(Component.SchemaFieldDescription ... elements) {
            this.schemaFieldDescriptions.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder schemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions = ImmutableList.builder();
            return this.addAllSchemaFieldDescriptions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSchemaFieldDescriptions(Iterable<? extends Component.SchemaFieldDescription> elements) {
            this.schemaFieldDescriptions.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableWatermarking(StreamReader.WatermarkingType enableWatermarking) {
            this.enableWatermarking = Objects.requireNonNull(enableWatermarking, "enableWatermarking");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder enableWatermarking(Optional<? extends StreamReader.WatermarkingType> enableWatermarking) {
            this.enableWatermarking = enableWatermarking.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkColumn(String watermarkColumn) {
            this.watermarkColumn = Objects.requireNonNull(watermarkColumn, "watermarkColumn");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkColumn(Optional<String> watermarkColumn) {
            this.watermarkColumn = watermarkColumn.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkDelay(String watermarkDelay) {
            this.watermarkDelay = Objects.requireNonNull(watermarkDelay, "watermarkDelay");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder watermarkDelay(Optional<String> watermarkDelay) {
            this.watermarkDelay = watermarkDelay.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(String format) {
            this.format = Objects.requireNonNull(format, "format");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder format(Optional<String> format) {
            this.format = format.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRows(Row element) {
            this.rows.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRows(Row ... elements) {
            this.rows.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rows(Iterable<? extends Row> elements) {
            this.rows = ImmutableList.builder();
            return this.addAllRows(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRows(Iterable<? extends Row> elements) {
            this.rows.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder duplicateRowsBy(int duplicateRowsBy) {
            this.duplicateRowsBy = duplicateRowsBy;
            this.optBits |= 2L;
            return this;
        }

        public ImmutableTFixedFlowStreamInput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTFixedFlowStreamInput(this);
        }

        private boolean optionsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean duplicateRowsByIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("sparkSession");
            }
            return "Cannot build TFixedFlowStreamInput, some of required attributes are not set " + attributes;
        }
    }
}

