/*
 * Decompiled with CFR 0.152.
 */
package org.talend.bigdata.tmap;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.sql.Dataset;
import org.talend.bigdata.tmap.TMapInput;
import org.talend.bigdata.tmap.TMapOutput;
import org.talend.bigdata.tmap.Transformation;
import org.talend.bigdata.tmap.joins.FirstJoin;
import org.talend.bigdata.tmap.joins.Join;
import org.talend.bigdata.tmap.joins.LastJoin;
import org.talend.bigdata.tmap.joins.SingleJoin;
import org.talend.bigdata.tmap.joins.TemporaryJoin;
import scala.Tuple2;

public class TMapDataset {
    private List<TMapInput> inputs;
    private List<TMapOutput> outputs = new ArrayList<TMapOutput>();
    private List<Transformation> transformations;
    private List<Join> joins;

    public TMapDataset(List<TMapInput> inputs, List<TMapOutput> outputs, List<Transformation> transformations, List<Join> joins) {
        this.inputs = inputs;
        this.outputs = outputs;
        this.transformations = transformations;
        this.joins = joins;
    }

    public TMapInput getInput(String name) {
        return this.inputs.stream().filter(input -> name.equals(input.getName())).findAny().orElse(null);
    }

    public TMapDataset addOutput(TMapOutput output) {
        this.outputs.add(output);
        return this;
    }

    private TMapOutput getOutput(String from, String to) {
        Optional<TMapOutput> output = this.outputs.stream().filter(out -> to.equals(out.getName())).findAny();
        Transformation transformation = this.getTransformation(from, to);
        if (output.isPresent() && transformation != null) {
            TMapInput input = this.getInput(from);
            output.get().setOutputDS(input.getInputDS(to).flatMap((FlatMapFunction)transformation, transformation.getEncoder()));
            return output.get();
        }
        return null;
    }

    private Transformation getTransformation(String from, String to) {
        return this.transformations.stream().filter(t -> from.equals(t.getDatasetFrom()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    public TMapOutput getOutput(String to) {
        Optional<TMapOutput> output = this.outputs.stream().filter(out -> to.equals(out.getName())).findAny();
        if (output.isPresent()) {
            if (output.get().getRelatedInputs().isEmpty()) {
                return output.get();
            }
            if (output.get().getRelatedInputs().size() == 1) {
                return this.getOutput(output.get().getRelatedInput(), to);
            }
            if (output.get().getRelatedInputs().size() == 2) {
                List<String> inputOperations = output.get().getRelatedInputs();
                Tuple2 firstTuple = new Tuple2((Object)inputOperations.get(0), (Object)inputOperations.get(1));
                output.get().setOutputDS(this.makeSingleJoin((Tuple2<String, String>)firstTuple, to));
                return output.get();
            }
            List<String> inputOperations = output.get().getRelatedInputs();
            Tuple2 firstTuple = new Tuple2((Object)inputOperations.get(0), (Object)inputOperations.get(1));
            Dataset joinedDataset = this.makeFirstJoin((Tuple2<String, String>)firstTuple, to);
            if (joinedDataset != null) {
                List<TemporaryJoin> temporaryJoins = this.getTemporaryJoins(output.get().getName());
                for (TemporaryJoin tempJoin : temporaryJoins) {
                    joinedDataset = this.makeTemporaryJoin(joinedDataset, tempJoin, output.get().getName());
                }
                String lastInputName = inputOperations.get(inputOperations.size() - 1);
                output.get().setOutputDS(this.makeLastJoin(joinedDataset, lastInputName, output.get()));
                return output.get();
            }
        }
        return null;
    }

    private Dataset makeFirstJoin(Tuple2<String, String> firstTuple, String to) {
        FirstJoin firstJoin = this.getFirstJoin(firstTuple, to);
        if (firstJoin != null) {
            TMapInput inputLeft = this.getInput((String)firstTuple._1);
            TMapInput inputRight = this.getInput((String)firstTuple._2);
            Dataset datasetLeft = this.renameColumns(inputLeft.getInputDS(to), inputLeft.getName());
            Dataset datasetRight = this.renameColumns(inputRight.getInputDS(to), inputRight.getName());
            return datasetLeft.join(datasetRight, firstJoin.getCondition(), firstJoin.getJoinType());
        }
        return null;
    }

    private FirstJoin getFirstJoin(Tuple2<String, String> froms, String to) {
        List firstJoins = this.joins.stream().filter(FirstJoin.class::isInstance).map(FirstJoin.class::cast).collect(Collectors.toList());
        return firstJoins.stream().filter(t -> ((String)froms._1).equals(t.getDatasetFromA()) && ((String)froms._2).equals(t.getDatasetFromB()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private Dataset makeSingleJoin(Tuple2<String, String> firstTuple, String to) {
        SingleJoin singleJoin = this.getSingleJoin(firstTuple, to);
        if (singleJoin != null) {
            TMapInput inputA = this.getInput((String)firstTuple._1);
            TMapInput inputB = this.getInput((String)firstTuple._2);
            Dataset datasetA = this.renameColumns(inputA.getInputDS(to), inputA.getName());
            Dataset datasetB = this.renameColumns(inputB.getInputDS(to), inputB.getName());
            Dataset result = datasetA.join(datasetB, singleJoin.getCondition(), singleJoin.getJoinType());
            return result.toDF().flatMap((FlatMapFunction)singleJoin, singleJoin.getEncoder());
        }
        return null;
    }

    private SingleJoin getSingleJoin(Tuple2<String, String> froms, String to) {
        List singleJoins = this.joins.stream().filter(SingleJoin.class::isInstance).map(SingleJoin.class::cast).collect(Collectors.toList());
        return singleJoins.stream().filter(t -> ((String)froms._1).equals(t.getDatasetFromA()) && ((String)froms._2).equals(t.getDatasetFromB()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private Dataset makeTemporaryJoin(Dataset joinedDataset, TemporaryJoin tempJoin, String to) {
        TMapInput rightSide = this.getInput(tempJoin.getDatasetFrom());
        Dataset rightDataset = this.renameColumns(rightSide.getInputDS(to), rightSide.getName());
        return joinedDataset.join(rightDataset, tempJoin.getCondition(), tempJoin.getJoinType());
    }

    private List<TemporaryJoin> getTemporaryJoins(String to) {
        return this.joins.stream().filter(TemporaryJoin.class::isInstance).map(TemporaryJoin.class::cast).filter(t -> to.equals(t.getDatasetTo())).collect(Collectors.toList());
    }

    private Dataset makeLastJoin(Dataset joinedDataset, String lastInputName, TMapOutput output) {
        LastJoin lastJoin = this.getLastJoin(lastInputName, output.getName());
        if (lastJoin != null) {
            TMapInput lastInput = this.getInput(lastInputName);
            Dataset lastDataset = this.renameColumns(lastInput.getInputDS(output.getName()), lastInput.getName());
            Dataset result = joinedDataset.join(lastDataset, lastJoin.getCondition(), lastJoin.getJoinType());
            return result.toDF().flatMap((FlatMapFunction)lastJoin, lastJoin.getEncoder());
        }
        return null;
    }

    private LastJoin getLastJoin(String from, String to) {
        List lastJoins = this.joins.stream().filter(LastJoin.class::isInstance).map(LastJoin.class::cast).collect(Collectors.toList());
        return lastJoins.stream().filter(t -> from.equals(t.getDatasetFrom()) && to.equals(t.getDatasetTo())).findFirst().orElse(null);
    }

    private Dataset renameColumns(Dataset ds, String prefix) {
        for (String colName : ds.columns()) {
            ds = ds.withColumnRenamed(colName, prefix + "_" + colName);
        }
        return ds;
    }

    public static class Builder {
        private List<TMapInput> inputs = new ArrayList<TMapInput>();
        private List<TMapOutput> outputs = new ArrayList<TMapOutput>();
        private List<Transformation> transformations = new ArrayList<Transformation>();
        private List<Join> joins = new ArrayList<Join>();

        public Builder addInput(TMapInput input) {
            this.inputs.add(input);
            return this;
        }

        public Builder addTransformation(Transformation transformation) {
            this.transformations.add(transformation);
            return this;
        }

        public Builder addJoin(Join join) {
            this.joins.add(join);
            return this;
        }

        public TMapDataset build() {
            return new TMapDataset(this.inputs, this.outputs, this.transformations, this.joins);
        }
    }
}

