/*
 * Decompiled with CFR 0.152.
 */
package org.talend.commandline.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.Socket;
import org.talend.commandline.client.CommandLineJavaCLientException;
import org.talend.commandline.client.CommandLineJavaServerException;
import org.talend.commandline.client.ICommandLineConstants;

public class CommandLineAbstractClient {
    private Socket socket;
    protected InputStream inputStream;
    protected OutputStream outputStream;
    protected String hostname;
    protected int port;
    protected PrintWriter printWriter;

    public CommandLineAbstractClient(String hostname) {
        this(hostname, ICommandLineConstants.SERVER_PORT_ARG_DEFAULT_INTEGER);
    }

    public CommandLineAbstractClient(int port) {
        this("localhost", port);
    }

    public CommandLineAbstractClient() {
        this("localhost", ICommandLineConstants.SERVER_PORT_ARG_DEFAULT_INTEGER);
    }

    public CommandLineAbstractClient(String hostname, Integer port) {
        this.hostname = hostname;
        this.port = port;
    }

    public void connect() throws IOException, CommandLineJavaCLientException, CommandLineJavaServerException {
        this.socket = new Socket(this.hostname, this.port);
        this.inputStream = new BufferedInputStream(this.socket.getInputStream());
        this.outputStream = new BufferedOutputStream(this.socket.getOutputStream());
        this.printWriter = new PrintWriter((Writer)new OutputStreamWriter(this.outputStream, "utf-8"), true);
    }

    public void disconnect() throws IOException {
        if (this.socket != null) {
            this.socket.close();
        }
    }

    protected void sendCommand(String commandString) {
        this.printWriter.println(commandString);
        this.printWriter.flush();
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + " on " + this.hostname + ":" + this.port;
    }
}

