/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MultiMapHelper {
    private MultiMapHelper() {
    }

    public static <KeyT, ValT> boolean addUniqueObjectToListMap(KeyT key, ValT value, Map<KeyT, List<ValT>> map) {
        List<ValT> obj = map.get(key);
        if (obj == null) {
            ArrayList<ValT> list = new ArrayList<ValT>();
            list.add(value);
            return map.put(key, list) == null;
        }
        List<ValT> coll = obj;
        if (coll.contains(value)) {
            return true;
        }
        coll.add(value);
        return true;
    }

    public static boolean addUniqueComparableToListMap(Object key, Comparable<Object> value, Map<Object, List<Comparable<Object>>> map) {
        List<Comparable<Object>> obj = map.get(key);
        if (obj == null) {
            ArrayList<Comparable<Object>> list = new ArrayList<Comparable<Object>>();
            list.add(value);
            return map.put(key, list) == null;
        }
        List<Comparable<Object>> coll = obj;
        int idx = 0;
        for (Comparable<Object> element : coll) {
            if (value == element || value.compareTo(element) == 0) {
                return true;
            }
            if (value.compareTo(element) > 0) continue;
        }
        coll.add(idx, value);
        return true;
    }

    public static boolean addUniqueObjectToCollectionMap(Object key, Object value, Map<Object, Set<Object>> map) {
        Set<Object> obj = map.get(key);
        if (obj == null) {
            HashSet<Object> list = new HashSet<Object>();
            list.add(value);
            return map.put(key, list) == null;
        }
        Set<Object> coll = obj;
        coll.add(value);
        return true;
    }

    public static <ValT> boolean isContainedInListMap(ValT object, Map<Object, Collection<ValT>> map) {
        Collection<Collection<ValT>> values = map.values();
        for (Collection<ValT> list : values) {
            if (list == null || !list.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static <KeyT, ValT> boolean removeObjectFromCollectionMap(KeyT key, ValT toBeRemoved, Map<KeyT, Collection<ValT>> map) {
        Collection<ValT> obj = map.get(key);
        if (obj == null) {
            return false;
        }
        Collection<ValT> coll = obj;
        return coll.remove(toBeRemoved);
    }

    public static <KeyT, ValT> boolean removeAndCleanFromCollectionMap(KeyT key, ValT toBeRemoved, Map<KeyT, Collection<ValT>> map) {
        Collection<ValT> obj = map.get(key);
        if (obj == null) {
            return false;
        }
        Collection<ValT> coll = obj;
        boolean ret = coll.remove(toBeRemoved);
        if (coll.isEmpty()) {
            map.remove(key);
        }
        return ret;
    }
}

