/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.network;

import java.net.ServerSocket;
import java.util.Collections;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreePortFinder {
    private static Logger log = LoggerFactory.getLogger(FreePortFinder.class);
    private static Random random = new Random(System.currentTimeMillis());
    private static Object[] randomLock = new Object[0];
    public static Set<String> busyPorts = Collections.synchronizedSet(new HashSet());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPortFree(int port) {
        String freePort = String.valueOf(port);
        boolean isBusyPort = true;
        Set<String> set = busyPorts;
        synchronized (set) {
            isBusyPort = busyPorts.contains(freePort);
            ServerSocket serverSocket = null;
            if (!isBusyPort) {
                try {
                    serverSocket = new ServerSocket(port);
                    isBusyPort = false;
                }
                catch (Throwable e) {
                    isBusyPort = true;
                    log.debug(e.getMessage());
                }
                finally {
                    try {
                        serverSocket.close();
                        busyPorts.add(freePort);
                    }
                    catch (Throwable e) {
                        log.debug(e.getMessage());
                    }
                }
            }
        }
        return !isBusyPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePort(int port) {
        boolean containsPort = false;
        String usingPort = String.valueOf(port);
        Set<String> set = busyPorts;
        synchronized (set) {
            containsPort = busyPorts.contains(usingPort);
            if (containsPort) {
                busyPorts.remove(usingPort);
            }
        }
    }

    protected ServerSocket openServerSocket(int port) {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(port);
        }
        catch (Throwable e) {
            log.debug(e.getMessage());
        }
        return serverSocket;
    }

    public int searchFreePort(int portRangeBound1, int portRangeBound2) {
        return this.opensServerSocketFromRangePort(portRangeBound1, portRangeBound2, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public int opensServerSocketFromRangePort(int portRangeBound1, int portRangeBound2, boolean randomizeIndexStart) {
        int portBoundMin = portRangeBound1 < portRangeBound2 ? portRangeBound1 : portRangeBound2;
        int portBoundMax = portRangeBound1 < portRangeBound2 ? portRangeBound2 : portRangeBound1;
        int increment = 0;
        if (!randomizeIndexStart) return -1;
        int maxRandomBound = (int)((double)portBoundMax - (double)portBoundMin) * 3 / 4;
        if (maxRandomBound < 0) return -1;
        if (maxRandomBound == 0) {
            increment = 0;
        } else {
            Object[] objectArray = randomLock;
            // MONITORENTER : randomLock
            increment = random.nextInt(maxRandomBound);
            // MONITOREXIT : objectArray
        }
        int portStart = portBoundMin + increment;
        boolean isFirstLoop = true;
        boolean isFirstPass = true;
        int port = portStart;
        while (true) {
            if (port > portBoundMax) {
                port = portBoundMin;
            }
            if (!isFirstLoop && port == portStart) {
                if (!isFirstPass) return -1;
                isFirstPass = false;
            }
            if (this.isPortFree(port)) {
                return port;
            }
            isFirstLoop = false;
            ++port;
        }
    }

    public static void main(String[] args) {
        FreePortFinder freePortFinder = new FreePortFinder();
        System.out.println(freePortFinder.searchFreePort(10, 20));
    }
}

