/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.network;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;

public class ServerSocketFreePortOpener {
    private static Random random = new Random(System.currentTimeMillis());

    public ServerSocket openServerSocket(int port) throws IOException {
        ServerSocket serverSocket = new ServerSocket(port);
        return serverSocket;
    }

    public ServerSocket openServerSocketFromRangePort(int portRangeBound1, int portRangeBound2) {
        return this.openServerSocketFromRangePort(portRangeBound1, portRangeBound2, true);
    }

    public ServerSocket openServerSocketFromRangePort(int portRangeBound1, int portRangeBound2, boolean randomizeIndexStart) {
        int maxRandomBound;
        int portBoundMin = portRangeBound1 < portRangeBound2 ? portRangeBound1 : portRangeBound2;
        int portBoundMax = portRangeBound1 < portRangeBound2 ? portRangeBound2 : portRangeBound1;
        int increment = 0;
        if (randomizeIndexStart && (maxRandomBound = (int)((double)portBoundMax - (double)portBoundMin) * 3 / 4) >= 0) {
            increment = maxRandomBound == 0 ? 0 : random.nextInt(maxRandomBound);
            int portStart = portBoundMin + increment;
            boolean isFirstLoop = true;
            boolean isFirstPass = true;
            int port = portStart;
            while (true) {
                if (port > portBoundMax) {
                    port = portBoundMin;
                }
                if (!isFirstLoop && port == portStart) {
                    if (!isFirstPass) break;
                    isFirstPass = false;
                }
                try {
                    ServerSocket openedServerSocket = this.openServerSocket(port);
                    return openedServerSocket;
                }
                catch (IOException iOException) {
                    isFirstLoop = false;
                    ++port;
                    continue;
                }
                break;
            }
        }
        return null;
    }

    public static void main(String[] args) {
        ServerSocketFreePortOpener serverSocketFreePortOpener = new ServerSocketFreePortOpener();
        System.out.println(serverSocketFreePortOpener.openServerSocketFromRangePort(10, 20));
    }
}

