/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.thread;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.utils.thread.ThreadUtils;

public abstract class TimeoutOperationHandler<R> {
    private static Logger log = LoggerFactory.getLogger(TimeoutOperationHandler.class);
    private R result;
    private boolean timeoutReached;
    private String labelOperation;
    private long timeout;
    private Throwable operationError;

    public TimeoutOperationHandler(long timeout) {
        this.timeout = timeout;
    }

    public TimeoutOperationHandler(long timeout, String labelOperation) {
        this.timeout = timeout;
        this.labelOperation = labelOperation;
    }

    public void start() {
        this.internalStart();
    }

    protected void internalStart() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    TimeoutOperationHandler.this.result = TimeoutOperationHandler.this.internalRun();
                }
                catch (Throwable t) {
                    log.error(t.getMessage(), t);
                    TimeoutOperationHandler.this.operationError = t;
                }
                finally {
                    TimeoutOperationHandler.this.finalizeOperation();
                }
            }
        };
        Thread thread = null;
        thread = this.labelOperation != null ? new Thread(runnable, this.labelOperation) : new Thread(runnable);
        thread.start();
        long timeStart = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - timeStart > this.timeout) {
                this.timeoutReached = true;
            }
            if (this.timeoutReached || !thread.isAlive()) break;
            ThreadUtils.waitTimeBool(50L);
        }
    }

    protected R internalRun() {
        return this.run();
    }

    public boolean hasValidResultOperation(R result) {
        return result != null;
    }

    public abstract R run();

    public R getResult() {
        return this.result;
    }

    public Throwable getOperationError() {
        return this.operationError;
    }

    public void finalizeOperation() {
    }

    public void setLabelOperation(String labelOperation) {
        this.labelOperation = labelOperation;
    }
}

