/*
 * Decompiled with CFR 0.152.
 */
package org.talend.utils.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

public class TimeoutTask<R> {
    private AtomicInteger counter = new AtomicInteger();
    private ExecutorService threadPool;

    public TimeoutTask() {
        this(null);
    }

    public TimeoutTask(final String taskName) {
        if (taskName != null) {
            ThreadFactory threadFactory = new ThreadFactory(){
                ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

                @Override
                public Thread newThread(Runnable r) {
                    Thread newThread = this.defaultThreadFactory.newThread(r);
                    String threadName = TimeoutTask.this.getClass().getSimpleName() + (taskName != null ? "_" + taskName : "") + "_" + newThread.getName();
                    newThread.setName(threadName);
                    return newThread;
                }
            };
            this.threadPool = Executors.newCachedThreadPool(threadFactory);
        }
    }

    public FutureTask<R> run(Callable<R> task, long timeoutMs, boolean cancelTaskIfTimeout, boolean interruptIfTimeout) throws TimeoutException, InterruptedException, ExecutionException {
        return this.run(task, timeoutMs, cancelTaskIfTimeout);
    }

    public FutureTask<R> run(Callable<R> task, long timeoutMs, boolean cancelTaskIfTimeout) throws TimeoutException, InterruptedException, ExecutionException {
        FutureTask<R> futureTask = new FutureTask<R>(task);
        this.run(futureTask, timeoutMs, cancelTaskIfTimeout);
        return futureTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R run(FutureTask<R> futureTask, long timeoutMs, boolean cancelAndInterruptTaskIfTimeout) throws InterruptedException, ExecutionException, TimeoutException {
        this.threadPool.execute(futureTask);
        try {
            futureTask.get(timeoutMs, TimeUnit.MILLISECONDS);
        }
        finally {
            if (cancelAndInterruptTaskIfTimeout) {
                futureTask.cancel(true);
            }
        }
        return futureTask.get();
    }

    public void release() {
        this.threadPool.shutdown();
        try {
            if (!this.threadPool.awaitTermination(10L, TimeUnit.SECONDS)) {
                this.threadPool.shutdownNow();
                this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
        }
        catch (InterruptedException ie) {
            this.threadPool.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

