/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;

public class ContentType {
    static final String DEFAULT_ENCODING = System.getProperty("org.talend.components.rest.default_encoding", StandardCharsets.UTF_8.name());
    public static final String HEADER_KEY = "Content-Type";
    public static final String CHARSET_KEY = "charset=";

    private ContentType() {
    }

    public static String getCharsetName(Map<String, String> headers) {
        return ContentType.getCharsetName(headers, DEFAULT_ENCODING);
    }

    public static String getCharsetName(Map<String, String> headers, String defaultCharsetName) {
        String contentType = Optional.ofNullable(headers.get(HEADER_KEY)).orElse(defaultCharsetName);
        if (contentType == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        int split = contentType.indexOf(59);
        int previous = 0;
        while (split > 0) {
            values.add(contentType.substring(previous, split).trim());
            previous = split + 1;
            split = contentType.indexOf(59, previous);
        }
        if (previous == 0) {
            values.add(contentType);
        } else {
            String substring = contentType.substring(previous);
            values.add(substring.trim());
        }
        String encoding = values.stream().filter(h -> h.startsWith(CHARSET_KEY)).map(h -> h.substring(CHARSET_KEY.length())).findFirst().orElse(defaultCharsetName);
        return encoding;
    }
}

