/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;

public final class DefaultConfigurationValues {
    public static final String HTTP_CLIENT_CONNECT_TIMEOUT = "org.talend.http.client.connection.timeout";
    public static final String HTTP_CLIENT_RECEIVE_TIMEOUT = "org.talend.http.client.receive.timeout";
    public static final String HTTP_CLIENT_EXPIRESIN_TOKEN_SECURITY_DURATION = "org.talend.http.client.token.expiresin.security.duration";
    public static final String HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN = "org.talend.http.client.url.place.holder.begin";
    public static final String HTTP_CLIENT_URL_PLACE_HOLDER_END = "org.talend.http.client.url.place.holder.end";
    public static final String HTTP_CLIENT_ACCEPT_REDIRECTIONS = "org.talend.http.client.accept.redirection";
    public static final String HTTP_CLIENT_MAX_NUMBER_REDIRECTIONS_ON_SAME_URI = "org.talend.http.client.max.number.redirections.on.same.host";
    public static final String HTTP_CLIENT_ACCEPT_ONLY_SAME_HOST_REDIRECTIONS = "org.talend.http.client.accept.only.same.host.redirections";
    public static final String HTTP_CLIENT_ACCEPT_RELATIVE_REDIRECTIONS = "org.talend.http.client.accept.relative.redirections";
    public static final String HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN = "org.talend.http.client.oauth.token.forced.expires_in";
    public static long HTTP_CLIENT_CONNECT_TIMEOUT_VALUE;
    public static long HTTP_CLIENT_RECEIVE_TIMEOUT_VALUE;
    public static long HTTP_CLIENT_EXPIRESIN_TOKEN_SECURITY_DURATION_VALUE;
    public static boolean HTTP_CLIENT_ACCEPT_REDIRECTIONS_VALUE;
    public static int HTTP_CLIENT_MAX_NUMBER_REDIRECTIONS_ON_SAME_URI_VALUE;
    public static boolean HTTP_CLIENT_ACCEPT_ONLY_SAME_HOST_REDIRECTIONS_VALUE;
    public static boolean HTTP_CLIENT_ACCEPT_RELATIVE_REDIRECTIONS_VALUE;
    public static String HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN_VALUE;
    public static String HTTP_CLIENT_URL_PLACE_HOLDER_END_VALUE;
    public static long HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN_VALUE;
    public static final int HTTP_CLIENT_CONNECT_TIMEOUT_DEFAULT_VALUE = 30000;
    public static final int HTTP_CLIENT_RECEIVE_TIMEOUT_DEFAULT_VALUE = 120000;
    public static final int HTTP_CLIENT_EXPIRESIN_TOKEN_SECURITY_DURATION_DEFAULT_VALUE = 5000;
    public static final boolean HTTP_CLIENT_ACCEPT_REDIRECTIONS_DEFAULT_VALUE = true;
    public static final int HTTP_CLIENT_MAX_NUMBER_REDIRECTIONS_ON_SAME_URI_DEFAULT_VALUE = 3;
    public static final boolean HTTP_CLIENT_ACCEPT_ONLY_SAME_HOST_REDIRECTIONS_DEFAULT_VALUE = false;
    public static final boolean HTTP_CLIENT_ACCEPT_RELATIVE_REDIRECTIONS_DEFAULT_VALUE = true;
    public static final long HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN_DEFAULT_VALUE = Long.MIN_VALUE;
    public static final String HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN_DEFAULT_VALUE = "{";
    public static final String HTTP_CLIENT_URL_PLACE_HOLDER_END_DEFAULT_VALUE = "}";
    private static Map<String, String> varEnvNameCache;

    public static void reload() {
        HTTP_CLIENT_CONNECT_TIMEOUT_VALUE = DefaultConfigurationValues.getValueAsLong(HTTP_CLIENT_CONNECT_TIMEOUT, 30000L);
        HTTP_CLIENT_RECEIVE_TIMEOUT_VALUE = DefaultConfigurationValues.getValueAsLong(HTTP_CLIENT_RECEIVE_TIMEOUT, 120000L);
        HTTP_CLIENT_EXPIRESIN_TOKEN_SECURITY_DURATION_VALUE = DefaultConfigurationValues.getValueAsLong(HTTP_CLIENT_EXPIRESIN_TOKEN_SECURITY_DURATION, 5000L);
        HTTP_CLIENT_ACCEPT_REDIRECTIONS_VALUE = DefaultConfigurationValues.getValueAsBoolean(HTTP_CLIENT_ACCEPT_REDIRECTIONS, true);
        HTTP_CLIENT_MAX_NUMBER_REDIRECTIONS_ON_SAME_URI_VALUE = DefaultConfigurationValues.getValueAsInt(HTTP_CLIENT_MAX_NUMBER_REDIRECTIONS_ON_SAME_URI, 3);
        HTTP_CLIENT_ACCEPT_ONLY_SAME_HOST_REDIRECTIONS_VALUE = DefaultConfigurationValues.getValueAsBoolean(HTTP_CLIENT_ACCEPT_ONLY_SAME_HOST_REDIRECTIONS, false);
        HTTP_CLIENT_ACCEPT_RELATIVE_REDIRECTIONS_VALUE = DefaultConfigurationValues.getValueAsBoolean(HTTP_CLIENT_ACCEPT_RELATIVE_REDIRECTIONS, true);
        HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN_VALUE = DefaultConfigurationValues.getValue(HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN, HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN_DEFAULT_VALUE);
        HTTP_CLIENT_URL_PLACE_HOLDER_END_VALUE = DefaultConfigurationValues.getValue(HTTP_CLIENT_URL_PLACE_HOLDER_END, HTTP_CLIENT_URL_PLACE_HOLDER_END_DEFAULT_VALUE);
        HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN_VALUE = DefaultConfigurationValues.getValueAsLong(HTTP_CLIENT_OAUTH_TOKEN_FORCED_EXPIRES_IN, Long.MIN_VALUE);
    }

    public static int getValueAsInt(String key, int def) {
        String val = DefaultConfigurationValues.getValue(key);
        return val == null ? def : Integer.parseInt(val);
    }

    public static long getValueAsLong(String key, long def) {
        String val = DefaultConfigurationValues.getValue(key);
        return val == null ? def : Long.parseLong(val);
    }

    public static boolean getValueAsBoolean(String key, boolean def) {
        String val = DefaultConfigurationValues.getValue(key);
        return val == null ? def : Boolean.parseBoolean(val);
    }

    public static String getValue(String key, String def) {
        String val = DefaultConfigurationValues.getValue(key);
        return Optional.ofNullable(val).orElse(def);
    }

    private static String getValue(String key) {
        String val = System.getenv(DefaultConfigurationValues.getVarEnvName(key));
        if (val == null) {
            val = System.getProperty(key);
        }
        return val;
    }

    public static String getVarEnvName(String propertyName) {
        if (varEnvNameCache == null) {
            varEnvNameCache = new HashMap<String, String>();
        }
        return varEnvNameCache.computeIfAbsent(propertyName, k -> k.replaceAll("\\.", "_").toUpperCase());
    }

    @Generated
    private DefaultConfigurationValues() {
    }

    static {
        DefaultConfigurationValues.reload();
    }
}

