/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api;

import jakarta.ws.rs.core.NewCookie;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.talend.components.common.httpclient.api.HTTPClientException;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.authentication.Token;

public interface HTTPClient<C> {
    public C getNestedClient();

    @Deprecated
    default public void setOAuth20Token(Token token) {
        throw new UnsupportedOperationException("Oauth token retrieve is handled inside of #invoke() method.");
    }

    public HTTPResponse invoke() throws HTTPClientException;

    public static class Status {
        private final int code;
        private final String reason;
        private final String family;

        public String getCodeWithReason() {
            return String.format("%s %s", this.code, this.reason);
        }

        @Generated
        public Status(int code, String reason, String family) {
            this.code = code;
            this.reason = reason;
            this.family = family;
        }

        @Generated
        public int getCode() {
            return this.code;
        }

        @Generated
        public String getReason() {
            return this.reason;
        }

        @Generated
        public String getFamily() {
            return this.family;
        }
    }

    public static interface HTTPResponse<R> {
        public Status getStatus();

        public boolean isSuccess();

        public Map<String, String> getHeaders();

        public String getBodyAsString() throws HTTPClientException;

        public InputStream getBodyAsStream() throws HTTPClientException;

        public R getNestedResponse();

        public String getEncoding();

        @Deprecated
        default public void setOAuth20Token(Token token) {
            throw new UnsupportedOperationException("Oauth tokens is handled inside of #invoke() method.");
        }

        @Deprecated
        default public Optional<Token> getOAuth20Token() {
            throw new UnsupportedOperationException("Token can be retrieved from OAuth20FlowExecutor callable future execution result.");
        }

        public Optional<QueryConfiguration> nextPageQueryConfiguration() throws HTTPClientException;

        public int getLastPageCount() throws HTTPClientException;

        default public int getContentLength() {
            String header = this.getHeaders().get("Content-Length");
            if (header != null) {
                try {
                    return Integer.parseInt(String.valueOf(header));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return -1;
        }

        default public Map<String, NewCookie> getCookies() {
            return Collections.emptyMap();
        }
    }
}

