/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.api;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.talend.components.common.httpclient.api.BodyFormat;
import org.talend.components.common.httpclient.api.DefaultConfigurationValues;
import org.talend.components.common.httpclient.api.KeyValuePair;
import org.talend.components.common.httpclient.api.ProxyConfiguration;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.ResponseFormat;
import org.talend.components.common.httpclient.api.RetryWithBackoff;
import org.talend.components.common.httpclient.api.attachments.AttachmentsConfiguration;
import org.talend.components.common.httpclient.api.attachments.UploadFileConfig;
import org.talend.components.common.httpclient.api.authentication.AuthenticationType;
import org.talend.components.common.httpclient.api.authentication.LoginPassword;
import org.talend.components.common.httpclient.api.authentication.OAuth20;
import org.talend.components.common.httpclient.api.authentication.apikey.APIKeyDestination;
import org.talend.components.common.httpclient.api.authentication.apikey.ApiKey;
import org.talend.components.common.httpclient.api.authentication.apikey.ApiKeyFactory;
import org.talend.components.common.httpclient.api.authentication.apikey.ApiKeyHeader;
import org.talend.components.common.httpclient.api.authentication.apikey.ApiKeyParam;
import org.talend.components.common.httpclient.api.jsondecorator.CastConfig;
import org.talend.components.common.httpclient.api.jsondecorator.FilterConfig;
import org.talend.components.common.httpclient.api.pagination.OffsetLimitPagination;
import org.talend.components.common.httpclient.api.pagination.PaginationParametersLocation;
import org.talend.components.common.httpclient.api.substitutor.MapDictionary;
import org.talend.components.common.httpclient.api.substitutor.Substitutor;
import org.talend.components.common.httpclient.pagination.PaginationStrategy;
import org.talend.components.common.httpclient.pagination.PaginationStrategyFactory;
import org.talend.components.jsondecorator.api.JsonDecoratorBuilder;

public class QueryConfigurationBuilder {
    private QueryConfiguration queryConfiguration;
    private QueryConfigurationBuilder oauthCallBuilder;

    private QueryConfigurationBuilder(QueryConfiguration config) {
        this.queryConfiguration = config;
    }

    public static QueryConfigurationBuilder create(String url) {
        url = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.URL", url, true);
        QueryConfiguration config = new QueryConfiguration();
        config.setUrl(url);
        return new QueryConfigurationBuilder(config);
    }

    public QueryConfigurationBuilder setConnectionTimeout(long timeout) {
        QueryConfigurationBuilder.notNegative("http.configuration.connectionTimeout", timeout);
        this.queryConfiguration.setConnectionTimeout(timeout);
        return this;
    }

    public QueryConfigurationBuilder bypassCertificateConfiguration(boolean bypass) {
        this.queryConfiguration.setBypassCertificateValidation(bypass);
        return this;
    }

    public QueryConfigurationBuilder setReceiveTimeout(long timeout) {
        QueryConfigurationBuilder.notNegative("http.configuration..receiveTimeout", timeout);
        this.queryConfiguration.setReceiveTimeout(timeout);
        return this;
    }

    public QueryConfigurationBuilder setMethod(String method) {
        method = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.method", method, true);
        this.queryConfiguration.setMethod(method);
        return this;
    }

    public QueryConfigurationBuilder setNoAuthentication() {
        this.queryConfiguration.setAuthenticationType(AuthenticationType.None);
        this.queryConfiguration.setLoginPassword(null);
        return this;
    }

    public QueryConfigurationBuilder setBasicAuthentication(String login, String password) {
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.basic.login", login, false);
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.basic.password", password, false);
        LoginPassword lp = new LoginPassword(login, password);
        this.queryConfiguration.setAuthenticationType(AuthenticationType.Basic);
        this.queryConfiguration.setLoginPassword(lp);
        return this;
    }

    public QueryConfigurationBuilder setDigestAuthentication(String login, String password) {
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.digest.login", login, false);
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.digest.password", password, false);
        LoginPassword lp = new LoginPassword(login, password);
        this.queryConfiguration.setAuthenticationType(AuthenticationType.Digest);
        this.queryConfiguration.setLoginPassword(lp);
        return this;
    }

    public QueryConfigurationBuilder setNTLMAuthentication(String login, String password) {
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.ntlm.login", login, false);
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.ntlm.password", password, false);
        LoginPassword lp = new LoginPassword(login, password);
        this.queryConfiguration.setAuthenticationType(AuthenticationType.NTLM);
        this.queryConfiguration.setLoginPassword(lp);
        return this;
    }

    public QueryConfigurationBuilder setAuthorizationToken(String prefix, String token) {
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.authorization.token", token, false);
        this.queryConfiguration.setAuthenticationType(AuthenticationType.Authorization_Token);
        if (prefix != null && !(prefix = prefix.trim()).isEmpty()) {
            token = String.format("%s %s", prefix, token);
        }
        this.queryConfiguration.setAuthorizationToken(token);
        return this;
    }

    public QueryConfigurationBuilder setAuthorizationToken(String token) {
        return this.setAuthorizationToken(null, token);
    }

    public QueryConfigurationBuilder setOAuth20ClientCredential(OAuth20.AuthentMode mode, String tokenEndpoint, String clientId, String clientSecret, List<KeyValuePair> params, List<KeyValuePair> headers) {
        QueryConfigurationBuilder.notNull("http.configuration.authentication.oauth.client_credential.authentication.mode", (Object)mode);
        tokenEndpoint = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.oauth.client_credential.token_endpoint", tokenEndpoint, true);
        clientId = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.authentication.oauth.client_credential.clientId", clientId, true);
        QueryConfigurationBuilder.notNull("http.configuration.authentication.oauth.client_credential.clientSecret", clientSecret);
        QueryConfigurationBuilder oauth20QueryConfigurationBuilder = QueryConfigurationBuilder.create(tokenEndpoint);
        oauth20QueryConfigurationBuilder.addXWWWFormURLEncodedBodyParam(OAuth20.Keys.grant_type.name(), OAuth20.GrantType.client_credentials.name());
        params.stream().forEach(kvp -> oauth20QueryConfigurationBuilder.addXWWWFormURLEncodedBodyParam(kvp.getKey(), kvp.getValue()));
        String concatParams = params.stream().map(kvp -> kvp.getKey() + "=" + kvp.getValue()).collect(Collectors.joining(";"));
        switch (mode) {
            case FORM: {
                oauth20QueryConfigurationBuilder.addXWWWFormURLEncodedBodyParam(OAuth20.Keys.client_id.name(), clientId);
                oauth20QueryConfigurationBuilder.addXWWWFormURLEncodedBodyParam(OAuth20.Keys.client_secret.name(), clientSecret);
                break;
            }
            case BASIC: {
                oauth20QueryConfigurationBuilder.setBasicAuthentication(clientId, clientSecret);
                break;
            }
            case DIGEST: {
                oauth20QueryConfigurationBuilder.setDigestAuthentication(clientId, clientSecret);
            }
        }
        oauth20QueryConfigurationBuilder.setMethod("POST");
        headers.stream().forEach(h -> oauth20QueryConfigurationBuilder.addHeader(h.getKey(), h.getValue()));
        this.queryConfiguration.setAuthenticationType(AuthenticationType.OAuth20_Client_Credential);
        this.setOauthCallBuilder(oauth20QueryConfigurationBuilder);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(tokenEndpoint.getBytes(StandardCharsets.UTF_8));
            md.update(OAuth20.GrantType.client_credentials.name().getBytes(StandardCharsets.UTF_8));
            md.update(concatParams.getBytes(StandardCharsets.UTF_8));
            md.update(clientId.getBytes(StandardCharsets.UTF_8));
            md.update(clientSecret.getBytes(StandardCharsets.UTF_8));
            byte[] digest = md.digest();
            this.queryConfiguration.setOAuthTokenCacheKey(Optional.of(new String(digest, StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return this;
    }

    public QueryConfigurationBuilder addPathParam(String key, String value) {
        key = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.pathParameter", key, true);
        this.queryConfiguration.getUrlPathParams().put(key, value);
        return this;
    }

    public QueryConfigurationBuilder addHeader(String key, String value) {
        key = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.header", key, true);
        this.queryConfiguration.getHeaders().add(new KeyValuePair(key, value));
        return this;
    }

    public QueryConfigurationBuilder addQueryParam(String key, String value) {
        key = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.queryParameter", key, true);
        this.queryConfiguration.getQueryParams().add(new KeyValuePair(key, value));
        return this;
    }

    @Deprecated
    public QueryConfigurationBuilder setAPIKey(APIKeyDestination destination, String name, String prefix, String token) {
        QueryConfigurationBuilder.notNull("http.configuration.apikey.destination", (Object)destination);
        if (APIKeyDestination.QUERY_PARAMETERS == destination) {
            return this.setAPIKey(ApiKeyFactory.createParamApiKey(name, token));
        }
        return this.setAPIKey(ApiKeyFactory.createHeaderApiKey(name, prefix, token));
    }

    public QueryConfigurationBuilder setAPIKey(ApiKey apiKey) {
        if (apiKey instanceof ApiKeyHeader) {
            this.addHeader(apiKey.getName(), apiKey.getToken());
            this.queryConfiguration.setApiKeyHeaderName(apiKey.getName());
        } else if (apiKey instanceof ApiKeyParam) {
            this.addQueryParam(apiKey.getName(), apiKey.getToken());
        }
        this.queryConfiguration.setAuthenticationType(AuthenticationType.API_Key);
        return this;
    }

    public QueryConfigurationBuilder setRawTextBody(String content) {
        this.setRawTextBody(content, BodyFormat.TEXT);
        return this;
    }

    public QueryConfigurationBuilder setJSONBody(String content) {
        this.setRawTextBody(content, BodyFormat.JSON);
        return this;
    }

    public QueryConfigurationBuilder setXMLBody(String content) {
        this.setRawTextBody(content, BodyFormat.XML);
        return this;
    }

    public QueryConfigurationBuilder setBinaryBody(String filePath) {
        QueryConfigurationBuilder.notEmptyNorNull("http.configuration.body.filePath", filePath, true);
        this.setFilePath(filePath, BodyFormat.BINARY);
        return this;
    }

    private QueryConfigurationBuilder setFilePath(String filePath, BodyFormat type) {
        this.checkBodyAlreadySet(type);
        this.queryConfiguration.setFilePath(filePath);
        this.queryConfiguration.setBodyType(type);
        return this;
    }

    private void setRawTextBody(String content, BodyFormat type) {
        this.checkBodyAlreadySet(type);
        this.queryConfiguration.setBodyType(type);
        this.queryConfiguration.setPlainTextBody(QueryConfigurationBuilder.changeNullToEmpty(content, false));
    }

    public QueryConfigurationBuilder addMultipartFormDataBodyParam(String key, String value) {
        this.addBodyParameter(key, value, BodyFormat.FORM_DATA);
        return this;
    }

    public QueryConfigurationBuilder downloadAttachments(String folder, String fileName) {
        this.downloadAttachments(folder);
        this.queryConfiguration.getAttachmentsConfiguration().setSpecifyAttachmentName(true);
        this.queryConfiguration.getAttachmentsConfiguration().setAttachmentName(fileName);
        return this;
    }

    public QueryConfigurationBuilder downloadAttachments(String folder) {
        AttachmentsConfiguration attachmentsConfiguration = this.queryConfiguration.getAttachmentsConfiguration();
        attachmentsConfiguration.setDownloadAttachments(true);
        attachmentsConfiguration.setAttachmentsDownloadDirectory(folder);
        return this;
    }

    public QueryConfigurationBuilder addAttachment(UploadFileConfig att) {
        this.checkBodyAlreadySet(BodyFormat.FORM_DATA);
        this.queryConfiguration.getAttachmentsConfiguration().getUploadAttachments().add(att);
        this.queryConfiguration.setBodyType(BodyFormat.FORM_DATA);
        return this;
    }

    public QueryConfigurationBuilder decompressResponsePayload(boolean decompress) {
        this.queryConfiguration.setDecompressResponsePayload(decompress);
        return this;
    }

    public QueryConfigurationBuilder addXWWWFormURLEncodedBodyParam(String key, String value) {
        this.addBodyParameter(key, value, BodyFormat.X_WWW_FORM_URLENCODED);
        return this;
    }

    public QueryConfigurationBuilder setMaxNumberOfAcceptedRedirectionsOnSameURI(int n) {
        this.queryConfiguration.setMaxNumberOfAcceptedRedirectionsOnSameURI(n);
        return this;
    }

    public QueryConfigurationBuilder acceptRedirection(boolean accept) {
        this.queryConfiguration.setAcceptRedirections(accept);
        return this;
    }

    public QueryConfigurationBuilder acceptOnlySameHostRedirection(boolean b) {
        this.queryConfiguration.setAcceptOnlySameHostRedirection(b);
        return this;
    }

    public QueryConfigurationBuilder acceptRelativeURLRedirection(boolean b) {
        this.queryConfiguration.setAcceptRelativeURLRedirection(b);
        return this;
    }

    public QueryConfigurationBuilder setAllowedURIRedirection(String allowedURIRedirection) {
        allowedURIRedirection = QueryConfigurationBuilder.notEmptyNorNull("allowed redirect URI", allowedURIRedirection, true);
        this.queryConfiguration.setAllowedURIRedirection(allowedURIRedirection);
        return this;
    }

    public QueryConfigurationBuilder setResponseFormat(ResponseFormat responseFormat) {
        QueryConfigurationBuilder.notNull("http.configuration.responseFormat", (Object)responseFormat);
        this.queryConfiguration.setResponseFormat(responseFormat);
        return this;
    }

    private void addBodyParameter(String key, String value, BodyFormat type) {
        this.checkBodyAlreadySet(type);
        key = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.body.queryParameter.name", key, true);
        this.queryConfiguration.setBodyType(type);
        this.queryConfiguration.getBodyQueryParams().add(new KeyValuePair(key, QueryConfigurationBuilder.changeNullToEmpty(value, false)));
    }

    public QueryConfigurationBuilder setHTTPProxy(String host, int port, String login, String password) {
        return this.setProxy(ProxyConfiguration.ProxyType.HTTP, host, port, login, password);
    }

    public QueryConfigurationBuilder setSOCKSProxy(String host, int port) {
        return this.setProxy(ProxyConfiguration.ProxyType.SOCKS, host, port, null, null);
    }

    protected QueryConfigurationBuilder setProxy(ProxyConfiguration.ProxyType type, String host, int port, String login, String password) {
        host = QueryConfigurationBuilder.notEmptyNorNull("http.configuration.proxy.host", host, true);
        if (login != null) {
            login = login.trim();
        }
        QueryConfigurationBuilder.notNegative("http.configuration.proxy.port", port);
        this.queryConfiguration.setProxy(new ProxyConfiguration(type, host, port, login, password));
        return this;
    }

    public QueryConfigurationBuilder setOffsetLimitPagination(PaginationParametersLocation location, String offsetParamName, String offsetValue, String limitParamName, String limitValue, String elementsPath) {
        OffsetLimitPagination offsetLimitPagination = new OffsetLimitPagination(location, offsetParamName, offsetValue, limitParamName, limitValue, elementsPath);
        this.queryConfiguration.setOffsetLimitPagination(offsetLimitPagination);
        return this;
    }

    public QueryConfigurationBuilder setRetryWithExponentialBackoff(int backoff, int factor, int maxAttempts) {
        this.queryConfiguration.setRetryWithBackoff(new RetryWithBackoff(backoff, factor, maxAttempts));
        return this;
    }

    public QueryConfigurationBuilder addJSONDecoratorCast(String path, JsonDecoratorBuilder.ValueTypeExtended type, String defaultValue) {
        path = QueryConfigurationBuilder.notEmptyNorNull("http.response.json.decorator.cast.path", path, true);
        if (this.queryConfiguration.getResponseFormat() != ResponseFormat.JSON) {
            throw new IllegalArgumentException(String.format("You can't define a JSON decorator with a '%s' response format, only for JSON.", new Object[]{this.queryConfiguration.getResponseFormat()}));
        }
        this.queryConfiguration.getJsonDecoratorConfig().addCast(new CastConfig(path, type, defaultValue));
        return this;
    }

    public QueryConfigurationBuilder addJSONDecoratorFilter(String path, JsonDecoratorBuilder.ValueTypeExtended type) {
        path = QueryConfigurationBuilder.notEmptyNorNull("http.response.json.decorator.filter.path", path, true);
        if (this.queryConfiguration.getResponseFormat() != ResponseFormat.JSON) {
            throw new IllegalArgumentException(String.format("You can't define a JSON decorator for a '%s' response format, it is only available for JSON.", this.queryConfiguration.getResponseFormat() == null ? "undefined" : this.queryConfiguration.getResponseFormat()));
        }
        this.queryConfiguration.getJsonDecoratorConfig().addFilter(new FilterConfig(path, type));
        return this;
    }

    public QueryConfigurationBuilder loadCookies(String cookiesDirectory) {
        this.queryConfiguration.setReadCookies(true);
        this.queryConfiguration.setCookieContainerDirectory(cookiesDirectory);
        return this;
    }

    public QueryConfigurationBuilder saveCookies(String cookiesDirectory) {
        this.queryConfiguration.setSaveCookies(true);
        this.queryConfiguration.setCookieContainerDirectory(cookiesDirectory);
        return this;
    }

    public QueryConfigurationBuilder keepSession(boolean keepSession) {
        this.queryConfiguration.setKeepSession(keepSession);
        return this;
    }

    static String changeNullToEmpty(String value, boolean trim) {
        return value == null ? "" : (trim ? value.trim() : value);
    }

    static void notNull(String property, Object value) {
        if (value != null) {
            return;
        }
        throw new IllegalArgumentException(String.format("The property %s can't receive null as value.", property));
    }

    static void notNegative(String key, long value) {
        if (value < 0L) {
            throw new IllegalArgumentException(String.format("%s value must be a positive value: %s", key, value));
        }
    }

    private void checkBodyAlreadySet(BodyFormat type) {
        if (this.queryConfiguration.getBodyType() != null && this.queryConfiguration.getBodyType() != type) {
            throw new IllegalArgumentException("Body has already been set, you can't change its type.");
        }
    }

    static String notEmptyNorNull(String property, String value, boolean trim) {
        QueryConfigurationBuilder.notNull(property, value);
        String string = value = trim ? value.trim() : value;
        if (!value.isEmpty()) {
            return value;
        }
        throw new IllegalArgumentException(String.format("The property %s can't receive empty value.", property));
    }

    public QueryConfiguration build() {
        this.updateHeaders();
        this.initiatePagination();
        this.substituteUrl();
        this.finalizeOAuthConfiguration();
        return this.queryConfiguration;
    }

    public QueryConfiguration build(Substitutor substitutor) {
        this.initiatePagination();
        this.substitute(substitutor);
        Optional<QueryConfigurationBuilder> oauthCallBuilderOptional = this.getOauthCallBuilder();
        if (oauthCallBuilderOptional.isPresent()) {
            oauthCallBuilderOptional.get().substitute(substitutor);
        }
        return this.build();
    }

    private void updateHeaders() {
        Set headersKey = this.queryConfiguration.getHeaders().stream().map(kv -> kv.getKey().toLowerCase()).collect(Collectors.toSet());
        if (this.queryConfiguration.getResponseFormat() != null && !headersKey.contains("accept")) {
            this.queryConfiguration.getHeaders().add(new KeyValuePair("Accept", this.queryConfiguration.getResponseFormat().getAcceptedType()));
        }
    }

    private void initiatePagination() {
        if (this.queryConfiguration.isInitPaginationDone()) {
            return;
        }
        PaginationStrategy paginationStrategy = PaginationStrategyFactory.getPaginationStrategy(this.queryConfiguration);
        paginationStrategy.initiatePagination(this.queryConfiguration);
    }

    private void setOauthCallBuilder(QueryConfigurationBuilder oauthCallBuilder) {
        this.oauthCallBuilder = oauthCallBuilder;
    }

    private Optional<QueryConfigurationBuilder> getOauthCallBuilder() {
        return Optional.ofNullable(this.oauthCallBuilder);
    }

    private void finalizeOAuthConfiguration() {
        if (this.queryConfiguration.getAuthenticationType() == AuthenticationType.OAuth20_Client_Credential && this.getOauthCallBuilder().isPresent()) {
            this.queryConfiguration.setOauthCall(this.getOauthCallBuilder().get().build());
            QueryConfiguration oauthCallConfig = this.queryConfiguration.getOauthCall().getQueryConfiguration();
            oauthCallConfig.setBypassCertificateValidation(this.queryConfiguration.isBypassCertificateValidation());
            oauthCallConfig.setAcceptRedirections(this.queryConfiguration.isAcceptRedirections());
            oauthCallConfig.setMaxNumberOfAcceptedRedirectionsOnSameURI(this.queryConfiguration.getMaxNumberOfAcceptedRedirectionsOnSameURI());
            oauthCallConfig.setAllowedURIRedirection(this.queryConfiguration.getAllowedURIRedirection());
            oauthCallConfig.setAcceptRelativeURLRedirection(this.queryConfiguration.isAcceptRelativeURLRedirection());
            oauthCallConfig.setAcceptOnlySameHostRedirection(this.queryConfiguration.isAcceptOnlySameHostRedirection());
        }
    }

    private void substituteUrl() {
        MapDictionary pathParamsDictionary = new MapDictionary(this.queryConfiguration.getUrlPathParams());
        Substitutor.PlaceholderConfiguration placeholderConfiguration = new Substitutor.PlaceholderConfiguration(DefaultConfigurationValues.HTTP_CLIENT_URL_PLACE_HOLDER_BEGIN_VALUE, DefaultConfigurationValues.HTTP_CLIENT_URL_PLACE_HOLDER_END_VALUE);
        Substitutor urlSubstitutor = new Substitutor(placeholderConfiguration, pathParamsDictionary);
        String substitutedURL = urlSubstitutor.replace(this.queryConfiguration.getUrl());
        this.queryConfiguration.setUrl(substitutedURL);
    }

    private void substitute(Substitutor substitutor) {
        this.queryConfiguration.setUrl(substitutor.replace(this.queryConfiguration.getUrl()));
        this.queryConfiguration.setMethod(substitutor.replace(this.queryConfiguration.getMethod()));
        if (this.queryConfiguration.getLoginPassword() != null) {
            this.queryConfiguration.getLoginPassword().setLogin(substitutor.replace(this.queryConfiguration.getLoginPassword().getLogin()));
            this.queryConfiguration.getLoginPassword().setPassword(substitutor.replace(this.queryConfiguration.getLoginPassword().getPassword()));
        }
        this.queryConfiguration.setAuthorizationToken(substitutor.replace(this.queryConfiguration.getAuthorizationToken()));
        this.queryConfiguration.setAllowedURIRedirection(substitutor.replace(this.queryConfiguration.getAllowedURIRedirection()));
        if (this.queryConfiguration.getProxy() != null) {
            this.queryConfiguration.getProxy().setHost(substitutor.replace(this.queryConfiguration.getProxy().getHost()));
            if (this.queryConfiguration.getProxy().getCredentials() != null) {
                this.queryConfiguration.getProxy().getCredentials().setLogin(substitutor.replace(this.queryConfiguration.getProxy().getCredentials().getLogin()));
                this.queryConfiguration.getProxy().getCredentials().setPassword(substitutor.replace(this.queryConfiguration.getProxy().getCredentials().getPassword()));
            }
        }
        Map<String, String> substitutedURLPathParams = this.queryConfiguration.getUrlPathParams().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, p -> substitutor.replace((String)p.getValue())));
        this.queryConfiguration.setUrlPathParams(substitutedURLPathParams);
        List<KeyValuePair> substitutedKVPBody = this.queryConfiguration.getBodyQueryParams().stream().map(p -> new KeyValuePair(p.getKey(), substitutor.replace(p.getValue()))).collect(Collectors.toList());
        this.queryConfiguration.setBodyQueryParams(substitutedKVPBody);
        if (this.queryConfiguration.getPlainTextBody() != null) {
            String substitutedPlainTextBody = substitutor.replace(this.queryConfiguration.getPlainTextBody());
            this.queryConfiguration.setPlainTextBody(substitutedPlainTextBody);
        }
        List<KeyValuePair> substitutedHeaders = this.queryConfiguration.getHeaders().stream().map(p -> new KeyValuePair(p.getKey(), substitutor.replace(p.getValue()))).collect(Collectors.toList());
        this.queryConfiguration.setHeaders(substitutedHeaders);
        List<KeyValuePair> substitutedHQueryParams = this.queryConfiguration.getQueryParams().stream().map(p -> new KeyValuePair(p.getKey(), substitutor.replace(p.getValue()))).collect(Collectors.toList());
        this.queryConfiguration.setQueryParams(substitutedHQueryParams);
    }
}

