/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf.cookies;

import jakarta.ws.rs.core.Cookie;
import java.net.URI;
import java.net.URISyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CookieMatcher.class);

    public static boolean isCookieMatch(Cookie c, String requestUrl) {
        try {
            URI url = new URI(requestUrl);
            String domain = c.getDomain();
            if (domain == null) {
                return CookieMatcher.pathMatch(url.getPath(), c.getPath());
            }
            String string = domain = domain.startsWith(".") ? domain.substring(1) : domain;
            if (url.getHost().equalsIgnoreCase(domain)) {
                return CookieMatcher.pathMatch(url.getPath(), c.getPath());
            }
        }
        catch (URISyntaxException e) {
            log.debug("Can not check if cookie match the request URL: " + requestUrl, (Throwable)e);
        }
        return false;
    }

    public static boolean pathMatch(String uriPath, String cookiePath) {
        String path = cookiePath;
        if (path == null) {
            path = "/";
        }
        if (!CookieMatcher.isSlash(path) && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (uriPath.startsWith(path)) {
            if (CookieMatcher.isSlash(path)) {
                return true;
            }
            if (uriPath.length() == path.length()) {
                return true;
            }
            return CookieMatcher.isASubPath(uriPath, path);
        }
        return false;
    }

    private static boolean isASubPath(String uriPath, String path) {
        return uriPath.charAt(path.length()) == '/';
    }

    private static boolean isSlash(String path) {
        return path.equals("/");
    }

    @Generated
    private CookieMatcher() {
    }
}

