/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf.cookies;

import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.NewCookie;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.impl.cxf.cookies.CookieFormatLine;

public class CookieService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CookieService.class);
    private static final String COOKIE_FILE_NAME = "cookies.json";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCookies(Map<String, NewCookie> newCookies, String cookieDirectory) {
        if (newCookies == null || newCookies.isEmpty()) {
            return;
        }
        try {
            Path cookieDir = Paths.get(cookieDirectory, new String[0]);
            if (!Files.exists(cookieDir, new LinkOption[0])) {
                Files.createDirectories(cookieDir, new FileAttribute[0]);
            }
            String string = cookieDirectory.intern();
            synchronized (string) {
                Path cookieFile = Paths.get(cookieDir.toAbsolutePath().toString(), COOKIE_FILE_NAME);
                HashMap<String, CookieFormatLine> existingCookies = new HashMap<String, CookieFormatLine>();
                if (Files.exists(cookieFile, new LinkOption[0])) {
                    for (CookieFormatLine cookieFormatLine : this.readCookieFile(cookieDirectory)) {
                        existingCookies.put(cookieFormatLine.getName(), cookieFormatLine);
                    }
                }
                for (Map.Entry entry : newCookies.entrySet()) {
                    existingCookies.put((String)entry.getKey(), new CookieFormatLine((String)entry.getKey(), (NewCookie)entry.getValue()));
                }
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(cookieFile.toFile()));){
                    for (Map.Entry entry : existingCookies.entrySet()) {
                        writer.write(((CookieFormatLine)entry.getValue()).asJson());
                        writer.newLine();
                    }
                }
            }
        }
        catch (Exception ex) {
            log.error("Can not save cookies file: " + cookieDirectory, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Cookie> loadCookies(String cookieDirectory) {
        ArrayList<Cookie> cookies = new ArrayList<Cookie>();
        String string = cookieDirectory.intern();
        synchronized (string) {
            try {
                for (CookieFormatLine cookie : this.readCookieFile(cookieDirectory)) {
                    if (this.isExpired(cookie)) continue;
                    String valueToParse = StringEscapeUtils.unescapeJson((String)cookie.getValueWithMetadata());
                    if (cookie.getDomain() != null) {
                        valueToParse = valueToParse + ";$Domain=" + cookie.getDomain();
                    }
                    cookies.add(Cookie.valueOf((String)valueToParse));
                }
            }
            catch (Exception ex) {
                log.error("Can not read cookies file " + cookieDirectory, (Throwable)ex);
            }
        }
        return cookies;
    }

    private List<CookieFormatLine> readCookieFile(String cookieDirectory) throws IOException {
        ArrayList<CookieFormatLine> cookies = new ArrayList<CookieFormatLine>();
        Path cookieFile = Paths.get(cookieDirectory, COOKIE_FILE_NAME);
        if (Files.exists(cookieFile, new LinkOption[0]) && !Files.isDirectory(cookieFile, new LinkOption[0])) {
            String[] cookieLines;
            String cookieContent = this.readCookieFileContent(cookieFile.toAbsolutePath().toString());
            for (String cookieLine : cookieLines = cookieContent.split(System.lineSeparator())) {
                try {
                    CookieFormatLine cookie = CookieFormatLine.fromJson(cookieLine);
                    cookies.add(cookie);
                }
                catch (IllegalStateException e) {
                    log.debug("Can't parse cookie line: {}. Skipping", (Object)cookieLine, (Object)e);
                }
            }
        }
        return cookies;
    }

    private String readCookieFileContent(String absolutePath) throws IOException {
        StringBuilder cookieContent = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new FileReader(absolutePath));){
            while (reader.ready()) {
                cookieContent.append(reader.readLine()).append(System.lineSeparator());
            }
        }
        return cookieContent.toString();
    }

    private boolean isExpired(CookieFormatLine cookie) {
        return cookie.getExpiry() != null && cookie.getExpiry() < System.currentTimeMillis();
    }
}

