/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.impl.cxf.logfiltering;

import lombok.Generated;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.impl.cxf.logfiltering.OauthLog4jV1FilterManager;
import org.talend.components.common.httpclient.impl.cxf.logfiltering.OauthLog4jV2FilterManager;

public class CXFLogManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CXFLogManager.class);
    private static final String V1_FACTORY_CLASS_NAME = "org.slf4j.impl.Reload4jLoggerFactory";
    private static final String V2_FACTORY_CLASS_NAME = "org.apache.logging.slf4j.Log4jLoggerFactory";
    private static final String DEFAULT_SENSITIVE_HEADERS_CONTEXTUAL_VALUE = "Authorization,Proxy-Authorization";

    public static void injectLog4jFilter() {
        try {
            String loggerFactoryClass;
            if (System.getProperty("org.apache.cxf.Logger") == null) {
                System.setProperty("org.apache.cxf.Logger", "org.apache.cxf.common.logging.Slf4jLogger");
            }
            if (V1_FACTORY_CLASS_NAME.equals(loggerFactoryClass = LoggerFactory.getILoggerFactory().getClass().getCanonicalName())) {
                OauthLog4jV1FilterManager.addOauthFormLog4jV1Filter();
            } else if (V2_FACTORY_CLASS_NAME.equals(loggerFactoryClass)) {
                OauthLog4jV2FilterManager.addOauthFormLog4jV2Filter();
            } else {
                log.debug("Can't inject a LogFilter for unknown LoggerFactoryClass: {}", (Object)loggerFactoryClass);
            }
        }
        catch (Exception | NoClassDefFoundError e) {
            log.debug("Can't inject a LogFilter for Log4j, ignoring", e);
        }
    }

    public static void addSensitiveHeaderToCXFConfig(ClientConfiguration requestContext, String sensitiveHeaderName) {
        if (sensitiveHeaderName == null) {
            return;
        }
        StringBuilder sensitiveHeadersString = new StringBuilder(sensitiveHeaderName);
        Object contextualOldCXFConfigSensitiveHeaders = requestContext.getRequestContext().get("org.apache.http.sensitive.headers");
        if (contextualOldCXFConfigSensitiveHeaders == null) {
            sensitiveHeadersString.append(",").append(DEFAULT_SENSITIVE_HEADERS_CONTEXTUAL_VALUE);
        } else if (contextualOldCXFConfigSensitiveHeaders instanceof String) {
            sensitiveHeadersString.append(",").append(contextualOldCXFConfigSensitiveHeaders);
        }
        requestContext.getRequestContext().put("org.apache.http.sensitive.headers", sensitiveHeadersString.toString());
    }

    @Generated
    private CXFLogManager() {
    }
}

