/*
 * Decompiled with CFR 0.152.
 */
package org.talend.components.common.httpclient.retry;

import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.components.common.httpclient.api.QueryConfiguration;
import org.talend.components.common.httpclient.api.RetryWithBackoff;
import org.talend.components.common.httpclient.retry.RetryStrategy;

public class RetryWithExponentialBackOffStrategy
extends RetryStrategy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RetryWithExponentialBackOffStrategy.class);
    private int initialBackoff;
    private int backoff;
    private int factor;

    public RetryWithExponentialBackOffStrategy(RetryWithBackoff retryWithBackoff) {
        super(retryWithBackoff.getMaxAttempts());
        this.initialBackoff = retryWithBackoff.getBackoff();
        this.backoff = retryWithBackoff.getBackoff();
        this.factor = retryWithBackoff.getFactor();
    }

    private int getBackoffDuration() {
        this.backoff *= this.factor;
        return this.backoff;
    }

    @Override
    protected QueryConfiguration actionBeforeRetry(QueryConfiguration queryConfiguration) {
        try {
            Thread.sleep(this.getBackoffDuration());
        }
        catch (InterruptedException e) {
            log.error("Exponential backoff retry mechanism failed to wait.", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        return queryConfiguration;
    }

    @Generated
    public int getInitialBackoff() {
        return this.initialBackoff;
    }

    @Generated
    public int getBackoff() {
        return this.backoff;
    }

    @Generated
    public int getFactor() {
        return this.factor;
    }

    @Override
    @Generated
    public String toString() {
        return "RetryWithExponentialBackOffStrategy(super=" + super.toString() + ", initialBackoff=" + this.getInitialBackoff() + ", backoff=" + this.getBackoff() + ", factor=" + this.getFactor() + ")";
    }
}

