/*
 * Decompiled with CFR 0.152.
 */
package org.talend.parquet.data.simple.convert;

import org.apache.parquet.io.api.Converter;
import org.apache.parquet.io.api.GroupConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.Type;
import org.talend.parquet.data.Group;
import org.talend.parquet.data.simple.convert.SimplePrimitiveConverter;

class SimpleGroupConverter
extends GroupConverter {
    private final SimpleGroupConverter parent;
    private final int index;
    protected Group current;
    private Converter[] converters;

    SimpleGroupConverter(SimpleGroupConverter parent, int index, GroupType schema) {
        this.parent = parent;
        this.index = index;
        this.converters = new Converter[schema.getFieldCount()];
        for (int i = 0; i < this.converters.length; ++i) {
            Type type = schema.getType(i);
            this.converters[i] = type.isPrimitive() ? new SimplePrimitiveConverter(this, i) : new SimpleGroupConverter(this, i, type.asGroupType());
        }
    }

    public void start() {
        this.current = this.parent.getCurrentRecord().addGroup(this.index);
    }

    public Converter getConverter(int fieldIndex) {
        return this.converters[fieldIndex];
    }

    public void end() {
    }

    public Group getCurrentRecord() {
        return this.current;
    }
}

