/*
 * Decompiled with CFR 0.152.
 */
package org.talend.parquet.hadoop;

import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.talend.parquet.data.Group;
import org.talend.parquet.data.simple.convert.GroupRecordConverter;

public class TalendGroupReadSupport
extends ReadSupport<Group> {
    public ReadSupport.ReadContext init(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema) {
        String partialSchemaString = configuration.get("parquet.read.schema");
        MessageType requestedProjection = TalendGroupReadSupport.getSchemaForRead((MessageType)fileSchema, (String)partialSchemaString);
        return new ReadSupport.ReadContext(requestedProjection);
    }

    public RecordMaterializer<Group> prepareForRead(Configuration configuration, Map<String, String> keyValueMetaData, MessageType fileSchema, ReadSupport.ReadContext readContext) {
        return new GroupRecordConverter(readContext.getRequestedSchema());
    }
}

